/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model;

import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.core.model.MetadataHelper;

public class DateHierarchyHelper {
    private final INode mDateCat;
    private INode mYearCat;
    private INode mQuarterCat;
    private INode mMonthCat;
    private INode mDayOfMonthCat;

    public static DateHierarchyHelper forTemporalCategory(INode node) {
        if (null == node) {
            throw new IllegalArgumentException("node was null");
        }
        if (!node.isCategory()) {
            throw new IllegalArgumentException("node was not a category");
        }
        if (!node.getConcept().isTemporal()) {
            throw new IllegalArgumentException("node was not temporal");
        }
        INode dateCat = MetadataHelper.getDateHierarchyRoot(node);
        if (null == dateCat) {
            return new DateHierarchyHelper(node, false);
        }
        return new DateHierarchyHelper(dateCat);
    }

    public static DateHierarchyHelper forTemporalAttribute(INode node) {
        if (null == node) {
            throw new IllegalArgumentException("node was null");
        }
        if (!node.isAttribute()) {
            throw new IllegalArgumentException("node was not an attribute");
        }
        INode dateCat = MetadataHelper.getDateHierarchyRoot(node);
        if (null == dateCat) {
            return new DateHierarchyHelper(node, false);
        }
        return new DateHierarchyHelper(dateCat);
    }

    private DateHierarchyHelper(INode aNode, boolean generatedCalendar) {
        if (generatedCalendar) {
            this.mDateCat = aNode;
            this.mYearCat = MetadataHelper.getRelatedNodeWithConcept(this.mDateCat, "cYear", false);
            assert (null != this.mYearCat);
            this.mQuarterCat = MetadataHelper.getRelatedNodeWithConcept(this.mDateCat, "cQuarter", false);
            assert (null != this.mQuarterCat);
            this.mMonthCat = MetadataHelper.getRelatedNodeWithConcept(this.mDateCat, "cMonth", false);
            assert (null != this.mMonthCat);
            this.mDayOfMonthCat = MetadataHelper.getRelatedNodeWithConcept(this.mDateCat, "cDayOfMonth", false);
            assert (null != this.mDayOfMonthCat);
        } else {
            this.mDateCat = null;
            INode hierarchyRoot = MetadataHelper.getHierarchyRoot(aNode);
            this.mYearCat = MetadataHelper.getRelatedNodeWithConcept(hierarchyRoot, "cYear", false);
            if (this.mYearCat == null) {
                return;
            }
            this.mQuarterCat = MetadataHelper.getRelatedNodeWithConcept(this.mYearCat, "cYearQuarter", false);
            if (this.mQuarterCat == null) {
                return;
            }
            this.mMonthCat = MetadataHelper.getRelatedNodeWithConcept(this.mQuarterCat, "cYearMonth", false);
            if (this.mMonthCat == null) {
                return;
            }
            this.mDayOfMonthCat = MetadataHelper.getRelatedNodeWithConcept(this.mMonthCat, "cDayOfYear", false);
        }
    }

    private DateHierarchyHelper(INode dateCat) {
        this(dateCat, true);
    }

    public INode getDateCategory() {
        return this.mDateCat;
    }

    public INode getDateIdentifier() {
        return MetadataHelper.getRelatedNodeWithConcept(this.mDateCat, "cIdentifier", false);
    }

    public INode getYearCategory() {
        return this.mYearCat;
    }

    public INode getYearIdentifier() {
        return MetadataHelper.getRelatedNodeWithConcept(this.mYearCat, "cIdentifier", false);
    }

    public INode getMonthCategory() {
        return this.mMonthCat;
    }

    public INode getMonthIdentifier() {
        return MetadataHelper.getRelatedNodeWithConcept(this.mMonthCat, "cIdentifier", false);
    }

    public INode getMonthCaption() {
        return MetadataHelper.getRelatedNodeWithConcept(this.mMonthCat, "cCaption", false);
    }

    public INode getQuarterCategory() {
        return this.mQuarterCat;
    }

    public INode getQuarterIdentifier() {
        return MetadataHelper.getRelatedNodeWithConcept(this.mQuarterCat, "cIdentifier", false);
    }

    public INode getQuarterCaption() {
        return MetadataHelper.getRelatedNodeWithConcept(this.mQuarterCat, "cCaption", false);
    }

    public INode getDayOfMonthCategory() {
        return this.mDayOfMonthCat;
    }

    public INode getDayOfMonthIdentifier() {
        return MetadataHelper.getRelatedNodeWithConcept(this.mDayOfMonthCat, "cIdentifier", false);
    }

    public INode getDayOfMonthCaption() {
        return MetadataHelper.getRelatedNodeWithConcept(this.mDayOfMonthCat, "cCaption", false);
    }
}

