/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import java.util.Iterator;

public class MetadataHelper {
    public static IDataItem getDefaultDataItem(INode node) {
        IDataItem dataItem = null;
        if (node.isMetric() || node.isAttribute()) {
            dataItem = node.getDataItem();
            assert (dataItem != null);
            return dataItem;
        }
        assert (node.isCategory());
        INode attribute = NavigationHelper.getDefaultAttributeNode(node);
        dataItem = attribute.getDataItem();
        assert (dataItem != null);
        return dataItem;
    }

    public static INode getDateHierarchyRoot(INode n) {
        if ("cDate".equals(n.getConcept().getName()) && Boolean.TRUE.equals(n.getProperty("__isDateHierarchy"))) {
            return n;
        }
        for (IEdge e : n.getInEdges(new String[0])) {
            INode start = e.getStart();
            if (!"cDate".equals(start.getConcept().getName()) || !Boolean.TRUE.equals(start.getProperty("__isDateHierarchy"))) continue;
            return start;
        }
        return null;
    }

    public static boolean isSynthetic(INode node) {
        INode dateHierarchyRoot = MetadataHelper.getDateHierarchyRoot(node);
        return null != dateHierarchyRoot && node != dateHierarchyRoot;
    }

    public static INode getHierarchyRoot(INode n) {
        Iterator iterator = n.getInEdges(new String[0]).iterator();
        if (iterator.hasNext()) {
            IEdge e = (IEdge)iterator.next();
            return MetadataHelper.getHierarchyRoot(e.getStart());
        }
        return n;
    }

    public static boolean belongsToWholePartHierarchy(INode n) {
        for (IEdge e : n.getInEdges(new String[0])) {
            if (!e.isWholePart()) continue;
            return true;
        }
        for (IEdge e : n.getOutEdges(new String[0])) {
            if (!e.isWholePart()) continue;
            return true;
        }
        return false;
    }

    public static INode getWholePartHierarchyRoot(INode n) {
        if (MetadataHelper.belongsToWholePartHierarchy(n)) {
            return MetadataHelper.getWholePartHierarchyRootOrThis(n);
        }
        return null;
    }

    public static INode getWholePartHierarchyRootOrThis(INode node) {
        INode root = node;
        for (IEdge e : node.getInEdges(new String[0])) {
            if (!e.isWholePart()) continue;
            INode edgeRoot = MetadataHelper.getWholePartHierarchyRoot(e.getStart());
            if (root == node) {
                root = edgeRoot;
                continue;
            }
            if (edgeRoot == root) continue;
            throw new RuntimeException("Got more than one root for " + node);
        }
        return root;
    }

    public static boolean isWholePartHierarchyAncestor(INode ancestor, INode child) {
        for (IEdge e : child.getInEdges(new String[0])) {
            if (!e.isWholePart()) continue;
            if (ancestor == e.getStart()) {
                return true;
            }
            if (!MetadataHelper.isWholePartHierarchyAncestor(ancestor, e.getStart())) continue;
            return true;
        }
        return false;
    }

    public static INode getRelatedNodeWithConcept(INode n, String conceptName, boolean recursive) {
        if (n != null) {
            for (IEdge e : n.getOutEdges(new String[0])) {
                INode end = e.getEnd();
                if (conceptName.equals(end.getConcept().getName())) {
                    return end;
                }
                if (!recursive || null == (end = MetadataHelper.getPartNodeWithConcept(end, conceptName, recursive))) continue;
                return end;
            }
        }
        return null;
    }

    public static INode getPartNodeWithConcept(INode n, String conceptName, boolean recursive) {
        for (IEdge e : n.getOutEdges(new String[0])) {
            if (!e.isWholePart()) continue;
            INode end = e.getEnd();
            if (conceptName.equals(end.getConcept().getName())) {
                return end;
            }
            if (!recursive || null == (end = MetadataHelper.getPartNodeWithConcept(end, conceptName, recursive))) continue;
            return end;
        }
        return null;
    }

    public static String getMetricAggregate(INode n) {
        String regAggr = null;
        if (n.isMetric()) {
            regAggr = (String)n.getProperty("defAggregate");
        }
        if (regAggr == null) {
            regAggr = n.getConcept().getProperty("defAggregate");
        }
        return regAggr;
    }
}

