/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueStatus;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class NavigationHelper {
    private static final List<String> gSpecialConcepts = new ArrayList<String>(1);
    private final IDataContainer mContainer;
    private List<INode> rootCategories = null;

    public NavigationHelper(IAssociativeModel m) {
        this.mContainer = m.getRootContainer();
    }

    public List<INode> getRootNodes() {
        ArrayList<INode> outNodes = new ArrayList<INode>(20);
        this.collectRootNodes(this.mContainer, outNodes, null);
        return outNodes;
    }

    public List<INode> getRootNodesFiltered(List<String> excludeConcepts) {
        ArrayList<INode> outNodes = new ArrayList<INode>(20);
        this.collectRootNodes(this.mContainer, outNodes, excludeConcepts);
        return outNodes;
    }

    private void collectRootNodes(IDataContainer dc, List<INode> allNodes, List<String> excludeConcepts) {
        List nodes = dc.getNodes();
        for (INode aNode : nodes) {
            if (!NavigationHelper.isRootNode(aNode) || NavigationHelper.isFiltered(aNode, excludeConcepts)) continue;
            allNodes.add(aNode);
        }
        if (dc.getChildren() != null) {
            for (IDataContainer c : dc.getChildren()) {
                this.collectRootNodes(c, allNodes, excludeConcepts);
            }
        }
    }

    public List<INode> getCategoryNodesFiltered(List<String> excludeConcepts) {
        ArrayList<INode> outNodes = new ArrayList<INode>(20);
        this.collectNodesByClass(this.mContainer, IConcept.EConceptClass.category, outNodes, excludeConcepts);
        return outNodes;
    }

    public List<INode> getMetricNodesFiltered(List<String> excludeConcepts) {
        ArrayList<INode> outNodes = new ArrayList<INode>(20);
        this.collectNodesByClass(this.mContainer, IConcept.EConceptClass.metric, outNodes, excludeConcepts);
        return outNodes;
    }

    public List<INode> getCategoryAndMetricNodesFiltered(List<String> excludeConcepts) {
        ArrayList<INode> outNodes = new ArrayList<INode>(30);
        this.collectNodesByClass(this.mContainer, IConcept.EConceptClass.category, outNodes, excludeConcepts);
        this.collectNodesByClass(this.mContainer, IConcept.EConceptClass.metric, outNodes, excludeConcepts);
        return outNodes;
    }

    private void collectNodesByClass(IDataContainer dc, IConcept.EConceptClass eClass, List<INode> allNodes, List<String> excludeConcepts) {
        List nodes = dc.getNodes();
        for (INode aNode : nodes) {
            if (!aNode.getConcept().supportsClassification(eClass) || allNodes.contains(aNode) || NavigationHelper.isFiltered(aNode, excludeConcepts)) continue;
            allNodes.add(aNode);
        }
        if (dc.getChildren() != null) {
            for (IDataContainer c : dc.getChildren()) {
                this.collectNodesByClass(c, eClass, allNodes, excludeConcepts);
            }
        }
    }

    private static boolean isFiltered(INode aNode, List<String> excludeConcepts) {
        return excludeConcepts != null && excludeConcepts.contains(aNode.getConcept().getName());
    }

    public static boolean isRootNode(INode aNode) {
        return aNode.getDataItem() == null || aNode.isMetric();
    }

    public static List<String> getSpeciallyTreatedConcepts() {
        return gSpecialConcepts;
    }

    public List<INode> getDataItemNodes() {
        ArrayList<INode> outNodes = new ArrayList<INode>(20);
        this.collectDataItemNodes(this.mContainer, outNodes);
        return outNodes;
    }

    private void collectDataItemNodes(IDataContainer dc, List<INode> allNodes) {
        List nodes = dc.getNodes();
        for (INode aNode : nodes) {
            if (aNode.getDataItem() == null) continue;
            allNodes.add(aNode);
        }
        if (dc.getChildren() != null) {
            for (IDataContainer c : dc.getChildren()) {
                this.collectDataItemNodes(c, allNodes);
            }
        }
    }

    public static List<INode> getAttributeNodes(INode aNode) {
        if (!aNode.isCategory()) {
            return null;
        }
        ArrayList<INode> outNodes = new ArrayList<INode>(3);
        Iterable edges = aNode.getOutEdges(new String[0]);
        for (IEdge e : edges) {
            INode nodeTo;
            if (e.isWholePart() || !(nodeTo = e.getEnd()).isAttribute()) continue;
            outNodes.add(nodeTo);
        }
        return outNodes;
    }

    public static INode getCategoryFromAttribute(INode attribute) {
        if (attribute == null || !attribute.isAttribute()) {
            return null;
        }
        Iterable edges = attribute.getInEdges(new String[0]);
        IEdge edge = (IEdge)edges.iterator().next();
        return edge.getStart();
    }

    public static INode getDefaultAttributeNode(INode aNode) {
        if (!aNode.isCategory()) {
            return null;
        }
        INode nodeIdentifier = null;
        INode nodeOther = null;
        Iterable edges = aNode.getOutEdges(new String[0]);
        for (IEdge e : edges) {
            INode nodeTo;
            if (e.isWholePart() || !(nodeTo = e.getEnd()).isAttribute()) continue;
            if ("cCaption".equals(nodeTo.getConcept().getName())) {
                return nodeTo;
            }
            if ("cIdentifier".equals(nodeTo.getConcept().getName())) {
                nodeIdentifier = nodeTo;
                continue;
            }
            nodeOther = nodeTo;
        }
        return nodeIdentifier != null ? nodeIdentifier : nodeOther;
    }

    public static INode getIdentifierAttributeFromCategory(INode aNode) {
        if (!aNode.isCategory()) {
            return null;
        }
        Iterable edges = aNode.getOutEdges(new String[0]);
        for (IEdge e : edges) {
            INode nodeTo;
            if (e.isWholePart() || !(nodeTo = e.getEnd()).isAttribute() || !"cIdentifier".equals(nodeTo.getConcept().getName())) continue;
            return nodeTo;
        }
        return NavigationHelper.getDefaultAttributeNode(aNode);
    }

    public static List<INode> getPartNodes(INode aNode) {
        ArrayList<INode> partNodes = new ArrayList<INode>(3);
        NavigationHelper.collectPartNodes(aNode, partNodes, false);
        return partNodes;
    }

    public static List<INode> getIsPartOfNodes(INode aNode) {
        ArrayList<INode> partNodes = new ArrayList<INode>(3);
        NavigationHelper.collectPartNodes(aNode, partNodes, true);
        return partNodes;
    }

    private static List<INode> collectPartNodes(INode aNode, List<INode> partNodes, boolean bInEdges) {
        Iterable edges = bInEdges ? aNode.getInEdges(new String[0]) : aNode.getOutEdges(new String[0]);
        for (IEdge e : edges) {
            if (!e.isWholePart()) continue;
            INode nodeFrom = bInEdges ? e.getStart() : e.getEnd();
            partNodes.add(nodeFrom);
            NavigationHelper.collectPartNodes(nodeFrom, partNodes, bInEdges);
            break;
        }
        return partNodes;
    }

    public static List<INode> getHierarchy(INode node) {
        List<INode> nodes;
        List<INode> hierarchy = NavigationHelper.getPartNodes(node);
        hierarchy.add(0, node);
        INode tmpNode = node;
        while ((nodes = NavigationHelper.getIsPartOfNodes(tmpNode)).size() != 0) {
            tmpNode = nodes.get(0);
            hierarchy.add(0, tmpNode);
        }
        return hierarchy;
    }

    public void modelAsXML(OutputStreamWriter osw) {
        try {
            osw.write(NavigationHelper.dataContainerToXML(this.mContainer));
            osw.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static String dataContainerToXML(IDataContainer dc) {
        StringBuilder sb = new StringBuilder("<dataContainer name=\"");
        sb.append(dc.getId().toUniqueName());
        sb.append("\" type=\"");
        sb.append(dc.getType());
        sb.append("\">");
        for (IDataContainer sc : dc.getChildren()) {
            sb.append(NavigationHelper.dataContainerToXML(sc));
        }
        for (INode n : dc.getNodes()) {
            sb.append(NavigationHelper.nodeToXML(n));
        }
        sb.append("</dataContainer>");
        return sb.toString();
    }

    private static String conceptToXML(IConcept concept) {
        StringBuilder sb = new StringBuilder("\n<concept name=\"");
        sb.append(concept.getName());
        sb.append("\"><isA>");
        for (String isA : concept.getIsAs()) {
            sb.append(isA);
            sb.append(" ");
        }
        sb.append("</isA>");
        for (String propName : concept.getPropertyNames()) {
            sb.append("<prop name=\"");
            sb.append(propName);
            sb.append("\" value=\"");
            sb.append(concept.getProperty(propName));
            sb.append("\"/>");
        }
        sb.append("</concept>");
        return sb.toString();
    }

    private static String nodeToXML(INode n) {
        StringBuilder sb = new StringBuilder("\n<node id=\"");
        sb.append(n.getId());
        sb.append("\" confidence=\"");
        sb.append(Float.toString(n.getConfidenceLevel()));
        sb.append("\">");
        IDataItem di = n.getDataItem();
        if (null != di) {
            sb.append(NavigationHelper.dataItemToXML(di));
        }
        sb.append(NavigationHelper.conceptToXML(n.getConcept()));
        for (IEdge e : n.getOutEdges(new String[0])) {
            sb.append(NavigationHelper.edgeToXML(e));
        }
        sb.append("</node>");
        return sb.toString();
    }

    private static String edgeToXML(IEdge e) {
        StringBuilder sb = new StringBuilder("<edge name=\"");
        if (e.getLabel() != null) {
            sb.append(e.getLabel());
        }
        sb.append("\" wholePart=\"");
        sb.append(e.isWholePart() ? "yes" : "no");
        sb.append("\" card=\"");
        sb.append(e.getCardinality().toString());
        sb.append("\" to=\"");
        sb.append(e.getEnd().getId());
        sb.append("\"/>");
        return sb.toString();
    }

    private static String dataItemToXML(IDataItem di) {
        StringBuilder sb = new StringBuilder("\n<dataItem name=\"");
        sb.append(di.getName());
        sb.append("\" dType=\"");
        sb.append(di.getDataType());
        IDataItemStats stats = di.getStats();
        sb.append("\" numValues=\"");
        sb.append(Long.toString(stats.count()));
        sb.append("\" numDistincValues=\"");
        sb.append(Long.toString(stats.distinctCount()));
        IValue minVal = stats.minValue();
        IValue maxVal = stats.maxValue();
        if (null != minVal && minVal.getStatus() == ValueStatus.OK) {
            sb.append("\" minValue=\"");
            sb.append(Double.toString(minVal.doubleValue()));
        }
        if (null != maxVal && maxVal.getStatus() == ValueStatus.OK) {
            sb.append("\" maxValue=\"");
            sb.append(Double.toString(maxVal.doubleValue()));
        }
        sb.append("\"/>");
        return sb.toString();
    }

    public List<INode> getDetectedHierarchies() {
        if (this.rootCategories != null) {
            return this.rootCategories;
        }
        ArrayList<INode> keepCategories = new ArrayList<INode>();
        Iterable nodes = this.mContainer.getModel().getNodes();
        for (INode aNode : nodes) {
            if (!aNode.isCategory()) continue;
            Iterable inEdges = aNode.getInEdges(new String[0]);
            boolean addCategory = true;
            for (IEdge inEdge : inEdges) {
                if (!inEdge.isWholePart()) continue;
                addCategory = false;
                break;
            }
            if (!addCategory) continue;
            keepCategories.add(aNode);
        }
        this.rootCategories = keepCategories;
        return this.rootCategories;
    }

    public static boolean isPartOfHierarchy(INode aCategory, INode hierarchyCategory) {
        if (!aCategory.isCategory() || !hierarchyCategory.isCategory()) {
            return false;
        }
        if (aCategory.equals(hierarchyCategory)) {
            return true;
        }
        Iterable inEdges = aCategory.getInEdges(new String[0]);
        for (IEdge edge : inEdges) {
            if (!edge.isWholePart()) continue;
            return NavigationHelper.isPartOfHierarchy(edge.getStart(), hierarchyCategory);
        }
        return false;
    }

    static {
        gSpecialConcepts.add("cDate");
    }
}

