/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.api.query.provider.IDataProvider;
import com.ibm.cognos.aurora.api.query.provider.IProviderManager;
import com.ibm.cognos.aurora.core.model.AbstractDataItem;

public class ProviderDataItem
extends AbstractDataItem {
    private IDataItemStats mStats = null;

    public ProviderDataItem() {
    }

    public ProviderDataItem(String name, IDataType dataType) {
        super(null, name, dataType);
    }

    public ProviderDataItem(IDataContainer container, String name, IDataType dataType) {
        super(container, name, dataType);
    }

    public IDataItemStats getStats() {
        if (null == this.mStats) {
            this.mStats = this.getDataProvider().fetchDataItemStats((IDataItem)this);
        }
        return this.mStats;
    }

    @Override
    public IValueIterator fetchValues(long limit) {
        return this.getDataProvider().fetchDataItemValues((IDataItem)this, false, limit);
    }

    @Override
    public IValueIterator fetchUniqueValues(long limit) {
        return this.getDataProvider().fetchDataItemValues((IDataItem)this, true, limit);
    }

    public IDataProvider getDataProvider() {
        IDataSource ds = this.getPhysicalMetadata().getModel().getDataSource();
        IConnectionSpec connSpec = ds.getConnectionSpec();
        String providerType = connSpec.getParameterStringValue("providerType");
        if (null == this.getContainer()) {
            throw new RuntimeException("DataContainer was not set");
        }
        IQueryLogicalStorage qls = this.getContainer().getQLS();
        if (null == qls) {
            throw new RuntimeException("QLS was not set");
        }
        IProviderManager providerManager = qls.getProviderManager();
        IDataProvider provider = providerManager.getDataProvider(providerType);
        if (null == provider) {
            throw new RuntimeException("Unsupported provider type:" + providerType);
        }
        return provider;
    }
}

