/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.api.util.IBinaryEncodable;
import com.ibm.cognos.aurora.api.util.IXMLEncodable;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.core.util.Dictionary;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public final class PropertyContainer
implements IXMLEncodable,
IBinaryEncodable {
    private final Map<String, IValue> mNameToValue;
    private Set<String> mMaskedProps = null;

    public PropertyContainer() {
        this.mNameToValue = new LinkedHashMap<String, IValue>();
    }

    public PropertyContainer(PropertyContainer container) {
        this.mNameToValue = new LinkedHashMap<String, IValue>(container.mNameToValue);
    }

    public PropertyContainer(Map<String, IValue> map) {
        this.mNameToValue = new LinkedHashMap<String, IValue>(map);
    }

    public void maskProperty(String propName) {
        if (null == this.mMaskedProps) {
            this.mMaskedProps = new HashSet<String>();
        }
        this.mMaskedProps.add(propName);
    }

    public boolean isEmpty() {
        return this.mNameToValue.isEmpty();
    }

    public int size() {
        return this.mNameToValue.size();
    }

    public boolean contains(String propName) {
        return this.mNameToValue.containsKey(propName);
    }

    public String[] getPropertyNames() {
        return this.mNameToValue.keySet().toArray(new String[0]);
    }

    public IValue get(String propName) {
        return this.mNameToValue.get(propName);
    }

    public void set(String propName, IValue propValue) {
        this.mNameToValue.put(propName, propValue);
    }

    public boolean remove(String propName) {
        return null != this.mNameToValue.remove(propName);
    }

    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        List suppressedProps = (List)ctx.peekUnchecked("suppressedProps");
        Dictionary keyDict = (Dictionary)ctx.getUnchecked("keyDictionary");
        out.writeInt(this.mNameToValue.size());
        for (Map.Entry<String, IValue> e : this.mNameToValue.entrySet()) {
            if (null != keyDict) {
                int strId = keyDict.insert(e.getKey());
                out.writeShort(strId);
                if (-1 == strId) {
                    EncodeUtil.writeString(out, e.getKey());
                }
            } else {
                EncodeUtil.writeString(out, e.getKey());
            }
            if (null != suppressedProps && suppressedProps.contains(e.getKey())) {
                ValueFactory.encodeBinary((DataOutput)out, (EncoderContext)ctx, (IValue)ValueFactory.createString(null));
                continue;
            }
            ValueFactory.encodeBinary((DataOutput)out, (EncoderContext)ctx, (IValue)e.getValue());
        }
    }

    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        Dictionary keyDict = (Dictionary)ctx.getUnchecked("keyDictionary");
        this.mNameToValue.clear();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            String key = null;
            if (null != keyDict) {
                short strId = in.readShort();
                if (strId == -1) {
                    key = EncodeUtil.readString(in);
                    keyDict.insert(key);
                } else {
                    key = (String)keyDict.lookup(strId);
                }
            } else {
                key = EncodeUtil.readString(in);
            }
            IValue value = ValueFactory.decodeBinary((DataInput)in, (EncoderContext)ctx);
            this.mNameToValue.put(key, value);
        }
    }

    public void encodeElement(Element elem, EncoderContext ctx) {
        List suppressedProps = (List)ctx.peekUnchecked("suppressedProps");
        for (Map.Entry<String, IValue> e : this.mNameToValue.entrySet()) {
            if (null != suppressedProps && suppressedProps.contains(e.getKey())) continue;
            Element entryElem = elem.addElement("entry");
            entryElem.addElement("key").setText(e.getKey());
            ValueFactory.encodeElement((Element)entryElem.addElement("value"), (EncoderContext)ctx, (IValue)e.getValue());
        }
    }

    public void decodeElement(Element elem, EncoderContext ctx) {
        this.mNameToValue.clear();
        for (Element entryElem : elem.elements()) {
            String key = entryElem.elementText("key");
            IValue value = ValueFactory.decodeElement((Element)entryElem.element("value"), (EncoderContext)ctx);
            this.mNameToValue.put(key, value);
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder(this.size() * 28);
        sb.append('{');
        Iterator<Map.Entry<String, IValue>> iterator = this.mNameToValue.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, IValue> entry = iterator.next();
            String propName = entry.getKey();
            IValue propVal = entry.getValue();
            sb.append(propName);
            sb.append('=');
            if (null != this.mMaskedProps && this.mMaskedProps.contains(propName)) {
                sb.append("****");
            } else {
                sb.append(propVal);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyContainer)) {
            return false;
        }
        PropertyContainer other = (PropertyContainer)o;
        return this.mNameToValue.equals(other.mNameToValue);
    }

    public int hashCode() {
        return this.mNameToValue.hashCode();
    }
}

