/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

public final class UniqueNameGenerator {
    public static final String OPEN_BRACE = "[";
    public static final String CLOSE_BRACE = "]";
    public static final String BRACE_DOT = "].";
    public static final String DOT_SEPARATOR = "].[";
    public static final String DOT = ".";
    public static final String ARROW = "->";
    public static final String COLON = ":";

    private UniqueNameGenerator() {
    }

    public static String appendUniqueName(String part1, String part2) {
        StringBuilder buffer = new StringBuilder(part1);
        buffer.append(DOT);
        buffer.append(UniqueNameGenerator.createSingleNamePart(part2));
        return buffer.toString();
    }

    public static String appendUniqueName(String part1, String part2, String part3) {
        StringBuilder buffer = new StringBuilder(UniqueNameGenerator.appendUniqueName(part1, part2));
        buffer.append(DOT);
        buffer.append(UniqueNameGenerator.createSingleNamePart(part3));
        return buffer.toString();
    }

    public static String appendUniqueName(String part1, String part2, String part3, String part4) {
        StringBuilder buffer = new StringBuilder(UniqueNameGenerator.appendUniqueName(part1, part2, part3));
        buffer.append(DOT);
        buffer.append(UniqueNameGenerator.createSingleNamePart(part4));
        return buffer.toString();
    }

    public static String appendUniqueName(String part1, String part2, String part3, String part4, String part5) {
        StringBuilder buffer = new StringBuilder(UniqueNameGenerator.appendUniqueName(part1, part2, part3, part4));
        buffer.append(DOT);
        buffer.append(UniqueNameGenerator.createSingleNamePart(part5));
        return buffer.toString();
    }

    public static String createSingleNamePart(String part1) {
        StringBuilder buffer = new StringBuilder();
        UniqueNameGenerator.appendSingleNamePart(buffer, part1);
        return buffer.toString();
    }

    public static void appendSingleNamePart(StringBuilder buffer, String part1) {
        buffer.append(OPEN_BRACE);
        if (part1 != null) {
            buffer.append(part1.replaceAll(CLOSE_BRACE, "]]"));
        }
        buffer.append(CLOSE_BRACE);
    }

    public static String createUniqueName(String part1, String part2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(part1);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part2);
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createUniqueName(String part1, String part2, String part3) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(part1);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part2);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part3);
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createUniqueName(String part1, String part2, String part3, String part4) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(part1);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part2);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part3);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part4);
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createUniqueName(String ... parts) {
        StringBuilder buffer = new StringBuilder();
        int lastPart = parts.length - 1;
        for (int i = 0; i < lastPart; ++i) {
            UniqueNameGenerator.appendSingleNamePart(buffer, parts[i]);
            buffer.append(DOT);
        }
        UniqueNameGenerator.appendSingleNamePart(buffer, parts[lastPart]);
        return buffer.toString();
    }

    public static String join(String part1, String part2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(part1);
        buffer.append(DOT);
        buffer.append(part2);
        return buffer.toString();
    }
}

