/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util.collection;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class DistinctIterator<E>
implements Iterator<E> {
    private final Iterator<E> mSource;
    private final Set<E> mDistinctElements = new HashSet();
    private E mNext;

    public DistinctIterator(Iterator<E> source) {
        this.mSource = source;
        this.mNext = this.fetchNext();
    }

    @Override
    public boolean hasNext() {
        return null != this.mNext;
    }

    @Override
    public E next() {
        if (null == this.mNext) {
            throw new NoSuchElementException();
        }
        E element = this.mNext;
        this.mNext = this.fetchNext();
        return element;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private E fetchNext() {
        while (this.mSource.hasNext()) {
            E e = this.mSource.next();
            if (!this.mDistinctElements.add(e)) continue;
            return e;
        }
        return null;
    }
}

