/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util.collection;

import com.ibm.cognos.aurora.core.util.collection.FilteringIterable;
import com.ibm.cognos.aurora.core.util.collection.IFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class Filters {
    public static <E> IFilter<E> allTrue(Class<E> klass) {
        return new IFilter<E>(){

            @Override
            public boolean passes(E element) {
                return true;
            }
        };
    }

    public static <E> IFilter<E> allFalse(Class<E> klass) {
        return new IFilter<E>(){

            @Override
            public boolean passes(E element) {
                return false;
            }
        };
    }

    public static <E> IFilter<E> and(final IFilter<E> left, final IFilter<E> right) {
        return new IFilter<E>(){

            @Override
            public boolean passes(E element) {
                return left.passes(element) && right.passes(element);
            }
        };
    }

    public static <E> IFilter<E> or(final IFilter<E> left, final IFilter<E> right) {
        return new IFilter<E>(){

            @Override
            public boolean passes(E element) {
                return left.passes(element) || right.passes(element);
            }
        };
    }

    public static <E> IFilter<E> not(final IFilter<E> filter) {
        return new IFilter<E>(){

            @Override
            public boolean passes(E element) {
                return !filter.passes(element);
            }
        };
    }

    public static <E> IFilter<E> anyOf(final IFilter<E> ... filters) {
        return new IFilter<E>(){

            @Override
            public boolean passes(E element) {
                for (IFilter f : filters) {
                    if (!f.passes(element)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <E> IFilter<E> allOf(final IFilter<E> ... filters) {
        return new IFilter<E>(){

            @Override
            public boolean passes(E element) {
                for (IFilter f : filters) {
                    if (f.passes(element)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <E> IFilter<E> noneOf(final IFilter<E> ... filters) {
        return new IFilter<E>(){

            @Override
            public boolean passes(E element) {
                for (IFilter f : filters) {
                    if (!f.passes(element)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <E> IFilter<E> equalTo(final E other) {
        return new IFilter<E>(){

            @Override
            public boolean passes(E element) {
                if (null == element) {
                    return null == other;
                }
                if (null == other) {
                    return false;
                }
                return element.equals(other);
            }
        };
    }

    public static <E> IFilter<E> inSet(final Set<E> set) {
        return new IFilter<E>(){

            @Override
            public boolean passes(E element) {
                return set.contains(element);
            }
        };
    }

    public static <T> List<T> filterLists(Collection<List<T>> nodes, IFilter<T> filter) {
        ArrayList<T> result = new ArrayList<T>();
        for (List<T> nodeList : nodes) {
            for (T node : new FilteringIterable<T>(nodeList, filter)) {
                result.add(node);
            }
        }
        return result;
    }

    public static <T> List<T> filterList(List<T> nodes, IFilter<T> filter) {
        ArrayList<T> result = new ArrayList<T>();
        for (T node : new FilteringIterable<T>(nodes, filter)) {
            result.add(node);
        }
        return result;
    }
}

