/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.importer;

import com.ibm.cognos.aurora.api.model.value.DateTimeValue;
import com.ibm.cognos.aurora.api.storage.data.tabular.ColumnType;
import com.ibm.cognos.aurora.api.storage.data.tabular.IBatchRowInsert;
import com.ibm.cognos.aurora.api.storage.data.tabular.ILocalTabularStorage;
import com.ibm.cognos.aurora.api.storage.data.tabular.ITable;
import com.ibm.cognos.aurora.api.storage.data.tabular.ITableDescriptor;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public class CalendarTableGenerator {
    public static final String TABLE_NAME = "cal_table";
    public static final String COLUMN_ISO_DATE = "iso_date";
    public static final String COLUMN_YEAR = "year";
    public static final String COLUMN_QUARTER = "quarter";
    public static final String COLUMN_QUARTER_NAME = "quarter_name";
    public static final String COLUMN_QUARTER_CAPTION = "quarter_caption";
    public static final String COLUMN_MONTH = "month";
    public static final String COLUMN_MONTH_NAME = "month_name";
    public static final String COLUMN_MONTH_CAPTION = "month_caption";
    public static final String COLUMN_DAY_OF_MONTH = "day_of_month";
    public static final String COLUMN_DAY_OF_MONTH_CAPTION = "day_of_month_caption";
    public static final String COLUMN_DAY_OF_WEEK = "day_of_week";
    public static final String COLUMN_DAY_OF_WEEK_NAME = "day_of_week_name";
    private static final ILogger mLogger = LoggerManager.getLogger((String)"ATHENA.core.qls_import");
    private final ULocale mLocale;
    private final Calendar mCalendar;
    private final DateFormat mMonetDBDateFormatter;
    private final DateFormat mDayOfMonthCaptionFormatter;
    private final DateFormat mQuarterNumberFormatter;
    private final DateFormat mQuarterNameFormatter;
    private final DateFormat mQuarterCaptionFormatter;
    private final DateFormat mMonthNameFormatter;
    private final DateFormat mMonthCaptionFormatter;
    private final DateFormat mDayOfWeekNameFormatter;
    private ITable mTable;

    public CalendarTableGenerator(ULocale locale) {
        this.mLocale = locale;
        if (mLogger.isInfoEnabled()) {
            mLogger.info(String.format("Creating calendar table generator with locale='%s' and zone='%s'", this.mLocale.toString()), this.getClass().getName() + "::CalendarTableGenerator()");
        }
        this.mCalendar = DateTimeValue.getISO8601Calendar();
        this.mMonetDBDateFormatter = new SimpleDateFormat("yyyy-MMM-dd", Locale.ENGLISH);
        this.mDayOfMonthCaptionFormatter = DateFormat.getDateInstance((Calendar)this.mCalendar, (int)2, (ULocale)this.mLocale);
        this.mQuarterNumberFormatter = DateFormat.getPatternInstance((Calendar)this.mCalendar, (String)"q", (ULocale)locale);
        this.mQuarterNameFormatter = DateFormat.getPatternInstance((Calendar)this.mCalendar, (String)"qqq", (ULocale)locale);
        this.mQuarterCaptionFormatter = DateFormat.getPatternInstance((Calendar)this.mCalendar, (String)"QQQyyyy", (ULocale)locale);
        this.mMonthNameFormatter = DateFormat.getPatternInstance((Calendar)this.mCalendar, (String)"MMMM", (ULocale)locale);
        this.mMonthCaptionFormatter = DateFormat.getPatternInstance((Calendar)this.mCalendar, (String)"MMMyyyy", (ULocale)locale);
        this.mDayOfWeekNameFormatter = DateFormat.getPatternInstance((Calendar)this.mCalendar, (String)"EEEE", (ULocale)locale);
    }

    public ITable createTable(ILocalTabularStorage storage) {
        ITableDescriptor tableDesc = this.createSchema(storage);
        this.mTable = storage.getTable(tableDesc.getName());
        if (mLogger.isDebugEnabled()) {
            mLogger.debug(String.format("Creating table '%s' in local storage '%s'", tableDesc.getName(), storage.getUUID()), this.getClass().getName() + "::createTable()");
        }
        if (null != this.mTable) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug("Table exists - dropping it, first", this.getClass().getName() + "::createTable()");
            }
            this.mTable.drop();
        }
        this.mTable = storage.createTable(tableDesc);
        return this.mTable;
    }

    public ITable getTable() {
        return this.mTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateTable(int startYear, int endYear) {
        if (null == this.mTable) {
            throw new IllegalStateException("Table was not created.");
        }
        if (mLogger.isInfoEnabled()) {
            mLogger.info(String.format("Populating calendar table '%s' from year %d to year %d (inclusive)", this.mTable.getIdentifier(), startYear, endYear), this.getClass().getName() + "::populateTable()");
        }
        this.mCalendar.set(startYear, this.mCalendar.getMinimum(2), this.mCalendar.getMinimum(5), 0, 0, 0);
        Date startDate = this.mCalendar.getTime();
        this.mCalendar.set(endYear + 1, this.mCalendar.getMinimum(2), this.mCalendar.getMinimum(5), 0, 0, 0);
        int numDays = -this.mCalendar.fieldDifference(startDate, 5);
        IBatchRowInsert batch = this.mTable.prepareBatchInsert();
        batch.begin();
        try {
            this.mCalendar.setTime(startDate);
            for (int i = 0; i < numDays; ++i) {
                this.insertDate(batch, this.mCalendar.getTime());
                this.mCalendar.add(5, 1);
            }
        }
        finally {
            batch.finish();
        }
    }

    private void insertDate(IBatchRowInsert batch, Date currentDate) {
        Object[] row = new String[]{this.mMonetDBDateFormatter.format(currentDate), Integer.toString(this.mCalendar.get(1)), this.mQuarterNumberFormatter.format(currentDate), this.mQuarterNameFormatter.format(currentDate), this.mQuarterCaptionFormatter.format(currentDate), Integer.toString(this.mCalendar.get(2) + 1), this.mMonthNameFormatter.format(currentDate), this.mMonthCaptionFormatter.format(currentDate), Integer.toString(this.mCalendar.get(5)), this.mDayOfMonthCaptionFormatter.format(currentDate), Integer.toString(this.mCalendar.get(7)), this.mDayOfWeekNameFormatter.format(currentDate)};
        if (mLogger.isDebugEnabled()) {
            mLogger.debug(String.format("Inserting row: %s", Arrays.toString(row)), this.getClass().getName() + "::insertDate()");
        }
        batch.addRow(row);
    }

    private ITableDescriptor createSchema(ILocalTabularStorage storage) {
        ITableDescriptor tableDesc = storage.describeTable(TABLE_NAME);
        tableDesc.addColumn(COLUMN_ISO_DATE, ColumnType.getDate());
        tableDesc.addColumn(COLUMN_YEAR, ColumnType.getSmallInt());
        tableDesc.addColumn(COLUMN_QUARTER, ColumnType.getSmallInt());
        tableDesc.addColumn(COLUMN_QUARTER_NAME, ColumnType.getVarChar((int)5));
        tableDesc.addColumn(COLUMN_QUARTER_CAPTION, ColumnType.getVarChar((int)15));
        tableDesc.addColumn(COLUMN_MONTH, ColumnType.getSmallInt());
        tableDesc.addColumn(COLUMN_MONTH_NAME, ColumnType.getVarChar((int)15));
        tableDesc.addColumn(COLUMN_MONTH_CAPTION, ColumnType.getVarChar((int)15));
        tableDesc.addColumn(COLUMN_DAY_OF_MONTH, ColumnType.getSmallInt());
        tableDesc.addColumn(COLUMN_DAY_OF_MONTH_CAPTION, ColumnType.getVarChar((int)20));
        tableDesc.addColumn(COLUMN_DAY_OF_WEEK, ColumnType.getSmallInt());
        tableDesc.addColumn(COLUMN_DAY_OF_WEEK_NAME, ColumnType.getVarChar((int)15));
        return tableDesc;
    }
}

