/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.importer;

import com.ibm.cognos.aurora.api.importer.IImporter;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.importer.CalendarTableGenerator;
import com.ibm.cognos.aurora.importer.IPostAnalysisProcessor;
import com.ibm.cognos.aurora.importer.ImportPackage;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;

public class ImportContext {
    private final IImporter mImporter;
    private final ImportPackage mPackage;
    private final List<IPostAnalysisProcessor> mPostProcessors = new ArrayList<IPostAnalysisProcessor>();
    private ULocale mDeployLocale = null;
    private CalendarTableGenerator mCalTableGen = null;
    private boolean mDecorateOnlyAnalysis = false;

    public ImportContext(IImporter importer, ImportPackage pkg) {
        this.mImporter = importer;
        this.mPackage = pkg;
    }

    public IImporter getImporter() {
        return this.mImporter;
    }

    public ImportPackage getPackage() {
        return this.mPackage;
    }

    public CalendarTableGenerator getCalTableGen() {
        return this.mCalTableGen;
    }

    public void setCalTableGen(CalendarTableGenerator calTableGen) {
        this.mCalTableGen = calTableGen;
    }

    public ULocale getDeployLocale() {
        return this.mDeployLocale;
    }

    public void setDeployLocale(ULocale locale) {
        this.mDeployLocale = locale;
    }

    public boolean isDecorateOnlyAnalysis() {
        return this.mDecorateOnlyAnalysis;
    }

    public void setDecorationOnlyAnalysis(boolean isDecorateOnlyAnalysis) {
        this.mDecorateOnlyAnalysis = isDecorateOnlyAnalysis;
    }

    public void addPostAnalysisProcessor(IPostAnalysisProcessor processor) {
        this.mPostProcessors.add(processor);
    }

    public void runPostAnalysisProcessors(IAssociativeModel model) {
        for (IPostAnalysisProcessor p : this.mPostProcessors) {
            p.process(model);
        }
    }
}

