/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.importer;

import com.ibm.cognos.aurora.api.importer.IImportPackage;
import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.smd.ISmartMetadata;
import com.ibm.cognos.aurora.api.storage.data.ILocalDataRepository;
import com.ibm.cognos.aurora.api.storage.data.ILocalDataStorage;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.util.SoftReferenceCache;
import com.ibm.cognos.aurora.core.xml.DOM4JUtil;
import com.ibm.cognos.aurora.importer.ImporterImpl;
import com.ibm.cognos.aurora.importer.PackageVersionMismatchException;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

@Deprecated
public class ImportPackage
implements IImportPackage {
    private static final int VERSION_ID = 124;
    private final ImporterImpl mImporter;
    private String mName;
    private Date mCreationDate;
    private String mPackgeDirPath;
    private final Map<String, String> mModelNameToFileName = new HashMap<String, String>();
    private final SoftReferenceCache<String, IAssociativeModel> mModelCache = new SoftReferenceCache();
    private final Lock mModelCacheLock = new ReentrantLock();
    private final List<ILocalDataStorage> mLocalStorages = new ArrayList<ILocalDataStorage>();

    public ImportPackage(ImporterImpl importer, String name, String packageDirPath) {
        this.mImporter = importer;
        this.mName = name;
        this.mPackgeDirPath = packageDirPath;
        this.mCreationDate = Calendar.getInstance().getTime();
    }

    public String getPackageDirPath() {
        return this.mPackgeDirPath;
    }

    public String getName() {
        return this.mName;
    }

    public Date getCreationDate() {
        return this.mCreationDate;
    }

    public Collection<String> getModelNames() {
        return Collections.unmodifiableCollection(this.mModelNameToFileName.keySet());
    }

    public IAssociativeModel loadModel(String name) {
        IAssociativeModel model = null;
        this.mModelCacheLock.lock();
        try {
            model = (IAssociativeModel)this.mModelCache.get((Object)name);
            if (null == model) {
                String fileName = this.mModelNameToFileName.get(name);
                if (null == fileName) {
                    throw new ImportException("Model was not found: " + name);
                }
                IQueryLogicalStorage qls = this.mImporter.getQLS();
                ISmartMetadata smd = this.mImporter.getSMD();
                String modelFilePath = FilenameUtils.concat((String)this.mPackgeDirPath, (String)fileName);
                model = qls.loadModel(smd.getConceptInventory(), modelFilePath);
                this.mModelCache.put((Object)name, (Object)model);
            }
        }
        catch (IOException ex) {
            throw new ImportException((Throwable)ex);
        }
        finally {
            this.mModelCacheLock.unlock();
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModel(String name, IAssociativeModel model) throws IOException {
        if (this.mModelNameToFileName.containsKey(name)) {
            throw new ImportException("Model already exits: " + name);
        }
        String modelFileName = Integer.toString(this.mModelNameToFileName.size()) + ".model";
        String modelFilePath = FilenameUtils.concat((String)this.mPackgeDirPath, (String)modelFileName);
        try {
            this.mModelNameToFileName.put(name, modelFileName);
            model.saveTo(modelFilePath);
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        this.mModelCacheLock.lock();
        try {
            this.mModelCache.put((Object)name, (Object)model);
        }
        finally {
            this.mModelCacheLock.unlock();
        }
    }

    public void saveModel(String name, IAssociativeModel model) throws IOException {
        String modelFileName = this.mModelNameToFileName.get(name);
        if (null == modelFileName) {
            throw new ImportException("Model does not exist: " + name);
        }
        String modelFilePath = FilenameUtils.concat((String)this.mPackgeDirPath, (String)modelFileName);
        try {
            model.saveTo(modelFilePath);
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
    }

    public Collection<ILocalDataStorage> getLocalStorages() {
        return Collections.unmodifiableCollection(this.mLocalStorages);
    }

    public void addLocalStorage(ILocalDataStorage store) {
        this.mLocalStorages.add(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            for (ILocalDataStorage store : this.mLocalStorages) {
                store.destroy();
            }
        }
        finally {
            this.mImporter.removePackage(this.mName);
        }
    }

    public void encodeElement(Element elem, EncoderContext ctx) {
        DateFormat df = DateFormat.getInstance();
        elem.addAttribute("name", this.mName);
        elem.addAttribute("creationDate", df.format(this.mCreationDate));
        elem.addAttribute("version", Long.toString(124L));
        Element modelsElem = elem.addElement("models");
        for (Map.Entry<String, String> e : this.mModelNameToFileName.entrySet()) {
            Element modelElem = modelsElem.addElement("model");
            modelElem.addAttribute("name", e.getKey());
            modelElem.addAttribute("file", e.getValue());
        }
        Element localStoragesElem = elem.addElement("localStorages");
        for (ILocalDataStorage store : this.mLocalStorages) {
            localStoragesElem.addElement("storage").setText(store.getUUID());
        }
    }

    public void decodeElement(Element elem, EncoderContext ctx) {
        DateFormat df = DateFormat.getInstance();
        String strVersion = elem.attributeValue("version");
        if (null == strVersion || Long.parseLong(strVersion) != 124L) {
            throw new PackageVersionMismatchException();
        }
        this.mName = elem.attributeValue("name");
        try {
            this.mCreationDate = df.parse(elem.attributeValue("creationDate"));
        }
        catch (ParseException ex) {
            throw new ImportException((Throwable)ex);
        }
        Element modelsElem = elem.element("models");
        this.mModelCache.clear();
        this.mModelNameToFileName.clear();
        for (Element e : modelsElem.elements("model")) {
            String modelName = e.attributeValue("name");
            String modelFile = e.attributeValue("file");
            this.mModelNameToFileName.put(modelName, modelFile);
        }
        ILocalDataRepository repo = this.mImporter.getQLS().getLocalDataRepository();
        Element localStoragesElem = elem.element("localStorages");
        for (Element storageElem : localStoragesElem.elements("storage")) {
            String uuid = storageElem.getText();
            ILocalDataStorage store = repo.getStorage(uuid);
            if (null == store) {
                throw new ImportException("Package refers to non-existent local storage with UUID " + uuid);
            }
            this.mLocalStorages.add(store);
        }
    }

    public void saveTo(String path) throws IOException {
        Document doc = this.encodeDocument();
        DOM4JUtil.serializeDocument((File)new File(path), (Document)doc, (boolean)true);
    }

    private Document encodeDocument() {
        Document doc = DOM4JUtil.createDocument((String)"UTF8");
        Element rootElem = doc.addElement("package");
        this.encodeElement(rootElem, new EncoderContext());
        return doc;
    }

    public void loadFrom(String path) throws IOException, DocumentException {
        Document doc = DOM4JUtil.parseDocument((File)new File(path));
        this.decodeDocument(doc);
    }

    private void decodeDocument(Document doc) {
        Element rootElem = doc.getRootElement();
        if (!"package".equals(rootElem.getName())) {
            throw new RuntimeException("Unexpected root element: " + rootElem.getName());
        }
        this.decodeElement(rootElem, new EncoderContext());
    }
}

