/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.importer;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.exception.LocalizedRuntimeException;
import com.ibm.cognos.aurora.api.importer.IImportPackage;
import com.ibm.cognos.aurora.api.importer.IImporter;
import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.importer.ImportOptions;
import com.ibm.cognos.aurora.api.importer.importspec.EDocumentType;
import com.ibm.cognos.aurora.api.importer.importspec.IImportSpecification;
import com.ibm.cognos.aurora.api.importer.importspec.action.IAnalyzeDataAction;
import com.ibm.cognos.aurora.api.importer.importspec.action.IImportDocumentAction;
import com.ibm.cognos.aurora.api.importer.importspec.action.INewModelAction;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.ISession;
import com.ibm.cognos.aurora.api.query.LocalSessionContext;
import com.ibm.cognos.aurora.api.smd.ISmartMetadata;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LogAction;
import com.ibm.cognos.aurora.core.logging.LogEventHelper;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.logging.ObjectType;
import com.ibm.cognos.aurora.core.logging.Status;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.aurora.core.util.ConfigHelper;
import com.ibm.cognos.aurora.core.xml.DOM4JUtil;
import com.ibm.cognos.aurora.importer.ImportPackage;
import com.ibm.cognos.aurora.importer.OlapDataSourceImporter;
import com.ibm.cognos.aurora.importer.PackageVersionMismatchException;
import com.ibm.cognos.aurora.importer.importspec.ImportSpecification;
import com.ibm.cognos.aurora.qls.util.IdentifierMaker;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.dom4j.Document;
import org.dom4j.Element;

public class ImporterImpl
implements IImporter {
    private static final String DEFAULT_LOCALE_ID = "en_US@calendar=gregorian";
    private static final String DEFAULT_ZONE_ID = "America/New_York";
    @Deprecated
    private static final String PACKAGES = "packages";
    @Deprecated
    private static final String PACKAGE_INDEX = "package-index.xml";
    @Deprecated
    private static final String MANIFEST = "manifest.xml";
    private static final List<String> DEFAULT_NULL_TOKENS = new LinkedList<String>();
    private static final ILogger LOGGER;
    @Deprecated
    private final HashSet<String> mPackageNames = new HashSet();
    @Deprecated
    private final HashMap<String, ImportPackage> mPackageCache = new HashMap();
    @Deprecated
    private final Lock mPackageIndexLock = new ReentrantLock();
    private Properties mConfig;
    private IQueryLogicalStorage mQLS;
    private ISmartMetadata mSMD;

    public void initialize(IQueryLogicalStorage qls, ISmartMetadata smd, Properties cfg) {
        PerfLogEvent perfEvent = null;
        if (LOGGER.isPerfDebugEnabled()) {
            perfEvent = LOGGER.startPerfDebug(this.getClass().getName(), "initialize", "Starting initialization of QLS Importer");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initializing QLS Importer with configuration: " + cfg.toString(), this.getClass().getName() + "::initialize()");
        }
        this.mConfig = cfg;
        this.mQLS = qls;
        this.mSMD = smd;
        if (!this.mConfig.containsKey("aurora.temp_dir")) {
            ImporterImpl.throwConfigurationMissing("aurora.temp_dir");
        }
        this.initializeTempDirectory();
        this.loadPackageIndex();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("QLS Importer was initialized", this.getClass().getName() + "::initialize()");
        }
        LOGGER.auditSystemEvent(LogEventHelper.createStartServiceEvent((ObjectType)ObjectType.QLSIMPORTSERVICE, (Status)Status.SUCCESS));
        if (perfEvent != null) {
            LOGGER.stopPerfDebug(perfEvent, "Finished initialization of QLS Importer");
        }
    }

    public void terminate() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Terminating QLS Importer", this.getClass().getName() + "::terminate()");
        }
        this.savePackageIndex();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("QLS Importer was terminated", this.getClass().getName() + "::terminate()");
        }
        LOGGER.auditSystemEvent(LogEventHelper.createStopServiceEvent((ObjectType)ObjectType.QLSIMPORTSERVICE, (Status)Status.SUCCESS));
    }

    public Properties getConfigurationProperties() {
        return this.mConfig;
    }

    public String getTempDirPath() {
        File baseTempDir = new File(ConfigHelper.getString((Properties)this.mConfig, (String)"aurora.temp_dir"));
        return FilenameUtils.concat((String)baseTempDir.getAbsolutePath(), (String)"aurora/importer");
    }

    public ULocale getDefaultLocale() {
        String defaultLocaleId = ConfigHelper.getString((Properties)this.mConfig, (String)"aurora.importer.default_locale", (String)DEFAULT_LOCALE_ID);
        if (defaultLocaleId.length() > 0) {
            return new ULocale(defaultLocaleId);
        }
        return ULocale.getDefault();
    }

    public TimeZone getDefaultZone() {
        String defaultZoneId = ConfigHelper.getString((Properties)this.mConfig, (String)"aurora.importer.default_zone", (String)DEFAULT_ZONE_ID);
        if (defaultZoneId.length() > 0) {
            return TimeZone.getTimeZone((String)defaultZoneId);
        }
        return TimeZone.getDefault();
    }

    public List<String> getNullTokens() {
        List nullTokens = ConfigHelper.getList((Properties)this.mConfig, (String)"aurora.importer.null_tokens");
        if (null != nullTokens) {
            return nullTokens;
        }
        return DEFAULT_NULL_TOKENS;
    }

    public IQueryLogicalStorage getQLS() {
        return this.mQLS;
    }

    public ISmartMetadata getSMD() {
        return this.mSMD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAssociativeModel importDocument(final File file, final ImportOptions options, ISession userSession) {
        PerfLogEvent perfEvent = null;
        if (LOGGER.isPerfDebugEnabled()) {
            perfEvent = LOGGER.startPerfDebug(this.getClass().getName(), "importDocument", "Calling ImportImpl::importDocument()", LogAction.CALL);
        }
        if (LOGGER.isDebugEnabled()) {
            String msg = String.format("Importing document '%s' with options %s", file.getPath(), options);
            LOGGER.debug(msg, this.getClass().getName() + "::importDocument()");
        }
        LocalSessionContext.set((ISession)userSession);
        try {
            final ULocale locale = this.resolveLocale(options, userSession);
            final String modelName = file.getName();
            final MutableBoolean alreadyExist = new MutableBoolean(true);
            IImportPackage pkg = null;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolved import locale to " + locale, this.getClass().getName() + "::importDocument()");
            }
            pkg = this.loadPackage(modelName, new Callable<IImportPackage>(){

                @Override
                public IImportPackage call() {
                    alreadyExist.setValue(false);
                    IImportSpecification spec = ImporterImpl.this.createImportSpecification();
                    spec.setPackageName(modelName);
                    spec.setReplaceOnConflict(true);
                    INewModelAction newModelAction = spec.addNewModelAction();
                    newModelAction.setModelName(modelName);
                    newModelAction.setOptions(options);
                    IImportDocumentAction importDocAction = spec.addImportDocumentAction();
                    importDocAction.setModelName(modelName);
                    importDocAction.setDocumentType(EDocumentType.AUTO);
                    importDocAction.setDocumentFilename(file.getAbsolutePath());
                    importDocAction.setDataLocale(locale);
                    importDocAction.setOptions(options);
                    IAnalyzeDataAction analyzeAction = spec.addAnalyzeDataAction();
                    analyzeAction.setModelName(modelName);
                    analyzeAction.setOptions(options);
                    return spec.run();
                }
            });
            if (file.lastModified() >= pkg.getCreationDate().getTime()) {
                this.destroyPackage(modelName);
                IAssociativeModel iAssociativeModel = this.importDocument(file, options, userSession);
                return iAssociativeModel;
            }
            IAssociativeModel iAssociativeModel = pkg.loadModel(modelName);
            return iAssociativeModel;
        }
        finally {
            LocalSessionContext.set(null);
            if (perfEvent != null) {
                LOGGER.stopPerfDebug(perfEvent, "Returned ImporterImpl::importDocument()", LogAction.RETURN);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAssociativeModel importOlapCube(IDataSource dataSource, String catalogName, String cubeName, ImportOptions options, ISession userSession) {
        PerfLogEvent perfEvent = null;
        if (LOGGER.isPerfDebugEnabled()) {
            perfEvent = LOGGER.startPerfDebug(this.getClass().getName(), "importOlapCube", "Calling ImportImpl::importOlapCube()", LogAction.CALL);
        }
        if (LOGGER.isDebugEnabled()) {
            String msg = String.format("Importing OLAP Cube '%s/%s' from data source '%s' with options %s", catalogName, cubeName, dataSource.getName(), options);
            LOGGER.debug(msg, this.getClass().getName() + "::importOlapCube()");
        }
        LocalSessionContext.set((ISession)userSession);
        try {
            ULocale locale = this.resolveLocale(options, userSession);
            IAssociativeModel model = this.getQLS().createModel(this.getSMD().getConceptInventory());
            OlapDataSourceImporter olapImporter = new OlapDataSourceImporter(this, model);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolved import locale to " + locale, this.getClass().getName() + "::importOlapCube()");
            }
            olapImporter.setDataSource(dataSource);
            olapImporter.setLocale(locale);
            olapImporter.setCatalogName(catalogName);
            olapImporter.setCubeName(cubeName);
            olapImporter.execute();
            IAssociativeModel iAssociativeModel = model;
            return iAssociativeModel;
        }
        finally {
            LocalSessionContext.set(null);
            if (perfEvent != null) {
                LOGGER.stopPerfDebug(perfEvent, "Returned ImporterImpl::importOlapCube()", LogAction.RETURN);
            }
        }
    }

    private ULocale resolveLocale(ImportOptions options, ISession userSession) {
        ULocale locale = this.getDefaultLocale();
        if (null != userSession) {
            locale = ULocale.forLocale((Locale)userSession.getContentLocale());
        }
        if (null != options && null != options.getLocale()) {
            locale = options.getLocale();
        }
        return locale;
    }

    private TimeZone resolveTimeZone(ImportOptions options, ISession userSession) {
        TimeZone tz = this.getDefaultZone();
        if (null != userSession) {
            tz = userSession.getTimeZone();
        }
        if (null != options && null != options.getTimeZone()) {
            tz = options.getTimeZone();
        }
        return tz;
    }

    @Deprecated
    public IImportSpecification createImportSpecification() {
        return new ImportSpecification(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean containsPackage(String name) {
        this.mPackageIndexLock.lock();
        try {
            boolean bl = this.mPackageNames.contains(name);
            return bl;
        }
        finally {
            this.mPackageIndexLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String[] getAllPackageNames() {
        this.mPackageIndexLock.lock();
        try {
            String[] stringArray = this.mPackageNames.toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.mPackageIndexLock.unlock();
        }
    }

    @Deprecated
    public ImportPackage createPackage(String name) {
        String packageDirPath = this.getPackageDirPath(name);
        File packageDir = new File(packageDirPath);
        if (!(packageDir.exists() || packageDir.mkdirs() || packageDir.exists())) {
            throw new ImportException("Failed to create package directory: " + packageDirPath);
        }
        ImportPackage pkg = new ImportPackage(this, name, packageDirPath);
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void commitPackage(ImportPackage pkg) {
        String manifestPath = FilenameUtils.concat((String)pkg.getPackageDirPath(), (String)MANIFEST);
        try {
            pkg.saveTo(manifestPath);
        }
        catch (Exception ex) {
            throw new ImportException((Throwable)ex);
        }
        this.mPackageIndexLock.lock();
        try {
            this.mPackageNames.add(pkg.getName());
            this.mPackageCache.put(pkg.getName(), pkg);
        }
        finally {
            this.mPackageIndexLock.unlock();
        }
        this.savePackageIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public IImportPackage loadPackage(String name, Callable<IImportPackage> onAbsentPackage) {
        ImportPackage pkg;
        block11: {
            pkg = null;
            this.mPackageIndexLock.lock();
            if (!this.mPackageNames.contains(name)) {
                IImportPackage iImportPackage = ImporterImpl.invokeOnAbsentPackage(onAbsentPackage);
                return iImportPackage;
            }
            pkg = this.mPackageCache.get(name);
            if (null != pkg) break block11;
            if (null == this.mQLS) {
                IImportPackage iImportPackage = null;
                return iImportPackage;
            }
            String packageDirPath = this.getPackageDirPath(name);
            String manifestFilePath = FilenameUtils.concat((String)packageDirPath, (String)MANIFEST);
            try {
                Document manifestDoc = DOM4JUtil.parseDocument((File)new File(manifestFilePath));
                pkg = new ImportPackage(this, name, packageDirPath);
                pkg.decodeElement(manifestDoc.getRootElement(), new EncoderContext());
            }
            catch (PackageVersionMismatchException ex) {
                IImportPackage iImportPackage = null;
                this.mPackageIndexLock.unlock();
                return iImportPackage;
            }
            catch (Exception ex) {
                throw new ImportException((Throwable)ex);
            }
            this.mPackageCache.put(name, pkg);
            break block11;
            finally {
                this.mPackageIndexLock.unlock();
            }
        }
        return pkg;
    }

    @Deprecated
    public IImportPackage loadPackage(String name) {
        return this.loadPackage(name, null);
    }

    @Deprecated
    public void destroyPackage(String name) {
        try {
            IImportPackage pkg = this.loadPackage(name);
            if (null != pkg) {
                pkg.destroy();
            }
        }
        catch (Exception ex) {
            this.removePackage(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removePackage(String name) {
        this.mPackageIndexLock.lock();
        try {
            if (this.mPackageNames.remove(name)) {
                this.mPackageCache.remove(name);
                if (null != this.mQLS) {
                    try {
                        FileUtils.forceDelete((File)new File(this.getPackageDirPath(name)));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        finally {
            this.mPackageIndexLock.unlock();
        }
        this.savePackageIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void savePackageIndex() {
        if (null == this.mQLS) {
            return;
        }
        try {
            FileUtils.forceMkdir((File)new File(this.getPackageRootDirPath()));
        }
        catch (IOException ex) {
            throw new ImportException((Throwable)ex);
        }
        Document indexDoc = DOM4JUtil.createDocument();
        Element rootElem = indexDoc.addElement("packageIndex");
        Element packagesElem = rootElem.addElement(PACKAGES);
        this.mPackageIndexLock.lock();
        try {
            for (String packageName : this.mPackageNames) {
                packagesElem.addElement("package").setText(packageName);
            }
        }
        finally {
            this.mPackageIndexLock.unlock();
        }
        try {
            DOM4JUtil.serializeDocument((File)new File(this.getPackageIndexFilePath()), (Document)indexDoc, (boolean)true);
        }
        catch (Exception ex) {
            throw new ImportException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void loadPackageIndex() {
        Document indexDoc;
        if (null == this.mQLS) {
            return;
        }
        File indexFile = new File(this.getPackageIndexFilePath());
        if (!indexFile.exists()) {
            return;
        }
        try {
            indexDoc = DOM4JUtil.parseDocument((File)indexFile);
        }
        catch (Exception ex) {
            throw new ImportException((Throwable)ex);
        }
        this.mPackageIndexLock.lock();
        try {
            this.mPackageCache.clear();
            this.mPackageNames.clear();
            Element rootElem = indexDoc.getRootElement();
            Element packagesElem = rootElem.element(PACKAGES);
            for (Element packageElem : packagesElem.elements("package")) {
                this.mPackageNames.add(packageElem.getText());
            }
        }
        finally {
            this.mPackageIndexLock.unlock();
        }
    }

    private void initializeTempDirectory() {
        File tempDirFile = new File(this.getTempDirPath());
        try {
            FileUtils.forceMkdir((File)tempDirFile);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Deprecated
    private String getPackageRootDirPath() {
        return FilenameUtils.concat((String)this.mQLS.getDataDirPath(), (String)PACKAGES);
    }

    @Deprecated
    private String getPackageIndexFilePath() {
        return FilenameUtils.concat((String)this.getPackageRootDirPath(), (String)PACKAGE_INDEX);
    }

    @Deprecated
    private String getPackageDirPath(String packageName) {
        return FilenameUtils.concat((String)this.getPackageRootDirPath(), (String)IdentifierMaker.fromParts((String[])new String[]{packageName}));
    }

    private static void throwConfigurationMissing(String propertyName) {
        throw new LocalizedRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, (Object)("A required configuration property was not set: " + propertyName));
    }

    @Deprecated
    private static IImportPackage invokeOnAbsentPackage(Callable<IImportPackage> onAbsentPackage) {
        IImportPackage result;
        if (null != onAbsentPackage) {
            try {
                result = onAbsentPackage.call();
            }
            catch (Exception e) {
                throw new LocalizedRuntimeException(CoreMessageKeys.GEN_FoundInternalError, (Throwable)e);
            }
        } else {
            result = null;
        }
        return result;
    }

    static {
        DEFAULT_NULL_TOKENS.add("");
        DEFAULT_NULL_TOKENS.add("--");
        DEFAULT_NULL_TOKENS.add("na");
        DEFAULT_NULL_TOKENS.add("n/a");
        LOGGER = LoggerManager.getLogger((String)"ATHENA.core.qls_import");
    }
}

