/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.importer;

import com.ibm.cognos.aurora.api.importer.IImporter;
import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.model.EDataSourceType;
import com.ibm.cognos.aurora.api.model.ENodeType;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapCube;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapDimension;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapLevel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMeasure;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMember;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMemberProperty;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapModel;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.provider.dim.ETreeOp;
import com.ibm.cognos.aurora.api.smd.ISmartMetadata;
import com.ibm.cognos.aurora.api.smd.SmdReqContext;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.api.smd.kb.IConceptInventory;
import com.ibm.cognos.aurora.core.model.ProviderDataItem;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapModelBuilder;
import com.ibm.icu.util.ULocale;
import java.util.EnumSet;
import java.util.Locale;

public class OlapDataSourceImporter {
    private final IImporter mImporter;
    private final IAssociativeModel mModel;
    private IDataSource mDataSource = null;
    private String mCatalogName = null;
    private String mCubeName = null;
    private ULocale mLocale = null;

    public OlapDataSourceImporter(IImporter importer, IAssociativeModel model) {
        this.mImporter = importer;
        this.mModel = model;
    }

    public IDataSource getDataSource() {
        return this.mDataSource;
    }

    public void setDataSource(IDataSource ds) {
        this.mDataSource = ds;
    }

    public String getCatalogName() {
        return this.mCatalogName;
    }

    public void setCatalogName(String catalogName) {
        this.mCatalogName = catalogName;
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void execute() {
        if (null == this.mDataSource) {
            throw new IllegalStateException("A data source was not specified");
        }
        if (this.mDataSource.getType() != EDataSourceType.DIMENSIONAL) {
            throw new IllegalStateException("Data source type was not dimensional");
        }
        if (null == this.mCatalogName) {
            throw new IllegalStateException("A catalog name was not specified");
        }
        if (null == this.mCubeName) {
            throw new IllegalStateException("A cube name was not specified");
        }
        IQueryLogicalStorage qls = this.mImporter.getQLS();
        OlapModelBuilder builder = new OlapModelBuilder();
        builder.setDataSource(this.mDataSource);
        builder.setLocale(this.getLocale());
        builder.setQLS(qls);
        builder.addCube(this.mCatalogName, this.mCubeName);
        IOlapModel olapModel = (IOlapModel)builder.build();
        this.mModel.addPhysicalModel((IPhysicalModel)olapModel);
        this.populateRootContainer(this.mModel.getRootContainer(), olapModel);
        ISmartMetadata smd = this.mImporter.getSMD();
        SmdReqContext reqCtx = new SmdReqContext(SmdReqContext.EScope.eDecorateModel);
        smd.analyze(this.mModel, reqCtx);
        this.mModel.rebuildIndexes();
    }

    private void populateRootContainer(IDataContainer rootContainer, IOlapModel physModel) {
        for (IOlapCube cube : physModel.getCubes()) {
            this.populateCubeContainer(rootContainer.createChild(cube.getInternalName(), "OLAPCube"), cube);
        }
    }

    private void populateCubeContainer(IDataContainer cubeContainer, IOlapCube cube) {
        for (IOlapDimension dim : cube.getDimensions()) {
            this.populateDimContainer(cubeContainer.createChild(dim.getInternalName(), "OLAPDimension"), dim);
        }
    }

    private void populateDimContainer(IDataContainer dimContainer, IOlapDimension dim) {
        if (dim.isMeasureDimension()) {
            for (IOlapMember m : dim.getDefaultHierarchy().getRootMembers()) {
                this.processMeasure(dimContainer, (IOlapMeasure)m, null);
            }
        } else {
            for (IOlapHierarchy hier : dim.getHierarchies()) {
                this.populateHierContainer(dimContainer.createChild(hier.getInternalName(), "OLAPHierarchy"), hier);
            }
        }
    }

    private void processMeasure(IDataContainer dimContainer, IOlapMeasure measure, INode parentNode) {
        IAssociativeModel model = dimContainer.getModel();
        IConceptInventory conceptInv = model.getConceptInventory();
        ProviderDataItem measureDI = new ProviderDataItem(measure.getName(), measure.getDataType());
        measureDI.setPhysicalMetadata((IPhysicalMetadata)measure);
        dimContainer.addDataItem((IDataItem)measureDI);
        INode metric = model.createNode(ENodeType.METRIC, conceptInv.getGenericMetric(), (IDataItem)measureDI, 0.99f);
        metric.setProperty("__label", (Object)measure.getCaption());
        dimContainer.addNode(metric);
        if (null != parentNode) {
            model.createEdge(parentNode, metric, "child", ECardinality.OneMany, true);
        }
        for (IOlapMember child : measure.fetchRelatedMembers(EnumSet.of(ETreeOp.CHILDREN))) {
            this.processMeasure(dimContainer, (IOlapMeasure)child, metric);
        }
    }

    private void populateHierContainer(IDataContainer hierContainer, IOlapHierarchy hier) {
        INode parentCat = null;
        for (IOlapLevel level : hier.getLevels()) {
            parentCat = this.processLevel(hierContainer, level, parentCat);
        }
    }

    private INode processLevel(IDataContainer hierContainer, IOlapLevel level, INode parentCat) {
        String levelLabel;
        String levelName;
        IAssociativeModel model = hierContainer.getModel();
        IConceptInventory conceptInv = model.getConceptInventory();
        if (level.getHierarchy().isParentChild()) {
            levelName = level.getHierarchy().getName() + " (Depth " + level.getLevelNumber() + ")";
            levelLabel = level.getHierarchy().getCaption() + " (Depth " + level.getLevelNumber() + ")";
        } else {
            levelName = level.getName();
            levelLabel = level.getCaption();
        }
        ProviderDataItem levelDI = new ProviderDataItem(levelName, (IDataType)DataTypes.getStringType((int)Integer.MAX_VALUE));
        levelDI.setPhysicalMetadata((IPhysicalMetadata)level);
        hierContainer.addDataItem((IDataItem)levelDI);
        INode levelCat = model.createNode(ENodeType.CATEGORY, conceptInv.getGenericCategory(), null, 0.99f);
        levelCat.setProperty("__label", (Object)levelLabel);
        hierContainer.addNode(levelCat);
        if (null != parentCat) {
            model.createEdge(parentCat, levelCat, "child", ECardinality.OneOne, true);
        }
        INode idAttr = model.createNode(ENodeType.ATTRIBUTE, conceptInv.getConcept("cIdentifier"), (IDataItem)levelDI, 0.99f);
        idAttr.setProperty("__label", (Object)levelLabel);
        model.createEdge(levelCat, idAttr, "has", ECardinality.OneOne, false);
        hierContainer.addNode(idAttr);
        for (IOlapMemberProperty prop : level.getMemberProperties()) {
            this.processMemberProperty(hierContainer, levelCat, levelName, levelLabel, prop);
        }
        return levelCat;
    }

    private void processMemberProperty(IDataContainer hierContainer, INode levelCat, String levelName, String levelLabel, IOlapMemberProperty prop) {
        IConcept concept;
        IAssociativeModel model = levelCat.getModel();
        IConceptInventory conceptInv = model.getConceptInventory();
        String propName = prop.getName() + " (" + levelName + ")";
        String propLabel = prop.getCaption() + " (" + levelLabel + ")";
        ProviderDataItem propDI = new ProviderDataItem(propName, prop.getDataType());
        propDI.setPhysicalMetadata((IPhysicalMetadata)prop);
        hierContainer.addDataItem((IDataItem)propDI);
        switch (prop.getRole()) {
            case MEMBER_CAPTION: {
                concept = conceptInv.getConcept("cCaption");
                break;
            }
            default: {
                concept = conceptInv.getConcept("cAttribute");
            }
        }
        INode propAttr = model.createNode(ENodeType.ATTRIBUTE, concept, (IDataItem)propDI, 0.99f);
        propAttr.setProperty("__label", (Object)propLabel);
        hierContainer.addNode(propAttr);
        model.createEdge(levelCat, propAttr, "has", ECardinality.OneOne, false);
    }

    public ULocale getLocale() {
        return this.mLocale;
    }

    public void setLocale(ULocale locale) {
        this.mLocale = locale;
    }

    public void setLocale(Locale locale) {
        this.mLocale = new ULocale(locale.toString());
    }
}

