/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.importer;

import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.model.EDataSourceType;
import com.ibm.cognos.aurora.api.model.ENodeType;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelColumn;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelTable;
import com.ibm.cognos.aurora.api.model.value.DateTimeValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.api.smd.kb.IConceptInventory;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.core.model.ProviderDataItem;
import com.ibm.cognos.aurora.core.model.RelationalDataItems;
import com.ibm.cognos.aurora.core.util.Pair;
import com.ibm.cognos.aurora.importer.CalendarTableGenerator;
import com.ibm.cognos.aurora.importer.IPostAnalysisProcessor;
import com.ibm.icu.util.ULocale;
import java.util.LinkedList;

public class SynthesizeDateHierarchies
implements IPostAnalysisProcessor {
    private static final ILogger mLogger = LoggerManager.getLogger((String)"ATHENA.core.qls_import");
    private final IRelTable mPhysCalTable;
    private final CalendarTableGenerator mCalGen;
    private final IDataContainer mContainer;

    public SynthesizeDateHierarchies(IRelTable physCalTable, CalendarTableGenerator calGen, IDataContainer container, ULocale locale) {
        this.mPhysCalTable = physCalTable;
        this.mCalGen = calGen;
        this.mContainer = container;
    }

    @Override
    public void process(IAssociativeModel model) {
        Pair<DateTimeValue, DateTimeValue> minMaxDates = this.processContainer(this.mContainer);
        if (null != minMaxDates && null != minMaxDates.getFirst() && null != minMaxDates.getSecond()) {
            if (mLogger.isInfoEnabled()) {
                mLogger.info(String.format("Calendar date range is from %s to %s (inclusive)", ((DateTimeValue)minMaxDates.getFirst()).toString(), ((DateTimeValue)minMaxDates.getSecond()).toString()), this.getClass().getName() + "::process()");
            }
            this.mCalGen.populateTable(((DateTimeValue)minMaxDates.getFirst()).getYear(), ((DateTimeValue)minMaxDates.getSecond()).getYear());
        } else if (mLogger.isInfoEnabled()) {
            mLogger.info("No date categories were found", this.getClass().getName() + "::process()");
        }
    }

    private Pair<DateTimeValue, DateTimeValue> processContainer(IDataContainer container) {
        if (mLogger.isInfoEnabled()) {
            mLogger.info(String.format("Processing container '%s'", container.getId().toUniqueName()), this.getClass().getName() + "::processContainer()");
        }
        IConceptInventory conceptInv = container.getModel().getConceptInventory();
        IConcept dateConcept = conceptInv.getConcept("cDate");
        Pair minMaxDates = new Pair();
        LinkedList<INode> dateNodesToProcess = new LinkedList<INode>();
        for (INode n : container.getNodes()) {
            if (!n.getConcept().is(dateConcept) || Boolean.TRUE.equals(n.getProperty("__isDateHierarchy"))) continue;
            dateNodesToProcess.add(n);
        }
        for (INode dateCat : dateNodesToProcess) {
            INode dateIdentAttr = NavigationHelper.getDefaultAttributeNode((INode)dateCat);
            assert (null != dateIdentAttr);
            assert (null != dateIdentAttr.getDataItem());
            if (mLogger.isInfoEnabled()) {
                mLogger.info(String.format("Building a date hierarchy for data item '%s'", dateIdentAttr.getDataItem().toString()), this.getClass().getName() + "::processContainer()");
            }
            this.buildDateHierarchy(container, dateCat);
            IDataItemStats stats = dateIdentAttr.getDataItem().getStats();
            if (null == stats || stats.minValue().isNull() || !stats.minValue().getType().isTemporal() || stats.maxValue().isNull() || !stats.maxValue().getType().isTemporal()) continue;
            if (null == minMaxDates.getFirst() || ((DateTimeValue)minMaxDates.getFirst()).compareTo(stats.minValue()) > 0) {
                minMaxDates.setFirst((Object)((DateTimeValue)stats.minValue()));
            }
            if (null != minMaxDates.getSecond() && ((DateTimeValue)minMaxDates.getSecond()).compareTo(stats.maxValue()) >= 0) continue;
            minMaxDates.setSecond((Object)((DateTimeValue)stats.maxValue()));
        }
        for (IDataContainer child : container.getChildren()) {
            Pair<DateTimeValue, DateTimeValue> childMinMaxDates = this.processContainer(child);
            if (null == childMinMaxDates || null == childMinMaxDates.getFirst() || null == childMinMaxDates.getSecond()) continue;
            if (null == minMaxDates.getFirst() || ((DateTimeValue)minMaxDates.getFirst()).compareTo((IValue)childMinMaxDates.getFirst()) > 0) {
                minMaxDates.setFirst(childMinMaxDates.getFirst());
            }
            if (null != minMaxDates.getSecond() && ((DateTimeValue)minMaxDates.getSecond()).compareTo((IValue)childMinMaxDates.getSecond()) >= 0) continue;
            minMaxDates.setSecond(childMinMaxDates.getSecond());
        }
        return minMaxDates;
    }

    private void buildDateHierarchy(IDataContainer container, INode dateCat) {
        IAssociativeModel model = dateCat.getModel();
        String dateLabel = MetadataHelper.getDefaultDataItem((INode)dateCat).getName();
        IDataSource ds = this.mPhysCalTable.getModel().getDataSource();
        if (null == ds) {
            throw new ImportException("Unable to find a data source for category: " + dateCat.toString());
        }
        if (ds.getType() != EDataSourceType.RELATIONAL) {
            throw new ImportException("Unable to process non-relational datasource");
        }
        IRelColumn yearCol = this.mPhysCalTable.findColumn("year");
        IRelColumn quarterCol = this.mPhysCalTable.findColumn("quarter");
        IRelColumn quarterCaptCol = this.mPhysCalTable.findColumn("quarter_caption");
        IRelColumn monthCol = this.mPhysCalTable.findColumn("month");
        IRelColumn monthCaptCol = this.mPhysCalTable.findColumn("month_caption");
        IRelColumn dayOfMonthCol = this.mPhysCalTable.findColumn("day_of_month");
        IRelColumn dayOfMonthCaptCol = this.mPhysCalTable.findColumn("day_of_month_caption");
        ProviderDataItem yearDI = new ProviderDataItem("Year (" + dateLabel + ")", yearCol.getDataType());
        yearDI.setPhysicalMetadata((IPhysicalMetadata)yearCol);
        RelationalDataItems.setSchemaName((IDataItem)yearDI, (String)this.mPhysCalTable.getSchemaName());
        RelationalDataItems.setTableName((IDataItem)yearDI, (String)this.mPhysCalTable.getTableName());
        RelationalDataItems.setColumnName((IDataItem)yearDI, (String)yearCol.getColumnName());
        container.addDataItem((IDataItem)yearDI);
        ProviderDataItem quarterDI = new ProviderDataItem("Quarter (" + dateLabel + ")", quarterCol.getDataType());
        quarterDI.setPhysicalMetadata((IPhysicalMetadata)quarterCol);
        RelationalDataItems.setSchemaName((IDataItem)quarterDI, (String)this.mPhysCalTable.getSchemaName());
        RelationalDataItems.setTableName((IDataItem)quarterDI, (String)this.mPhysCalTable.getTableName());
        RelationalDataItems.setColumnName((IDataItem)quarterDI, (String)quarterCol.getColumnName());
        container.addDataItem((IDataItem)quarterDI);
        ProviderDataItem quarterCaptDI = new ProviderDataItem("Quarter Caption (" + dateLabel + ")", quarterCaptCol.getDataType());
        quarterCaptDI.setPhysicalMetadata((IPhysicalMetadata)quarterCaptCol);
        RelationalDataItems.setSchemaName((IDataItem)quarterCaptDI, (String)this.mPhysCalTable.getSchemaName());
        RelationalDataItems.setTableName((IDataItem)quarterCaptDI, (String)this.mPhysCalTable.getTableName());
        RelationalDataItems.setColumnName((IDataItem)quarterCaptDI, (String)quarterCaptCol.getColumnName());
        container.addDataItem((IDataItem)quarterCaptDI);
        ProviderDataItem monthDI = new ProviderDataItem("Month (" + dateLabel + ")", monthCol.getDataType());
        monthDI.setPhysicalMetadata((IPhysicalMetadata)monthCol);
        RelationalDataItems.setSchemaName((IDataItem)monthDI, (String)this.mPhysCalTable.getSchemaName());
        RelationalDataItems.setTableName((IDataItem)monthDI, (String)this.mPhysCalTable.getTableName());
        RelationalDataItems.setColumnName((IDataItem)monthDI, (String)monthCol.getColumnName());
        container.addDataItem((IDataItem)monthDI);
        ProviderDataItem monthCaptDI = new ProviderDataItem("Month Caption (" + dateLabel + ")", monthCaptCol.getDataType());
        monthCaptDI.setPhysicalMetadata((IPhysicalMetadata)monthCaptCol);
        RelationalDataItems.setSchemaName((IDataItem)monthCaptDI, (String)this.mPhysCalTable.getSchemaName());
        RelationalDataItems.setTableName((IDataItem)monthCaptDI, (String)this.mPhysCalTable.getTableName());
        RelationalDataItems.setColumnName((IDataItem)monthCaptDI, (String)monthCaptCol.getColumnName());
        container.addDataItem((IDataItem)monthCaptDI);
        ProviderDataItem dayOfMonthDI = new ProviderDataItem("Day (" + dateLabel + ")", dayOfMonthCol.getDataType());
        dayOfMonthDI.setPhysicalMetadata((IPhysicalMetadata)dayOfMonthCol);
        RelationalDataItems.setSchemaName((IDataItem)dayOfMonthDI, (String)this.mPhysCalTable.getSchemaName());
        RelationalDataItems.setTableName((IDataItem)dayOfMonthDI, (String)this.mPhysCalTable.getTableName());
        RelationalDataItems.setColumnName((IDataItem)dayOfMonthDI, (String)dayOfMonthCol.getColumnName());
        container.addDataItem((IDataItem)dayOfMonthDI);
        ProviderDataItem dayOfMonthCaptDI = new ProviderDataItem("Day Caption (" + dateLabel + ")", dayOfMonthCaptCol.getDataType());
        dayOfMonthCaptDI.setPhysicalMetadata((IPhysicalMetadata)dayOfMonthCaptCol);
        RelationalDataItems.setSchemaName((IDataItem)dayOfMonthDI, (String)this.mPhysCalTable.getSchemaName());
        RelationalDataItems.setTableName((IDataItem)dayOfMonthCaptDI, (String)this.mPhysCalTable.getTableName());
        RelationalDataItems.setColumnName((IDataItem)dayOfMonthCaptDI, (String)dayOfMonthCaptCol.getColumnName());
        container.addDataItem((IDataItem)dayOfMonthCaptDI);
        IConceptInventory conceptInv = model.getConceptInventory();
        IConcept identiferConcept = conceptInv.getConcept("cIdentifier");
        IConcept captionConcept = conceptInv.getConcept("cCaption");
        IConcept yearConcept = conceptInv.getConcept("cYear");
        IConcept quarterConcept = conceptInv.getConcept("cQuarter");
        IConcept monthConcept = conceptInv.getConcept("cMonth");
        IConcept dayOfMonthConcept = conceptInv.getConcept("cDayOfMonth");
        if (null == identiferConcept) {
            throw new ImportException("Unable to find concept by name: cIdentifier");
        }
        if (null == captionConcept) {
            throw new ImportException("Unable to find concept by name: cCaption");
        }
        if (null == yearConcept) {
            throw new ImportException("Unable to find concept by name: cYear");
        }
        if (null == quarterConcept) {
            throw new ImportException("Unable to find concept by name: cQuarter");
        }
        if (null == monthConcept) {
            throw new ImportException("Unable to find concept by name: cMonth");
        }
        if (null == dayOfMonthConcept) {
            throw new ImportException("Unable to find concept by name: cDayOfMonth");
        }
        INode yearCat = model.createNode(ENodeType.CATEGORY, yearConcept, null, 1.0f);
        yearCat.setProperty("__label", (Object)yearDI.getName());
        INode yearIdentAttr = model.createNode(ENodeType.ATTRIBUTE, identiferConcept, (IDataItem)yearDI, 1.0f);
        container.addNode(yearCat);
        container.addNode(yearIdentAttr);
        model.createEdge(yearCat, yearIdentAttr, "has", ECardinality.OneOne, false);
        INode quarterCat = model.createNode(ENodeType.CATEGORY, quarterConcept, null, 1.0f);
        quarterCat.setProperty("__label", (Object)quarterDI.getName());
        INode quarterIdentAttr = model.createNode(ENodeType.ATTRIBUTE, identiferConcept, (IDataItem)quarterDI, 1.0f);
        INode quarterCaptAttr = model.createNode(ENodeType.ATTRIBUTE, captionConcept, (IDataItem)quarterCaptDI, 1.0f);
        container.addNode(quarterCat);
        container.addNode(quarterIdentAttr);
        container.addNode(quarterCaptAttr);
        model.createEdge(quarterCat, quarterIdentAttr, "has", ECardinality.OneOne, false);
        model.createEdge(quarterCat, quarterCaptAttr, "has", ECardinality.OneOne, false);
        INode monthCat = model.createNode(ENodeType.CATEGORY, monthConcept, null, 1.0f);
        monthCat.setProperty("__label", (Object)monthDI.getName());
        INode monthIdentAttr = model.createNode(ENodeType.ATTRIBUTE, identiferConcept, (IDataItem)monthDI, 1.0f);
        INode monthCaptAttr = model.createNode(ENodeType.ATTRIBUTE, captionConcept, (IDataItem)monthCaptDI, 1.0f);
        container.addNode(monthCat);
        container.addNode(monthIdentAttr);
        container.addNode(monthCaptAttr);
        model.createEdge(monthCat, monthIdentAttr, "has", ECardinality.OneOne, false);
        model.createEdge(monthCat, monthCaptAttr, "has", ECardinality.OneOne, false);
        INode dayOfMonthCat = model.createNode(ENodeType.CATEGORY, dayOfMonthConcept, null, 1.0f);
        dayOfMonthCat.setProperty("__label", (Object)dayOfMonthDI.getName());
        INode dayOfMonthIdentAttr = model.createNode(ENodeType.ATTRIBUTE, identiferConcept, (IDataItem)dayOfMonthDI, 1.0f);
        INode dayOfMonthCaptAttr = model.createNode(ENodeType.ATTRIBUTE, captionConcept, (IDataItem)dayOfMonthCaptDI, 1.0f);
        container.addNode(dayOfMonthCat);
        container.addNode(dayOfMonthIdentAttr);
        container.addNode(dayOfMonthCaptAttr);
        model.createEdge(dayOfMonthCat, dayOfMonthIdentAttr, "has", ECardinality.OneOne, false);
        model.createEdge(dayOfMonthCat, dayOfMonthCaptAttr, "has", ECardinality.OneOne, false);
        model.createEdge(yearCat, quarterCat, "contains", ECardinality.OneMany, true);
        model.createEdge(quarterCat, monthCat, "contains", ECardinality.OneMany, true);
        model.createEdge(monthCat, dayOfMonthCat, "contains", ECardinality.OneMany, true);
        model.createEdge(dateCat, yearCat, "breakdown", ECardinality.OneOne, false);
        model.createEdge(dateCat, quarterCat, "breakdown", ECardinality.OneOne, false);
        model.createEdge(dateCat, monthCat, "breakdown", ECardinality.OneOne, false);
        model.createEdge(dateCat, dayOfMonthCat, "breakdown", ECardinality.OneOne, false);
        dateCat.setProperty("__isDateHierarchy", (Object)Boolean.TRUE);
        dateCat.setProperty("__calendarTable", (Object)this.mPhysCalTable.getTableName());
        dateCat.setProperty("__calendarDateColumn", (Object)this.mPhysCalTable.findColumn("iso_date").getColumnName());
    }
}

