/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.importer.deploy;

import com.ibm.cognos.aurora.api.importer.IImporter;
import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.model.ENodeType;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapCube;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapDimension;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapLevel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMeasure;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMember;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMemberProperty;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapModel;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.provider.dim.ETreeOp;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.api.smd.kb.IConceptInventory;
import com.ibm.cognos.aurora.api.storage.data.ILocalDataStorage;
import com.ibm.cognos.aurora.api.storage.data.pmta.IDeployedCube;
import com.ibm.cognos.aurora.api.storage.data.pmta.ILocalPMTAStorage;
import com.ibm.cognos.aurora.core.model.ProviderDataItem;
import com.ibm.cognos.aurora.importer.ImportContext;
import com.ibm.cognos.aurora.importer.RebuildModelIndexes;
import java.io.File;
import java.util.EnumSet;

public class LocalPMTAStorageDeployer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILocalDataStorage deploy(ImportContext importContext, String dataSourceName, File documentFile) throws ImportException {
        IImporter importer = importContext.getImporter();
        IQueryLogicalStorage qls = importer.getQLS();
        ILocalPMTAStorage storage = qls.getLocalDataRepository().createPMTAStorage();
        boolean succeeded = false;
        try {
            storage.quickImport(documentFile.getAbsolutePath(), dataSourceName, importContext.getDeployLocale());
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                storage.destroy();
            } else {
                importContext.getPackage().addLocalStorage((ILocalDataStorage)storage);
            }
        }
        return storage;
    }

    public void initializeAssociativeModel(ImportContext importContext, String dataSourceName, IAssociativeModel model, ILocalDataStorage storage) throws ImportException {
        ILocalPMTAStorage pmtaStorage = (ILocalPMTAStorage)storage;
        IOlapModel physModel = (IOlapModel)storage.buildPhysicalModel(dataSourceName, importContext.getDeployLocale());
        model.addPhysicalModel((IPhysicalModel)physModel);
        IDeployedCube deployedCube = pmtaStorage.getCube(dataSourceName);
        if (null == deployedCube) {
            throw new ImportException("Cube was not deployed: " + dataSourceName);
        }
        IOlapCube cube = physModel.findCube(pmtaStorage.getCatalogName(), deployedCube.getIdentifier());
        IDataContainer cubeContainer = model.getRootContainer().createChild(cube.getName(), "OLAPCube");
        this.populateCube(cubeContainer, cube);
        importContext.setDecorationOnlyAnalysis(true);
        importContext.addPostAnalysisProcessor(new RebuildModelIndexes());
    }

    private void populateCube(IDataContainer container, IOlapCube cube) {
        for (IOlapDimension dim : cube.getDimensions()) {
            IDataContainer dimContainer = container.createChild(dim.getName(), "OLAPDimension");
            if (dim.isMeasureDimension()) {
                for (IOlapMember m : dim.getDefaultHierarchy().getRootMembers()) {
                    this.processMeasure(dimContainer, (IOlapMeasure)m, null);
                }
                continue;
            }
            for (IOlapHierarchy hier : dim.getHierarchies()) {
                IDataContainer hierContainer = dimContainer.createChild(hier.getName(), "OLAPHierarchy");
                this.processHierarchy(hierContainer, hier);
            }
        }
    }

    private void processMeasure(IDataContainer container, IOlapMeasure measure, INode parentNode) {
        IAssociativeModel model = container.getModel();
        IConceptInventory conceptInv = model.getConceptInventory();
        ProviderDataItem measureDI = new ProviderDataItem(measure.getName(), measure.getDataType());
        measureDI.setPhysicalMetadata((IPhysicalMetadata)measure);
        container.addDataItem((IDataItem)measureDI);
        INode metric = model.createNode(ENodeType.METRIC, conceptInv.getGenericMetric(), (IDataItem)measureDI, 0.99f);
        metric.setProperty("__label", (Object)measure.getCaption());
        container.addNode(metric);
        if (null != parentNode) {
            model.createEdge(parentNode, metric, "child", ECardinality.OneMany, true);
        }
        for (IOlapMember child : measure.fetchRelatedMembers(EnumSet.of(ETreeOp.CHILDREN))) {
            this.processMeasure(container, (IOlapMeasure)child, metric);
        }
    }

    private void processHierarchy(IDataContainer container, IOlapHierarchy hier) {
        INode parentCat = null;
        for (IOlapLevel level : hier.getLevels()) {
            parentCat = this.processLevel(container, level, parentCat);
        }
    }

    private INode processLevel(IDataContainer container, IOlapLevel level, INode parentCat) {
        String levelLabel;
        String levelName;
        IAssociativeModel model = container.getModel();
        IConceptInventory conceptInv = model.getConceptInventory();
        if (level.getHierarchy().isParentChild()) {
            levelLabel = levelName = String.format("Level %d", level.getLevelNumber());
        } else {
            levelName = level.getName();
            levelLabel = level.getCaption();
        }
        ProviderDataItem levelDI = new ProviderDataItem(levelName, (IDataType)DataTypes.getStringType((int)Integer.MAX_VALUE));
        levelDI.setPhysicalMetadata((IPhysicalMetadata)level);
        container.addDataItem((IDataItem)levelDI);
        INode levelCat = model.createNode(ENodeType.CATEGORY, conceptInv.getGenericCategory(), null, 0.99f);
        levelCat.setProperty("__label", (Object)levelLabel);
        container.addNode(levelCat);
        if (null != parentCat) {
            model.createEdge(parentCat, levelCat, "child", ECardinality.OneMany, true);
        }
        INode idAttr = model.createNode(ENodeType.ATTRIBUTE, conceptInv.getConcept("cIdentifier"), (IDataItem)levelDI, 0.99f);
        idAttr.setProperty("__label", (Object)levelLabel);
        model.createEdge(levelCat, idAttr, "has", ECardinality.OneOne, false);
        container.addNode(idAttr);
        for (IOlapMemberProperty prop : level.getMemberProperties()) {
            this.processMemberProperty(container, levelCat, levelName, levelLabel, prop);
        }
        return levelCat;
    }

    private void processMemberProperty(IDataContainer container, INode levelCat, String levelName, String levelLabel, IOlapMemberProperty prop) {
        IConcept concept;
        IAssociativeModel model = levelCat.getModel();
        IConceptInventory conceptInv = model.getConceptInventory();
        String propName = levelName + "." + prop.getName();
        String propLabel = levelLabel + "." + prop.getCaption();
        ProviderDataItem propDI = new ProviderDataItem(propName, prop.getDataType());
        propDI.setPhysicalMetadata((IPhysicalMetadata)prop);
        container.addDataItem((IDataItem)propDI);
        switch (prop.getRole()) {
            case MEMBER_CAPTION: {
                concept = conceptInv.getConcept("cCaption");
                break;
            }
            default: {
                concept = conceptInv.getConcept("cAttribute");
            }
        }
        INode propAttr = model.createNode(ENodeType.ATTRIBUTE, concept, (IDataItem)propDI, 0.99f);
        propAttr.setProperty("__label", (Object)propLabel);
        container.addNode(propAttr);
        model.createEdge(levelCat, propAttr, "has", ECardinality.OneOne, false);
    }
}

