/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.importer.deploy;

import com.ibm.cognos.aurora.api.importer.IImporter;
import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelColumn;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelModel;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelTable;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.decor.IValueDecoration;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.storage.data.ILocalDataStorage;
import com.ibm.cognos.aurora.api.storage.data.tabular.ColumnConstraint;
import com.ibm.cognos.aurora.api.storage.data.tabular.ColumnType;
import com.ibm.cognos.aurora.api.storage.data.tabular.IBatchRowInsert;
import com.ibm.cognos.aurora.api.storage.data.tabular.IColumnDescriptor;
import com.ibm.cognos.aurora.api.storage.data.tabular.ILocalTabularStorage;
import com.ibm.cognos.aurora.api.storage.data.tabular.ITable;
import com.ibm.cognos.aurora.api.storage.data.tabular.ITableDescriptor;
import com.ibm.cognos.aurora.core.extract.ExtractionContext;
import com.ibm.cognos.aurora.core.extract.TabularDataset;
import com.ibm.cognos.aurora.core.extract.TabularDatasetReader;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.model.ProviderDataItem;
import com.ibm.cognos.aurora.core.model.RelationalDataItems;
import com.ibm.cognos.aurora.importer.CalendarTableGenerator;
import com.ibm.cognos.aurora.importer.ImportContext;
import com.ibm.cognos.aurora.importer.RebuildModelIndexes;
import com.ibm.cognos.aurora.importer.SynthesizeDateHierarchies;
import java.util.EnumSet;
import java.util.Map;

public class LocalTabularStorageDeployer {
    private static final ILogger mLogger = LoggerManager.getLogger((String)"ATHENA.core.qls_import");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILocalDataStorage deploy(ImportContext importContext, ExtractionContext extractionContext) throws ImportException {
        IImporter importer = importContext.getImporter();
        IQueryLogicalStorage qls = importer.getQLS();
        ILocalTabularStorage storage = qls.getLocalDataRepository().createTabularStorage();
        boolean succeeded = false;
        try {
            this.deploy(qls, storage, extractionContext.getAllDatasets());
            CalendarTableGenerator calTableGen = new CalendarTableGenerator(importContext.getDeployLocale());
            calTableGen.createTable(storage);
            importContext.setCalTableGen(calTableGen);
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                storage.destroy();
            } else {
                importContext.getPackage().addLocalStorage((ILocalDataStorage)storage);
            }
        }
        return storage;
    }

    public void initializeAssociativeModel(ImportContext importContext, ExtractionContext extractionContext, IAssociativeModel model, ILocalDataStorage storage) throws ImportException {
        CalendarTableGenerator calTableGen = importContext.getCalTableGen();
        ILocalTabularStorage tabularStorage = (ILocalTabularStorage)storage;
        IRelModel physModel = (IRelModel)storage.buildPhysicalModel(extractionContext.getDataSourceName(), importContext.getDeployLocale());
        model.addPhysicalModel((IPhysicalModel)physModel);
        IDataContainer dataSourceContainer = model.getRootContainer().createChild(extractionContext.getDataSourceName(), extractionContext.getDataSourceType());
        for (Map.Entry e : extractionContext.getDataSourceProperties().entrySet()) {
            dataSourceContainer.setProperty((String)e.getKey(), (IValue)e.getValue());
        }
        for (TabularDataset ds : extractionContext.getAllDatasets()) {
            IDataContainer datasetContainer = dataSourceContainer.createChild(ds.getDatasetName(), ds.getDatasetType());
            for (Map.Entry e : ds.getDatasetProperties().entrySet()) {
                datasetContainer.setProperty((String)e.getKey(), (IValue)e.getValue());
            }
            ITable table = tabularStorage.getTable(ds.getDatasetName());
            if (null == table) {
                throw new ImportException("Dataset was not deployed: " + ds.getDatasetName());
            }
            ITableDescriptor tableDesc = table.getDescriptor();
            IRelTable physTable = physModel.findTable(tabularStorage.getSchemaName(), tabularStorage.getCatalogName(), tableDesc.getIdentifier());
            if (null == physTable) {
                throw new ImportException("Table was not found in physical model: " + tableDesc.getIdentifier());
            }
            for (TabularDataset.ColumnInfo colInfo : ds.getColumns()) {
                IColumnDescriptor colDesc = tableDesc.getColumn(colInfo.getName());
                if (null == colDesc) {
                    throw new ImportException("Data item was not deployed: " + colInfo.getName());
                }
                IRelColumn physCol = physTable.findColumn(colDesc.getIdentifier());
                if (null == physCol) {
                    throw new ImportException("Column was not found in physical model: " + colDesc.getIdentifier());
                }
                ProviderDataItem di = new ProviderDataItem(colInfo.getName(), colInfo.getDataType());
                di.setPhysicalMetadata((IPhysicalMetadata)physCol);
                for (IValueDecoration decor : colInfo.getValueDecorations()) {
                    di.addValueDecoration(decor);
                }
                RelationalDataItems.setSchemaName((IDataItem)di, (String)tabularStorage.getSchemaName());
                RelationalDataItems.setTableName((IDataItem)di, (String)tableDesc.getIdentifier());
                RelationalDataItems.setColumnName((IDataItem)di, (String)colDesc.getIdentifier());
                datasetContainer.addDataItem((IDataItem)di);
            }
        }
        if (null != calTableGen) {
            IRelTable physCalTable = physModel.findTable(tabularStorage.getSchemaName(), tabularStorage.getCatalogName(), calTableGen.getTable().getIdentifier());
            importContext.addPostAnalysisProcessor(new SynthesizeDateHierarchies(physCalTable, calTableGen, dataSourceContainer, importContext.getDeployLocale()));
        }
        importContext.setDecorationOnlyAnalysis(false);
        importContext.addPostAnalysisProcessor(new RebuildModelIndexes());
    }

    private void deploy(IQueryLogicalStorage qls, ILocalTabularStorage storage, TabularDataset[] datasets) throws ImportException {
        try {
            for (TabularDataset ds : datasets) {
                if (mLogger.isDebugEnabled()) {
                    String msg = String.format("Deploying dataset: %s %s", ds.getDatasetName(), ds.getDatasetType());
                    mLogger.debug(msg, this.getClass().getName() + "::deploy()");
                }
                this.deploy(qls, storage, ds);
            }
        }
        catch (ImportException ex) {
            mLogger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::deploy()");
            throw ex;
        }
        catch (Exception ex) {
            mLogger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::deploy()");
            throw new ImportException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploy(IQueryLogicalStorage qls, ILocalTabularStorage storage, TabularDataset ds) throws Exception {
        ITable table = this.createTableForDataset(storage, ds);
        IBatchRowInsert batchInsert = storage.prepareBatchInsert(table.getName());
        batchInsert.begin();
        try {
            TabularDatasetReader reader = ds.openReader();
            try {
                IValue[] outputRow = new IValue[ds.numColumns()];
                for (int i = 0; i < outputRow.length; ++i) {
                    outputRow[i] = ds.getColumn(i).getDataType().newValue();
                }
                while (reader.hasNext()) {
                    IValue[] nextRow = reader.readNextRow();
                    for (int i = 0; i < nextRow.length; ++i) {
                        outputRow[i].assignFrom(nextRow[i]);
                    }
                    batchInsert.addRow(outputRow);
                }
            }
            finally {
                reader.close();
            }
        }
        finally {
            batchInsert.finish();
        }
    }

    private ITable createTableForDataset(ILocalTabularStorage storage, TabularDataset ds) throws Exception {
        ITableDescriptor tableDesc = storage.describeTable(ds.getDatasetName());
        if (mLogger.isDebugEnabled()) {
            String msg = String.format("Defining table with name '%s' and identifier '%s'", ds.getDatasetName(), tableDesc.getIdentifier());
            mLogger.debug(msg, this.getClass().getName() + "::createTableForDataset()");
        }
        for (TabularDataset.ColumnInfo info : ds.getColumns()) {
            String name = info.getName();
            IDataType type = info.getDataType();
            EnumSet<ColumnConstraint> colConstraints = EnumSet.noneOf(ColumnConstraint.class);
            if (info.getNullCount() > 0L) {
                colConstraints.add(ColumnConstraint.NULL);
            } else {
                colConstraints.add(ColumnConstraint.NOT_NULL);
            }
            IColumnDescriptor colDesc = tableDesc.addColumn(name, ColumnType.fromDataType((IDataType)type), colConstraints, null, false, false, null);
            if (!mLogger.isDebugEnabled()) continue;
            String msg = String.format("Adding column with name '%s', identifier '%s' and type '%s'", colDesc.getName(), colDesc.getIdentifier(), colDesc.getType());
            mLogger.debug(msg, this.getClass().getName() + "::createTableForDataset()");
        }
        return storage.createTable(tableDesc);
    }
}

