/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.importer.importspec;

import com.ibm.cognos.aurora.api.importer.IImportPackage;
import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.importer.importspec.IImportSpecification;
import com.ibm.cognos.aurora.api.importer.importspec.action.IAnalyzeDataAction;
import com.ibm.cognos.aurora.api.importer.importspec.action.IImportAction;
import com.ibm.cognos.aurora.api.importer.importspec.action.IImportDocumentAction;
import com.ibm.cognos.aurora.api.importer.importspec.action.IImportOlapDataSourceAction;
import com.ibm.cognos.aurora.api.importer.importspec.action.IImportRelDataSourceAction;
import com.ibm.cognos.aurora.api.importer.importspec.action.INewModelAction;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.importer.ImportContext;
import com.ibm.cognos.aurora.importer.ImportPackage;
import com.ibm.cognos.aurora.importer.ImporterImpl;
import com.ibm.cognos.aurora.importer.importspec.action.AnalyzeDataAction;
import com.ibm.cognos.aurora.importer.importspec.action.ImportAction;
import com.ibm.cognos.aurora.importer.importspec.action.ImportDocumentAction;
import com.ibm.cognos.aurora.importer.importspec.action.ImportOlapDataSourceAction;
import com.ibm.cognos.aurora.importer.importspec.action.NewModelAction;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class ImportSpecification
implements IImportSpecification {
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_import");
    private final ImporterImpl mImporter;
    private String mPackageName;
    private boolean mReplaceOnConflict;
    private final List<IImportAction> mActions = new ArrayList<IImportAction>();

    public ImportSpecification(ImporterImpl importer) {
        this.mImporter = importer;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public void setPackageName(String name) {
        this.mPackageName = name;
    }

    public boolean getReplaceOnConflict() {
        return this.mReplaceOnConflict;
    }

    public void setReplaceOnConflict(boolean replaceOnConflict) {
        this.mReplaceOnConflict = replaceOnConflict;
    }

    public List<IImportAction> getActions() {
        return this.mActions;
    }

    public INewModelAction addNewModelAction() {
        NewModelAction action = new NewModelAction(this.mImporter);
        this.mActions.add(action);
        return action;
    }

    public IImportOlapDataSourceAction addImportDimDataSourceAction() {
        ImportOlapDataSourceAction action = new ImportOlapDataSourceAction(this.mImporter);
        this.mActions.add(action);
        return action;
    }

    public IImportRelDataSourceAction addImportRelDataSourceAction() {
        throw new UnsupportedOperationException();
    }

    public IImportDocumentAction addImportDocumentAction() {
        ImportDocumentAction action = new ImportDocumentAction(this.mImporter);
        this.mActions.add(action);
        return action;
    }

    public IAnalyzeDataAction addAnalyzeDataAction() {
        AnalyzeDataAction action = new AnalyzeDataAction(this.mImporter);
        this.mActions.add(action);
        return action;
    }

    public IImportPackage run() {
        if (null == this.mPackageName) {
            throw new ImportException("Package name was null.");
        }
        if (this.mActions.isEmpty()) {
            throw new ImportException("No actions were defined.");
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Running import specification for package '%s'", this.mPackageName), this.getClass().getName() + "::run()");
        }
        if (this.mImporter.containsPackage(this.mPackageName)) {
            if (this.mReplaceOnConflict) {
                if (logger.isWarnEnabled()) {
                    logger.warn(String.format("Package, '%s', already exists - destroying it", this.mPackageName), this.getClass().getName() + "::run()");
                }
                this.mImporter.destroyPackage(this.mPackageName);
            } else {
                throw new ImportException("The package name already exists: " + this.mPackageName);
            }
        }
        ImportPackage pkg = this.mImporter.createPackage(this.mPackageName);
        ImportContext importContext = new ImportContext(this.mImporter, pkg);
        importContext.setDeployLocale(this.mImporter.getDefaultLocale());
        for (IImportAction action : this.mActions) {
            ((ImportAction)action).execute(importContext);
        }
        this.mImporter.commitPackage(pkg);
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Import completed for package '%s'", this.mPackageName), this.getClass().getName() + "::run()");
        }
        return pkg;
    }

    public void encodeElement(Element elem, EncoderContext ctx) {
        elem.addAttribute("packageName", this.mPackageName);
        elem.addAttribute("replaceOnConflict", Boolean.toString(this.mReplaceOnConflict));
    }

    public void decodeElement(Element elem, EncoderContext ctx) {
        this.mPackageName = elem.attributeValue("packageName");
        this.mReplaceOnConflict = Boolean.parseBoolean(elem.attributeValue("replaceOnConflict"));
    }
}

