/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.importer.importspec.action;

import com.ibm.cognos.aurora.api.importer.IImporter;
import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.importer.importspec.EDocumentType;
import com.ibm.cognos.aurora.api.importer.importspec.action.IImportDocumentAction;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.storage.data.ILocalDataStorage;
import com.ibm.cognos.aurora.core.extract.ExtractionContext;
import com.ibm.cognos.aurora.core.extract.TabularDataset;
import com.ibm.cognos.aurora.core.extract.TabularExtracter;
import com.ibm.cognos.aurora.core.extract.TabularExtracterFactory;
import com.ibm.cognos.aurora.core.io.TempFile;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.importer.ImportContext;
import com.ibm.cognos.aurora.importer.ImportPackage;
import com.ibm.cognos.aurora.importer.deploy.LocalPMTAStorageDeployer;
import com.ibm.cognos.aurora.importer.deploy.LocalTabularStorageDeployer;
import com.ibm.cognos.aurora.importer.importspec.action.ImportDatasetAction;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

@Deprecated
public class ImportDocumentAction
extends ImportDatasetAction
implements IImportDocumentAction {
    private ULocale mDeployLocale;
    private EDocumentType mDocumentType;
    private String mDocumentFilename;
    private InputStream mDocumentStream;
    private String mDataSourceName;
    private static final ILogger mLogger = LoggerManager.getLogger((String)"ATHENA.core.qls_import");

    public ImportDocumentAction(IImporter importer) {
        super(importer);
    }

    public ULocale getDeployLocale() {
        if (null == this.mDeployLocale) {
            return this.getDataLocale();
        }
        return this.mDeployLocale;
    }

    public void setDeployLocale(ULocale locale) {
        this.mDeployLocale = locale;
    }

    public EDocumentType getDocumentType() {
        return this.mDocumentType;
    }

    public void setDocumentType(EDocumentType type) {
        this.mDocumentType = type;
    }

    public String getDocumentFilename() {
        return this.mDocumentFilename;
    }

    public void setDocumentFilename(String documentFilename) {
        this.mDocumentFilename = documentFilename;
    }

    public InputStream getDocumentStream() {
        return this.mDocumentStream;
    }

    public void setDocumentStream(InputStream documentStream) {
        this.mDocumentStream = documentStream;
    }

    public String getDataSourceName() {
        return this.mDataSourceName;
    }

    public void setDataSourceName(String name) {
        this.mDataSourceName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ImportContext importContext) {
        boolean usePMTA;
        IImporter importer = importContext.getImporter();
        Properties cfg = importer.getConfigurationProperties();
        IQueryLogicalStorage qls = importer.getQLS();
        ImportPackage pkg = importContext.getPackage();
        IAssociativeModel model = pkg.loadModel(this.getModelName());
        if (mLogger.isInfoEnabled()) {
            mLogger.info(String.format("Importing document '%s' into model '%s' of package '%s'", this.getDocumentFilename(), this.getModelName(), pkg.getName()), this.getClass().getName() + "::execute()");
            mLogger.info(String.format("Using datalocale='%s', deployLocale=%s, zone='%s', nullTokens=%s", this.getDataLocale().toString(), this.getDeployLocale().toString(), this.getTimeZone().toString(), this.getNullTokens().toString()), this.getClass().getName() + "::execute()");
        }
        importContext.setDeployLocale(this.getDeployLocale());
        boolean bl = usePMTA = qls.isPMTABridgeAvailable() && "pmta".equals(cfg.get("aurora.importer.default_storage"));
        if (usePMTA) {
            ILocalDataStorage storage;
            if (mLogger.isInfoEnabled()) {
                mLogger.info("Using PMTA storage", this.getClass().getName() + "::execute()");
            }
            String dataSourceName = null == this.getDataSourceName() ? FilenameUtils.getBaseName((String)this.mDocumentFilename) : this.getDataSourceName();
            LocalPMTAStorageDeployer deployer = new LocalPMTAStorageDeployer();
            if (null != this.mDocumentStream) {
                File tmpFile = this.dumpInputStreamToTempFile(this.mDocumentStream, qls.getTempDirPath(), this.mDocumentFilename);
                try {
                    storage = deployer.deploy(importContext, dataSourceName, tmpFile);
                }
                finally {
                    if (!tmpFile.delete()) {
                        tmpFile.deleteOnExit();
                    }
                }
            } else {
                storage = deployer.deploy(importContext, dataSourceName, new File(this.mDocumentFilename));
            }
            deployer.initializeAssociativeModel(importContext, dataSourceName, model, storage);
        } else {
            mLogger.info("Using tabular storage", this.getClass().getName() + "::execute()");
            ExtractionContext extractionContext = this.extractDatasets(importContext);
            try {
                LocalTabularStorageDeployer deployer = new LocalTabularStorageDeployer();
                ILocalDataStorage storage = deployer.deploy(importContext, extractionContext);
                deployer.initializeAssociativeModel(importContext, extractionContext, model, storage);
            }
            finally {
                extractionContext.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtractionContext extractDatasets(ImportContext importContext) {
        IImporter importer = importContext.getImporter();
        IQueryLogicalStorage qls = importer.getQLS();
        ExtractionContext extractionContext = new ExtractionContext(importer.getTempDirPath(), this.getDataLocale(), this.getTimeZone(), this.getNullTokens());
        if (null == this.getDataSourceName()) {
            extractionContext.setDataSourceName(FilenameUtils.getName((String)this.mDocumentFilename));
        } else {
            extractionContext.setDataSourceName(this.getDataSourceName());
        }
        extractionContext.setDataSourceType("Unknown");
        extractionContext.getDataSourceProperties().put("documentPath", ValueFactory.create((Object)this.mDocumentFilename));
        try {
            block19: {
                TabularExtracter extracter;
                if (null != this.mDocumentStream) {
                    File tmpFile = this.dumpInputStreamToTempFile(this.mDocumentStream, qls.getTempDirPath(), this.mDocumentFilename);
                    try {
                        extracter = TabularExtracterFactory.create((String)this.mDocumentFilename, (File)tmpFile, (EDocumentType)this.mDocumentType);
                        try {
                            extracter.extractDatasets(extractionContext);
                            break block19;
                        }
                        finally {
                            extracter.close();
                        }
                    }
                    finally {
                        if (!tmpFile.delete()) {
                            tmpFile.deleteOnExit();
                        }
                    }
                }
                extracter = TabularExtracterFactory.create((String)this.mDocumentFilename, (EDocumentType)this.mDocumentType);
                try {
                    extracter.extractDatasets(extractionContext);
                }
                finally {
                    extracter.close();
                }
            }
            this.preProcessDatasets(extractionContext);
            ArrayList<String> emptyDatasets = new ArrayList<String>();
            for (TabularDataset dataset : extractionContext.getAllDatasets()) {
                if (dataset.numColumns() != 0) continue;
                emptyDatasets.add(dataset.getDatasetName());
            }
            for (String datasetName : emptyDatasets) {
                if (mLogger.isWarnEnabled()) {
                    mLogger.warn("Removing empty dataset: " + datasetName, this.getClass().getName() + "::extractDatasets()");
                }
                extractionContext.removeDataset(datasetName);
            }
            if (extractionContext.numDatasets() == 0) {
                throw new ImportException("No non-empty data sets were extracted");
            }
            return extractionContext;
        }
        catch (RuntimeException ex) {
            extractionContext.dispose();
            throw ex;
        }
    }

    private File dumpInputStreamToTempFile(InputStream in, String tempDirPath, String originalFilename) {
        File tmpFile = null;
        FileOutputStream fos = null;
        try {
            int len;
            tmpFile = TempFile.createTempFile((File)new File(tempDirPath), (String)FilenameUtils.getBaseName((String)originalFilename), (String)FilenameUtils.getExtension((String)originalFilename));
            fos = new FileOutputStream(tmpFile);
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
            File file = tmpFile;
            return file;
        }
        catch (IOException ex) {
            mLogger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::dumpInputStreamToTempFile()");
            if (null != tmpFile && !tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
            throw new ImportException((Throwable)ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                mLogger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::dumpInputStreamToTempFile()");
            }
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    mLogger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::dumpInputStreamToTempFile()");
                }
            }
        }
    }
}

