/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.Base64;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SimpleValueSerializer;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class Base64Serializer
implements SimpleValueSerializer {
    public static final String ATTRIBUTE = "[attribute]";
    private static final String ATTRIBUTE_NAME = "href";
    public QName xmlType;
    public Class javaType;

    public Base64Serializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        String data = this.getPlainString(value);
        boolean isAttribute = false;
        AttributesImpl attr = new AttributesImpl();
        if (attributes != null) {
            attr.setAttributes(attributes);
        }
        if (null != data && data.startsWith(ATTRIBUTE)) {
            data = data.substring(ATTRIBUTE.length());
            attr.addAttribute("", "", ATTRIBUTE_NAME, "", data);
            isAttribute = true;
        }
        context.startElement(name, attr);
        if (!isAttribute) {
            context.writeString(this.getValueAsString(value, context));
        }
        context.endElement();
    }

    public String getValueAsString(Object value, SerializationContext context) {
        byte[] data = null;
        if (this.javaType == byte[].class) {
            data = (byte[])value;
        } else {
            data = new byte[((Byte[])value).length];
            for (int i = 0; i < data.length; ++i) {
                Byte b = ((Byte[])value)[i];
                if (b == null) continue;
                data[i] = b;
            }
        }
        return Base64.encode(data, 0, data.length);
    }

    private String getPlainString(Object value) {
        byte[] data = null;
        if (this.javaType == byte[].class) {
            data = (byte[])value;
        } else {
            data = new byte[((Byte[])value).length];
            for (int i = 0; i < data.length; ++i) {
                Byte b = ((Byte[])value)[i];
                if (b == null) continue;
                data[i] = b;
            }
        }
        return new String(data);
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        return null;
    }
}

