/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bds.handler;

import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.bds.handler.HandlerConfig;
import com.ibm.cognos.bds.handler.HandlerConfigFactory;
import com.ibm.cognos.bds.handler.HandlerSession;
import com.ibm.cognos.bds.handler.HandlerSessionFactory;

public class BurstHandler
extends BasicHandler {
    private static final String HANDLE_REQUEST_WARNING = "Exception caught while handling burst request";
    private static final String UPDATE_CONFIG_WARNING = "Exception caught while attempting to update the handler configuration: ";
    private static final PogoLogger staticLogger = PogoLogger.getLogger();
    private final PogoLogger log;
    private final HandlerSessionFactory handlerSessionFactory;
    private HandlerConfig handlerConfig;

    public BurstHandler() {
        this(new HandlerSessionFactory(), new HandlerConfigFactory(), staticLogger);
    }

    public BurstHandler(HandlerSessionFactory handlerSessionFactory, HandlerConfigFactory handlerConfigFactory, PogoLogger log) {
        super(log.getNativeLogger());
        this.handlerSessionFactory = handlerSessionFactory;
        this.handlerConfig = handlerConfigFactory.createHandlerConfig(log);
        this.log = log;
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        try {
            this.handleRequest(mc);
        }
        catch (Exception e) {
            this.log.warn(HANDLE_REQUEST_WARNING, (Throwable)e);
            throw new PogoException(HANDLE_REQUEST_WARNING, e);
        }
    }

    private void handleRequest(MessageContext mc) throws Exception {
        HandlerSession session = this.handlerSessionFactory.createHandlerSession(mc, this.handlerConfig);
        session.handleRequest(mc);
    }

    public void configure(Configuration config) {
        this.log.debug(new Object[]{"configuring"});
        this.updateConfiguration(config);
    }

    public void reconfigure(Configuration config) {
        this.log.debug(new Object[]{"reconfiguring"});
        this.updateConfiguration(config);
    }

    private void updateConfiguration(Configuration config) {
        try {
            this.handlerConfig.update(config);
        }
        catch (Exception e) {
            this.log.warn(UPDATE_CONFIG_WARNING, (Throwable)e);
        }
    }
}

