/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bds.handler;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.bds.handler.BurstSplitter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BurstKeysParser
implements Iterator<String> {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final char SEPARATOR = ',';
    private static final char ESCAPE = '\\';
    private final String[] splitKeys;
    private final int nrOfKeys;
    private long keysPerChunk;
    private int nextKey;

    public BurstKeysParser(String burstKeys) {
        this.splitKeys = this.splitCommaSeparatedKeys(burstKeys);
        this.nrOfKeys = Integer.valueOf(this.splitKeys[0]);
    }

    public BurstKeysParser(String burstKeys, BurstSplitter burstSplitter, int burstMaxKeys) {
        this(burstKeys);
        int nrOfChunks = burstSplitter.getNrOfChunks(this.nrOfKeys, burstMaxKeys);
        this.setNrOfChunks(nrOfChunks);
    }

    public void setNrOfChunks(int nrOfChunks) {
        this.keysPerChunk = Math.round(1.0 * (double)this.nrOfKeys / (double)nrOfChunks);
        this.nextKey = 1;
        log.debug(new Object[]{"nrOfChunks: ", nrOfChunks, ", keysPerChunk: ", this.keysPerChunk});
    }

    public int getNrOfKeys() {
        return this.nrOfKeys;
    }

    @Override
    public boolean hasNext() {
        return this.nextKey <= this.nrOfKeys;
    }

    @Override
    public String next() {
        long keyCount = this.keysPerChunk;
        StringBuilder sb = new StringBuilder();
        while (this.needsMoreKeys(keyCount)) {
            this.addKey(sb, --keyCount);
        }
        return sb.toString();
    }

    private boolean needsMoreKeys(long keyCount) {
        return this.hasNext() && keyCount > 0L;
    }

    private void addKey(StringBuilder sb, long keyCount) {
        sb.append(this.splitKeys[this.nextKey++]);
        if (this.needsMoreKeys(keyCount)) {
            sb.append(',');
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private String[] splitCommaSeparatedKeys(String burstKeys) {
        ArrayList<String> keys = new ArrayList<String>();
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < burstKeys.length(); ++i) {
            char ch = burstKeys.charAt(i);
            if (ch == ',') {
                keys.add(key.toString());
                key.setLength(0);
                continue;
            }
            if (ch == '\\') {
                key.append(ch);
                if (++i >= burstKeys.length()) continue;
                key.append(burstKeys.charAt(i));
                continue;
            }
            key.append(ch);
        }
        keys.add(key.toString());
        return this.toArray(keys);
    }

    private String[] toArray(List<String> keys) {
        String[] array = new String[keys.size()];
        keys.toArray(array);
        return array;
    }
}

