/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bds.handler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.pdk.common.Tracking;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.bds.handler.BurstKeysParser;
import com.ibm.cognos.bds.handler.BurstSplitter;
import com.ibm.cognos.bds.handler.HandlerConfig;
import com.ibm.cognos.bds.handler.HandlerSession;
import com.ibm.cognos.bds.handler.JsmTaskManager;
import com.ibm.cognos.bds.handler.TaskManager;
import com.ibm.cognos.bds.utils.Dom4jUtils;
import com.ibm.cognos.internal.ombridge.BridgeHandler;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class BurstSession
implements HandlerSession {
    private static String SOAP_VERSION = "999999";
    private static final String MONITOR_SERVICE_SOAP_ACTION = "http://www.ibm.com/xmlns/prod/cognos/monitorService/" + SOAP_VERSION + "/.session";
    private static final String MONITOR_SERVICE_NAMESPACE_URI = "http://developer.cognos.com/schemas/monitorService/1";
    private static final String PROPAGATE_ERRORS_TO_PARENT_TASK = "http://developer.cognos.com/ceba/constants/burstOptionEnum#propagateErrorsToParentTask";
    private static final String DISCARD_CHILD_HISTORY_DETAILS = "http://developer.cognos.com/ceba/constants/burstOptionEnum#discardChildHistoryDetails";
    private static final String BURST_CONTEXT = "http://developer.cognos.com/ceba/constants/burstOptionEnum#burstContext";
    private static final String BURST_KEYS = "http://developer.cognos.com/ceba/constants/burstOptionEnum#burstKeys";
    private static final String BURST_MAX_KEYS = "burstKeyLimit";
    private static final String RUN_CONTEXT = "runContext";
    private static final PogoLogger log = PogoLogger.getLogger();
    private MessageContext mc;
    private Element burstContext;
    private BIBusEnvelope requestFromReportServer;
    private BurstKeysParser burstKeysParser;
    private String burstKeys;
    private int burstMaxKeys;
    private Element runOptions;
    private BurstSplitter burstSplitter;
    private TaskManager taskManager;

    public BurstSession(HandlerConfig hc) {
        this(hc, new BurstSplitter(hc));
    }

    public BurstSession(HandlerConfig hc, BurstSplitter burstSplitter) {
        this.burstSplitter = burstSplitter;
        this.taskManager = new JsmTaskManager();
    }

    @Override
    public void handleRequest(MessageContext mc) throws Exception {
        log.debug(new Object[]{"Handling burst request"});
        this.mc = mc;
        this.processRequest();
        this.prepareResponse();
    }

    private void processRequest() throws Exception {
        try {
            this.prepareRequestToJsm();
            this.sendRequestsToJsm();
        }
        catch (Exception e) {
            log.warn("Failed to handle burst request", (Throwable)e);
            throw new PogoException("Failed to handle burst request", e);
        }
    }

    private void prepareRequestToJsm() throws Exception {
        this.saveRequest();
        this.saveRunOptions();
        this.saveBurstKeys();
        this.removeConversationContext();
        this.cleanupRunContexts();
        this.addMonitorOption();
    }

    private void saveRequest() {
        this.requestFromReportServer = (BIBusEnvelope)this.mc.getProperty("request.envelope");
    }

    private void saveRunOptions() {
        Element bodyElement = this.requestFromReportServer.getBody();
        Element run = bodyElement.element("run");
        Dom4jUtils.changeNamespaceURI(run, run.getNamespace(), MONITOR_SERVICE_NAMESPACE_URI);
        this.runOptions = run.element("options");
    }

    private void saveBurstKeys() throws DocumentException {
        this.scanBurstElements();
        this.checkIfBurstKeysAreMissing();
        this.burstKeysParser = new BurstKeysParser(this.burstKeys, this.burstSplitter, this.burstMaxKeys);
    }

    private void scanBurstElements() throws DocumentException {
        for (Element option : this.getOptions(this.runOptions)) {
            this.scanBurstElement(option);
        }
    }

    private List<Element> getOptions(Element runOptions) {
        return runOptions.elements();
    }

    private void scanBurstElement(Element option) throws DocumentException {
        String name = option.elementText("name");
        if (BURST_KEYS.equals(name)) {
            this.saveBurstKeys(option, this.runOptions);
        } else if (BURST_CONTEXT.equals(name)) {
            this.saveBurstContext(option);
        } else if (BURST_MAX_KEYS.equals(name)) {
            this.saveBurstMaxKeys(option, this.runOptions);
        }
    }

    private void saveBurstKeys(Element burstKeysOption, Element runOptions) {
        this.burstKeys = this.removeRunOption(burstKeysOption, runOptions, "Burst keys");
    }

    private void saveBurstContext(Element option) throws DocumentException {
        String burstContextXml = option.elementText("value");
        this.burstContext = DocumentHelper.parseText((String)burstContextXml).getRootElement();
        log.debug(new Object[]{"Burst context found: ", burstContextXml});
    }

    private void saveBurstMaxKeys(Element burstMaxKeysOption, Element runOptions) {
        String burstMaxKeysValue = this.removeRunOption(burstMaxKeysOption, runOptions, "Burst max keys");
        try {
            this.burstMaxKeys = Integer.valueOf(burstMaxKeysValue);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid burst max key specified in report spec: " + burstMaxKeysValue, e);
        }
    }

    protected String removeRunOption(Element runOption, Element runOptions, String name) {
        String value = runOption.elementText("value");
        runOptions.remove(runOption);
        log.debug(new Object[]{name + " found: ", value});
        return value;
    }

    private void checkIfBurstKeysAreMissing() throws DocumentException {
        if (this.burstKeys == null) {
            throw new DocumentException("Request is missing burst keys");
        }
    }

    private void removeConversationContext() {
        Tracking tracking = this.requestFromReportServer.getBiBusHeader().getTracking();
        tracking.setRequestContext("");
        tracking.getConversationContext().clear();
    }

    private void cleanupRunContexts() {
        for (Element option : this.getOptions(this.runOptions)) {
            this.scanForRunContext(option);
        }
    }

    protected void scanForRunContext(Element option) {
        String name = option.elementText("name");
        if (RUN_CONTEXT.equals(name)) {
            this.removeAllButLastChildElement(option.element("value"));
        }
    }

    protected void removeAllButLastChildElement(Element parent) {
        Iterator it = parent.elementIterator();
        while (it.hasNext()) {
            Element current = (Element)it.next();
            if (!it.hasNext()) continue;
            current.detach();
        }
    }

    private void addMonitorOption() {
        QName xsiType = this.getXsiType();
        String busPrefix = this.getNamespacePrefix("http://developer.cognos.com/schemas/bibus/3/");
        String xsdPrefix = this.getNamespacePrefix("http://www.w3.org/2001/XMLSchema");
        Element item = this.addOption(xsiType, busPrefix, "monitorOptionBoolean");
        this.addName(item, xsiType, busPrefix, "monitorOptionEnum", "background");
        this.addValue(item, xsiType, xsdPrefix, "true");
        item = this.addOption(xsiType, busPrefix, "genericOptionBoolean");
        this.addName(item, xsiType, busPrefix, "string", DISCARD_CHILD_HISTORY_DETAILS);
        this.addValue(item, xsiType, xsdPrefix, "true");
        item = this.addOption(xsiType, busPrefix, "genericOptionBoolean");
        this.addName(item, xsiType, busPrefix, "string", PROPAGATE_ERRORS_TO_PARENT_TASK);
        this.addValue(item, xsiType, xsdPrefix, "true");
    }

    private QName getXsiType() {
        Namespace xsiNamespace = this.runOptions.getNamespaceForURI("http://www.w3.org/2001/XMLSchema-instance");
        return new QName("type", xsiNamespace);
    }

    private String getNamespacePrefix(String uri) {
        Namespace busNamespace = this.runOptions.getNamespaceForURI(uri);
        return busNamespace.getPrefix();
    }

    private Element addOption(QName xsiType, String busPrefix, String optionType) {
        Element item = this.runOptions.addElement("item");
        item.addAttribute(xsiType, busPrefix + ":" + optionType);
        return item;
    }

    private void addName(Element item, QName xsiType, String busPrefix, String nameType, String nameText) {
        Element name = item.addElement("name");
        name.addAttribute(xsiType, busPrefix + ":" + nameType);
        name.setText(nameText);
    }

    private void addValue(Element item, QName xsiType, String xsdPrefix, String valueText) {
        Element value = item.addElement("value");
        value.addAttribute(xsiType, xsdPrefix + ":boolean");
        value.setText(valueText);
    }

    private void sendRequestsToJsm() throws Exception {
        while (this.burstKeysParser.hasNext()) {
            this.sendNextRequestToJsm();
        }
    }

    private void sendNextRequestToJsm() throws Exception {
        BIBusEnvelope burstRequest = this.createRequestToJsm();
        this.taskManager.addTask(this.mc, burstRequest, MONITOR_SERVICE_SOAP_ACTION);
    }

    private BIBusEnvelope createRequestToJsm() throws Exception {
        BIBusEnvelope requestToJsm = new BIBusEnvelope(null, this.createBodyElement());
        this.requestFromReportServer.copyBiBusHeaderTo((Envelope)requestToJsm);
        return requestToJsm;
    }

    private Element createBodyElement() throws DocumentException {
        Element newBodyElement = this.requestFromReportServer.getBody().createCopy();
        Element newRunOptions = newBodyElement.element("run").element("options");
        this.findAndUpdateBurstContext(newRunOptions);
        return newBodyElement;
    }

    private void findAndUpdateBurstContext(Element newRunOptions) throws DocumentException {
        Element newBurstContextElement = this.findBurstContextElement(newRunOptions);
        this.updateBurstContext(newBurstContextElement);
        this.logBurstContext(newBurstContextElement);
    }

    private Element findBurstContextElement(Element runOptions) throws DocumentException {
        for (Element option : this.getOptions(runOptions)) {
            if (!BURST_CONTEXT.equals(option.elementText("name"))) continue;
            return option;
        }
        throw new DocumentException("Request is missing burst context");
    }

    private void updateBurstContext(Element burstContextElement) {
        String burstContextXML = this.getNextBurstContext();
        burstContextElement.element("value").setText(burstContextXML);
    }

    private String getNextBurstContext() {
        this.burstContext.element("burstKeys").setText(this.burstKeysParser.next());
        return this.burstContext.asXML();
    }

    private void logBurstContext(Element burstContextElement) {
        if (log.isDebugEnabled()) {
            log.debug(new Object[]{"Burst context sent: ", burstContextElement.asXML()});
        }
    }

    private void prepareResponse() {
        this.taskManager.prepareResponse("response", this.mc);
    }

    static {
        try {
            List supportedVersions = BridgeHandler.getSupportedVersions();
            SOAP_VERSION = (String)supportedVersions.get(0);
        }
        catch (Error error) {
            // empty catch block
        }
    }
}

