/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bds.handler;

import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.util.PogoLogger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class DispatcherMBeanServer {
    private static final PogoLogger staticLog = PogoLogger.getLogger();
    private final PogoLogger log;
    private final PogoMBeanServer pogoMBeanServer;

    public DispatcherMBeanServer() {
        this(PogoMBeanServer.getInstance(), staticLog);
    }

    public DispatcherMBeanServer(PogoMBeanServer pogoMBeanServer, PogoLogger log) {
        this.pogoMBeanServer = pogoMBeanServer;
        this.log = log;
    }

    public int tryGetNumberOfConfiguredProcesses() throws Exception {
        Attribute attributeValue = this.getNumberOfConfiguredProcessesAttribute();
        Long numberOfProcesses = (Long)attributeValue.getValue();
        return numberOfProcesses.intValue();
    }

    private Attribute getNumberOfConfiguredProcessesAttribute() throws Exception {
        MBeanServer server = this.pogoMBeanServer.getProxyMBeanServer();
        return this.getAttribute(server, "type=Metrics,group=System,service=batchReportService", "NumberOfConfiguredProcesses");
    }

    private Attribute getAttribute(MBeanServer server, String keyProperties, String attributeName) throws Exception {
        AttributeList attributes = this.getAttributes(server, keyProperties, attributeName);
        if (attributes == null) {
            throw new InstanceNotFoundException();
        }
        return (Attribute)attributes.get(0);
    }

    protected AttributeList getAttributes(MBeanServer server, String properties, String name) throws Exception {
        ObjectName objectName = MBeanUtils.createObjectNameInstance((String)properties);
        String[] names = new String[]{name};
        this.log.debug(new Object[]{"Object name: ", objectName, ", attributeNames: ", names});
        return server.getAttributes(objectName, names);
    }
}

