/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bds.handler;

import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.timer.PogoTimer;
import com.cognos.pogo.util.timer.PogoTimerOwner;
import com.ibm.cognos.bds.handler.BurstFactor;
import com.ibm.cognos.bds.handler.DispatcherMBeanServer;
import com.ibm.cognos.bds.handler.MaxKeysPerChunk;
import com.ibm.cognos.bds.handler.NrOfChunks;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.InstanceNotFoundException;

public class HandlerConfig
implements PogoTimerOwner {
    public static final int NO_MAX_KEYS = 0;
    private static final int DEFAULT_NUMBER_OF_CONFIGURED_PROCESSES = 8;
    private static final long MBEAN_REFRESH_AFTER_RECONFIG_IN_MILLIS = 120000L;
    private final PogoLogger log;
    private BurstFactor burstFactorConfig = new BurstFactor();
    private NrOfChunks nrOfChunksConfig = new NrOfChunks();
    private MaxKeysPerChunk maxKeysPerChunkConfig = new MaxKeysPerChunk();
    private final AtomicInteger numberOfConfiguredProcesses = new AtomicInteger(8);
    private final DispatcherMBeanServer dispatcherMBeanServer;
    private PogoTimer pogoTimer;

    public HandlerConfig(PogoLogger log) {
        this(log, new DispatcherMBeanServer());
    }

    public HandlerConfig(PogoLogger log, DispatcherMBeanServer dispatcherMBeanServer) {
        this.log = log;
        this.dispatcherMBeanServer = dispatcherMBeanServer;
    }

    public void update(Configuration config) {
        this.updateNumberOfConfiguredProcesses();
        this.burstFactorConfig.updateConfiguration(config);
        this.nrOfChunksConfig.updateConfiguration(config);
        this.maxKeysPerChunkConfig.updateConfiguration(config);
        this.startMBeanRefreshTimer();
        this.logConfig();
    }

    private void updateNumberOfConfiguredProcesses() {
        try {
            this.numberOfConfiguredProcesses.set(this.dispatcherMBeanServer.tryGetNumberOfConfiguredProcesses());
        }
        catch (InstanceNotFoundException e) {
            this.log.debug("Current number of configured processes for batch reports not available. Using previous value=" + this.numberOfConfiguredProcesses, (Throwable)e);
        }
        catch (Exception e) {
            this.log.warn("Can't get current number of configured processes for batch reports. Using previous value=" + this.numberOfConfiguredProcesses, (Throwable)e);
        }
    }

    protected void startMBeanRefreshTimer() {
        if (this.pogoTimer != null) {
            this.pogoTimer.cancel();
        }
        this.pogoTimer = new PogoTimer((PogoTimerOwner)this, null, 120000L);
    }

    public void handleTimeoutEvent(Object parameter) throws Exception {
        this.log.debug(new Object[]{"Refreshing number of configured processes"});
        this.updateNumberOfConfiguredProcesses();
        this.logConfig();
    }

    public int calculateNrOfChunks(int nrOfKeys, int maxKeysPerChunk) {
        if (this.isNrOfChunksConfigured()) {
            return this.getNrOfChunksConfigured();
        }
        if (this.isMaxKeysPerChunkSpecified(maxKeysPerChunk)) {
            return this.calculateNrOfChunksLimitedByMaxKeys(nrOfKeys, maxKeysPerChunk);
        }
        return this.calculateDefaultNrOfChunks();
    }

    public boolean isNrOfChunksConfigured() {
        return this.nrOfChunksConfig.isSet();
    }

    public int getNrOfChunksConfigured() {
        return this.nrOfChunksConfig.getValue();
    }

    private boolean isMaxKeysPerChunkSpecified(int maxKeysPerChunk) {
        return this.isValid(maxKeysPerChunk) || this.maxKeysPerChunkConfig.isSet();
    }

    protected boolean isValid(int maxKeysPerChunk) {
        return maxKeysPerChunk > 0;
    }

    private int calculateNrOfChunksLimitedByMaxKeys(int nrOfKeys, int maxKeysPerChunk) {
        int nrOfChunks = this.calculateDefaultNrOfChunks();
        if (this.resultsInMoreKeysThanMaxKeys(nrOfKeys, nrOfChunks, maxKeysPerChunk)) {
            nrOfChunks = this.recalculateNrOfChunks(nrOfKeys, maxKeysPerChunk);
        }
        return nrOfChunks;
    }

    private int calculateDefaultNrOfChunks() {
        return (int)((double)this.getNumberOfConfiguredProcesses() * this.getBurstFactor());
    }

    public int getNumberOfConfiguredProcesses() {
        return this.numberOfConfiguredProcesses.get();
    }

    public double getBurstFactor() {
        return this.burstFactorConfig.getValue();
    }

    private boolean resultsInMoreKeysThanMaxKeys(int nrOfKeys, int nrOfChunks, int maxKeysPerChunk) {
        return nrOfKeys / nrOfChunks > this.validateMaxKeysPerChunk(maxKeysPerChunk);
    }

    private int validateMaxKeysPerChunk(int maxKeysPerChunk) {
        return this.isValid(maxKeysPerChunk) ? maxKeysPerChunk : this.maxKeysPerChunkConfig.getValue();
    }

    private int recalculateNrOfChunks(int nrOfKeys, int maxKeysPerChunk) {
        return (int)Math.ceil((double)nrOfKeys / (double)this.validateMaxKeysPerChunk(maxKeysPerChunk));
    }

    private void logConfig() {
        this.log.info(new Object[]{"numberOfConfiguredProcesses: ", this.getNumberOfConfiguredProcesses()});
        this.log.info(new Object[]{"burstFactor: ", this.getBurstFactor()});
        this.log.info(new Object[]{"nrOfChunks: ", this.getNrOfChunksConfigured()});
        this.log.info(new Object[]{"maxKeysPerChunk: ", this.validateMaxKeysPerChunk(0)});
    }

    public static int getDefaultNumberOfConfiguredProcesses() {
        return 8;
    }
}

