/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bds.handler;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRunSpec;
import com.cognos.jsmcommon.tse.run.commands.CmdSpec;
import com.cognos.jsmcommon.tse.run.commands.LogJobCmdSpec;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.pdk.dom4j.Dom4jEnvelope;
import com.cognos.pogo.pdk.dom4j.Dom4jEnvelopeFactory;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.bds.handler.JsmCommon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class JsmAPI {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String STATUS_CODE_ERROR = "500";
    private static final String STATUS_STRING_ERROR = "Internal Server Error";
    private static final String STATUS_CODE_SUCCESS = "200";
    private static final String STATUS_STRING_SUCCESS = "OK";
    private final JsmCommon jsmCommon;
    private TaskID parentID;
    private final List<SequenceSpec> sequenceSpecs = new ArrayList<SequenceSpec>();
    private List<Option> options;
    private List<ParameterValue> parameters;
    private TaskPersistLayer.TaskRecords[] taskRecords;
    private BiBusHeader axisBiBusHeader;
    private String objectPath;
    private BIBusEnvelope originalRequest;

    public JsmAPI() {
        this(new JsmCommon());
    }

    public JsmAPI(JsmCommon jsmCommon) {
        this.jsmCommon = jsmCommon;
    }

    public void appendSequenceSpec(BIBusEnvelope request) {
        this.saveRequest(request);
        this.retrieveBody(request);
        BiBusRunSpec runSpec = this.createTaskRunSpec();
        this.addTaskRunSpec(runSpec);
    }

    private void saveRequest(BIBusEnvelope request) {
        if (this.originalRequest == null) {
            this.originalRequest = request;
            this.axisBiBusHeader = this.jsmCommon.retrieveHeader(request);
        }
    }

    protected void retrieveBody(BIBusEnvelope request) {
        Element runElement = request.getBody().element("run");
        this.extractObjectPath(runElement);
        this.extractParameterValues(runElement);
        this.extractRunOptions(runElement);
    }

    protected BiBusRunSpec createTaskRunSpec() {
        BiBusRunSpec runSpec = new BiBusRunSpec(this.axisBiBusHeader);
        runSpec.searchPath = this.objectPath;
        runSpec.parameters = this.getParameterValues();
        runSpec.runCommands = this.createStepLogger();
        runSpec.header = this.axisBiBusHeader;
        runSpec.options = this.getOptions();
        return runSpec;
    }

    private ParameterValue[] getParameterValues() {
        if (this.parameters.isEmpty()) {
            return null;
        }
        ParameterValue[] parameterValues = new ParameterValue[this.parameters.size()];
        this.parameters.toArray(parameterValues);
        return parameterValues;
    }

    protected Option[] getOptions() {
        Option[] optionArray = new Option[this.options.size()];
        this.options.toArray(optionArray);
        return optionArray;
    }

    protected void addTaskRunSpec(BiBusRunSpec taskRunSpec) {
        SequenceSpec spec = new SequenceSpec(SequenceSpec.SEQ_SAME, (TaskRunSpec)taskRunSpec);
        this.sequenceSpecs.add(spec);
    }

    protected CmdSpec[] createStepLogger() {
        return new CmdSpec[]{new LogJobCmdSpec()};
    }

    private void extractObjectPath(Element runElement) {
        this.objectPath = runElement.elementText("objectPath");
    }

    private void extractParameterValues(Element runElement) {
        this.parameters = new ArrayList<ParameterValue>();
        Element parameterValues = runElement.element("parameterValues");
        this.logExtraction("parameter values", parameterValues);
        this.convertParameterValuesToAxis(parameterValues);
    }

    protected void logExtraction(String name, Element element) {
        if (log.isDebugEnabled()) {
            log.debug(new Object[]{"Extracting ", name, ": ", element.asXML()});
        }
    }

    private void convertParameterValuesToAxis(Element parameterValues) {
        for (ParameterValue pv : this.toAxisParameterValues(parameterValues)) {
            this.saveParameterValue(pv);
        }
    }

    protected ParameterValue[] toAxisParameterValues(Element parameterValues) {
        try {
            return (ParameterValue[])this.jsmCommon.deserialize(parameterValues);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize parameter values", e);
        }
    }

    protected void saveParameterValue(ParameterValue pv) {
        log.debug(new Object[]{"Parameter value converted to axis/sdk format: ", pv});
        this.parameters.add(pv);
    }

    protected void extractRunOptions(Element runElement) {
        this.options = new ArrayList<Option>();
        Element runOptions = runElement.element("options");
        this.logExtraction("run options", runOptions);
        this.convertOptionsToAxis(runOptions);
        this.searchForRunContext(runOptions);
    }

    private void convertOptionsToAxis(Element runOptions) {
        for (Option runOption : this.toAxisArray(runOptions)) {
            this.saveRunOption(runOption);
        }
    }

    protected Option[] toAxisArray(Element runOptions) {
        try {
            return (Option[])this.jsmCommon.deserialize(runOptions);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize run options", e);
        }
    }

    protected void saveRunOption(Option runOption) {
        log.debug(new Object[]{"Run option converted to axis/sdk format: ", runOption});
        this.options.add(runOption);
    }

    protected void searchForRunContext(Element runOptions) {
        for (Element option : this.getOptions(runOptions)) {
            this.saveFirstRunContext(option);
        }
    }

    private List<Element> getOptions(Element runOptions) {
        return runOptions.elements();
    }

    private void saveFirstRunContext(Element option) {
        if (this.isRunContext(option)) {
            this.parentID = new TaskID(this.getFirstRunContext(option));
        }
    }

    protected boolean isRunContext(Element option) {
        return "runContext".equals(option.elementText("name"));
    }

    protected String getFirstRunContext(Element option) {
        Iterator items = option.element("value").elementIterator();
        if (items == null || !items.hasNext()) {
            return null;
        }
        Element firstItem = (Element)items.next();
        return firstItem.getText();
    }

    public void addTask() {
        try {
            this.taskRecords = this.jsmCommon.addTasksAndReturnAll(this.parentID, this.getSequenceSpecs(), true, false);
        }
        catch (TaskPersistLayerException e) {
            throw new RuntimeException("Failed to add Monitor Service task", e);
        }
    }

    protected SequenceSpec[] getSequenceSpecs() {
        SequenceSpec[] sequenceSpecArray = new SequenceSpec[this.sequenceSpecs.size()];
        this.sequenceSpecs.toArray(sequenceSpecArray);
        return sequenceSpecArray;
    }

    public BIBusEnvelope createResponseEnvelope() {
        Dom4jEnvelope response = Dom4jEnvelopeFactory.createDom4jEnvelope();
        this.originalRequest.copyBiBusHeaderTo((Envelope)response);
        this.createResponseBody(response.getBody());
        return response;
    }

    private void createResponseBody(Element body) {
        String xsi = SOAPEnvelope.XSI_TYPE.getNamespacePrefix();
        this.addNamespace(xsi, body);
        this.addRunResponse(xsi, body);
    }

    protected void addNamespace(String xsi, Element body) {
        body.addNamespace(xsi, SOAPEnvelope.XSI_TYPE.getNamespaceURI());
    }

    protected void addRunResponse(String xsi, Element body) {
        Element runResponse = body.addElement("rns1:runResponse", "http://developer.cognos.com/schemas/dispatcher/1");
        this.addResult(xsi, runResponse);
    }

    protected void addResult(String xsi, Element runResponse) {
        String bus = BIBusEnvelope.NS_BUS.getPrefix();
        Element result = runResponse.addElement("result");
        result.addAttribute(xsi + ":type", bus + ":asynchReply");
        this.addStatus(bus, xsi, result);
    }

    protected void addStatus(String bus, String xsi, Element result) {
        Element status = result.addElement("status");
        status.addAttribute(xsi + ":type", bus + ":asynchReplyStatusEnum");
        status.setText("conversationComplete");
    }

    public String getStatusCode() {
        return this.taskRecords != null ? STATUS_CODE_SUCCESS : STATUS_CODE_ERROR;
    }

    public String getStatusString() {
        return this.taskRecords != null ? STATUS_STRING_SUCCESS : STATUS_STRING_ERROR;
    }
}

