/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bds.utils;

import java.util.ListIterator;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.VisitorSupport;

public class NamespaceChanger
extends VisitorSupport {
    private String oldURI;
    private Namespace newNamespace;

    public NamespaceChanger(Namespace namespace, String newURI) {
        this.oldURI = namespace.getURI();
        this.newNamespace = Namespace.get((String)namespace.getPrefix(), (String)newURI);
    }

    public void visit(Element node) {
        if (node.getNamespace().getURI().equals(this.oldURI)) {
            node.setQName(new QName(node.getName(), this.newNamespace));
        }
        ListIterator<Namespace> namespaces = this.getNamespaces(node);
        while (namespaces.hasNext()) {
            if (!namespaces.next().getURI().equals(this.oldURI)) continue;
            namespaces.remove();
        }
    }

    private ListIterator<Namespace> getNamespaces(Element node) {
        return node.additionalNamespaces().listIterator();
    }
}

