/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cache;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.pogo.http.mime.MIMEPartParser;
import com.cognos.pogo.util.CAMUtils;
import com.ibm.cognos.pdc.cache.internal.NonClosingOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.IOUtils;

public class CachedItem
implements Serializable {
    private static final long serialVersionUID = 5474656643466340146L;
    private ConcurrentHashMap<String, Part> parts = new ConcurrentHashMap();
    private String name = null;
    private String firstPart = null;
    private SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    private StringBuilder cacheHeaders = new StringBuilder();
    private Long estimatedSize = 0L;
    private String etag = null;
    private static CAMUtils camUtils = new CAMUtils();
    private boolean encrypt = false;

    public CachedItem(Iterator<InputStream> it, boolean encrypt) {
        this.name = "obj" + System.nanoTime();
        this.load(it);
        this.formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.encrypt = encrypt;
    }

    public CachedItem(String name, Iterator<InputStream> it, boolean encrypt) {
        this.name = name;
        this.load(it);
        this.formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.encrypt = encrypt;
    }

    private void load(Iterator<InputStream> in) {
        boolean isMHT = false;
        boolean gzipped = false;
        String encoding = null;
        try {
            while (in.hasNext()) {
                StringBuilder headers = new StringBuilder();
                InputStream inputStream = in.next();
                String partName = null;
                InternetHeaders iHeaders = new InternetHeaders(inputStream);
                Enumeration inputHeaders = iHeaders.getAllHeaders();
                while (inputHeaders.hasMoreElements()) {
                    Header header = (Header)inputHeaders.nextElement();
                    if (header.getName().equalsIgnoreCase("content-disposition")) {
                        int nameStart = header.getValue().indexOf("filename=\"") + 10;
                        if (nameStart == 9) continue;
                        String tmp = header.getValue().substring(nameStart);
                        partName = tmp.substring(0, tmp.indexOf("\""));
                        continue;
                    }
                    if (header.getName().equalsIgnoreCase("content-location")) {
                        String nm = header.getValue();
                        if (nm.startsWith("../")) {
                            nm = nm.substring(3);
                        }
                        partName = nm;
                        continue;
                    }
                    if (header.getName().equalsIgnoreCase("content-transfer-encoding")) {
                        encoding = header.getValue();
                        continue;
                    }
                    if (header.getName().equalsIgnoreCase("transfer-encoding")) continue;
                    if (header.getName().equalsIgnoreCase("etag")) {
                        this.etag = header.getValue();
                        continue;
                    }
                    if (header.getName().equalsIgnoreCase("content-type")) {
                        if (header.getValue().startsWith("message")) {
                            isMHT = true;
                        }
                    } else if (header.getName().equalsIgnoreCase("content-encoding")) {
                        gzipped = header.getValue().equalsIgnoreCase("gzip");
                    }
                    headers.append(header.getName()).append(": ").append(header.getValue()).append("\r\n");
                }
                if (!isMHT) {
                    if (this.firstPart == null) {
                        if (partName == null) {
                            partName = "main";
                        }
                        this.firstPart = partName;
                    }
                    byte[] buffer = IOUtils.toByteArray((InputStream)(encoding != null ? MimeUtility.decode((InputStream)inputStream, encoding) : inputStream));
                    this.estimatedSize = this.estimatedSize + (long)buffer.length;
                    this.parts.put(partName == null ? "obj" + System.nanoTime() : partName, new Part(headers.toString(), buffer));
                    encoding = null;
                    continue;
                }
                headers = new StringBuilder();
                if (gzipped) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                InternetHeaders moreHeaders = new InternetHeaders(inputStream);
                String[] ct = moreHeaders.getHeader("Content-Type");
                in = new MIMEPartParser(inputStream, MIMEPartParser.getBoundaryFromContentType((String)ct[0]));
                isMHT = false;
                gzipped = false;
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public InputStream getInputStream(String part, boolean withCacheHeaders) {
        Part resp = part == null || part.length() == 0 ? this.parts.get(this.getFirstPartName()) : this.parts.get(part);
        if (resp != null) {
            return resp.getResponse(withCacheHeaders);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setExpiry(long expirationTime) {
        this.cacheHeaders.append("Cache-control: private\r\n");
        this.cacheHeaders.append("Expires:").append(this.formatter.format(expirationTime)).append("\r\n");
    }

    public String getFirstPartName() {
        return this.firstPart != null ? this.firstPart : "main";
    }

    public boolean hasPart(String partName) {
        if (partName == null || partName.length() == 0) {
            return this.parts.get(this.getFirstPartName()) != null;
        }
        return this.parts.get(partName) != null;
    }

    public Long getEstimatedSize() {
        return this.estimatedSize;
    }

    public String getEtag() {
        return this.etag;
    }

    private class Part
    implements Serializable {
        private static final long serialVersionUID = -3794527512881425765L;
        private String headers = null;
        private transient byte[] buffer = null;

        public Part(String headers, byte[] buffer) {
            this.headers = headers;
            this.buffer = buffer;
        }

        public InputStream getResponse(boolean withCacheHeaders) {
            return new SequenceInputStream(new ByteArrayInputStream((this.headers + (withCacheHeaders ? CachedItem.this.cacheHeaders.toString() : "") + "\r\n").getBytes()), new ByteArrayInputStream(this.buffer));
        }

        private void writeObject(ObjectOutputStream stream) throws IOException, CAMCryptoException {
            stream.defaultWriteObject();
            if (CachedItem.this.encrypt) {
                NonClosingOutputStream ncos = new NonClosingOutputStream(stream);
                CipherOutputStream cos = camUtils.getCamFactory().createEncryptingOutputStream((OutputStream)ncos);
                ObjectOutputStream coos = new ObjectOutputStream(cos);
                coos.writeObject(this.buffer);
                coos.flush();
                coos.close();
            } else {
                stream.writeObject(this.buffer);
            }
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException, CAMCryptoException {
            stream.defaultReadObject();
            if (CachedItem.this.encrypt) {
                CipherInputStream cis = camUtils.getCamFactory().createDecryptingInputStream((InputStream)stream);
                ObjectInputStream cois = new ObjectInputStream(cis);
                this.buffer = (byte[])cois.readObject();
                cois.close();
            } else {
                this.buffer = (byte[])stream.readObject();
            }
        }
    }
}

