/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cache.handlers;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.ibm.cognos.pdc.cache.CacheManagerDelegate;
import com.ibm.cognos.pdc.cache.internal.CacheServiceConfiguration;
import com.ibm.cognos.pdc.cache.internal.CacheServiceException;
import com.ibm.cognos.pdc.cache.internal.handlers.HandlerFactory;
import com.ibm.cognos.pdc.cache.internal.handlers.ICacheHandler;
import com.ibm.cognos.pdc.cache.internal.logging.IPFLogger;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CacheDispatcherHandler
extends BasicHandler {
    public static final String EHCACHE_CONFIG_FILE = "../configuration/cache/cacheservice_ehcache.xml";
    static final Logger m_logger = Hierarchy.getDefaultHierarchy().getLoggerFor(CacheDispatcherHandler.class.getName());
    protected CacheServiceConfiguration config;
    protected HandlerFactory handlerFactory;
    protected CacheManagerDelegate cmgr;

    public CacheDispatcherHandler() {
        this(new HandlerFactory());
    }

    public CacheDispatcherHandler(HandlerFactory handlerFactory) {
        super(m_logger);
        this.handlerFactory = handlerFactory;
    }

    public void initialize() {
        super.initialize();
    }

    public void dispose() {
        super.dispose();
        if (this.cmgr != null) {
            this.cmgr.shutdown();
        }
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        IPFLogger logger = IPFLogger.getInstance();
        logger.startOverallPerf(10000, "Perf.CACHE", "Starting CACHE invokeImpl perf logger");
        HttpServletRequest request = (HttpServletRequest)mc.getProperty("http_servlet_request");
        BIBusEnvelope bus = (BIBusEnvelope)mc.getProperty("request.envelope");
        mc.setResponseName("response");
        mc.setProperty("response.envelope", (Object)bus);
        int status = 200;
        String method = request.getMethod();
        String pathInfo = request.getPathInfo();
        try {
            if (method.compareToIgnoreCase("GET") == 0) {
                this.handleGet(mc, logger, pathInfo);
            } else if (method.compareToIgnoreCase("POST") == 0) {
                this.handlePost(mc);
            }
            logger.stopOverallPerf(10000, "Perf.CACHE", "Stopping CACHE invokeImpl perf logger");
        }
        catch (Exception ex) {
            status = 500;
            mc.setProperty("response.status_code", (Object)Integer.toString(status));
            ex.printStackTrace();
        }
    }

    private void handlePost(MessageContext mc) {
        int status = 501;
        mc.setProperty("response.status_code", (Object)Integer.toString(status));
    }

    protected void handleGet(MessageContext mc, IPFLogger logger, String pathInfo) throws PogoException {
        ICacheHandler handler = this.handlerFactory.createHandler(this.cmgr, pathInfo, this.config, logger);
        if (handler != null) {
            handler.handle(mc);
        } else {
            int status = 404;
            mc.setProperty("response.status_code", (Object)Integer.toString(status));
        }
    }

    public void configure(Configuration configuration) {
        this.config = new CacheServiceConfiguration(configuration);
        this.setupCacheManager(configuration);
    }

    public void reconfigure(Configuration configuration) {
        this.config.processConfiguration(configuration);
    }

    private void setupCacheManager(Configuration configuration) {
        ICCLConfiguration config = configuration.getICCLConfiguration();
        String configFilePath = config.resolveEffectivePath(EHCACHE_CONFIG_FILE);
        net.sf.ehcache.config.Configuration cConfig = this.getEhCacheConfiguration(configFilePath);
        DiskStoreConfiguration dsConfig = new DiskStoreConfiguration();
        String dataDirectory = null;
        try {
            dataDirectory = config.getValue("data", true);
        }
        catch (CCLConfigurationException e) {
            dataDirectory = config.resolveEffectivePath("../data");
        }
        dsConfig.setPath(dataDirectory + "/ehcache");
        cConfig.addDiskStore(dsConfig);
        this.cmgr = new CacheManagerDelegate(new CacheManager(cConfig));
    }

    private net.sf.ehcache.config.Configuration getEhCacheConfiguration(String configFilePath) {
        try {
            return ConfigurationFactory.parseConfiguration((File)new File(configFilePath));
        }
        catch (CacheException e) {
            String msg = "Failed to load cache configuration file: " + configFilePath;
            m_logger.error(msg, (Throwable)e);
            throw new CacheServiceException(msg);
        }
    }

    public CacheServiceConfiguration getConfiguration() {
        return this.config;
    }

    public void test_setConfiguration(CacheServiceConfiguration otherConfig) {
        this.config = otherConfig;
    }
}

