/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cache.internal;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.pdk.Configuration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CacheServiceConfiguration {
    private Configuration config;
    private boolean encyptCacheFiles;
    private Map<String, DispatcherListElement> dispatchers;

    public CacheServiceConfiguration(Configuration config) {
        this.processConfiguration(config);
    }

    public void processConfiguration(Configuration config) {
        this.config = config;
        this.setupDispatcherList();
        this.encyptCacheFiles = Boolean.parseBoolean(config.getValue("encryptTemporaryFiles"));
    }

    private void setupDispatcherList() {
        this.dispatchers = new HashMap<String, DispatcherListElement>();
        DispatcherList dispList = (DispatcherList)this.config.getDispatcherList();
        Iterator i = dispList.getAllDispatcherListElements();
        while (i.hasNext()) {
            DispatcherListElement disp = (DispatcherListElement)i.next();
            this.dispatchers.put(disp.getGuid(), disp);
        }
    }

    public String getCMRestURL() {
        String cm = null;
        try {
            StringBuilder sb = new StringBuilder();
            cm = this.config.getICCLConfiguration().getValue("contentManager", true);
            if (cm.length() > 0) {
                sb.append(cm.substring(0, cm.indexOf("/servlet")));
                sb.append("/cm/1.0/objects");
                cm = sb.toString();
            } else {
                cm = null;
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            // empty catch block
        }
        return cm;
    }

    public boolean encryptCacheFiles() {
        return this.encyptCacheFiles;
    }

    public Map<String, DispatcherListElement> getDispatchers() {
        return this.dispatchers;
    }
}

