/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cache.internal.handlers;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.StringUtils;
import com.ibm.cognos.pdc.cache.CacheDelegate;
import com.ibm.cognos.pdc.cache.CacheManagerDelegate;
import com.ibm.cognos.pdc.cache.CachedItemFactory;
import com.ibm.cognos.pdc.cache.internal.CacheServiceConfiguration;
import com.ibm.cognos.pdc.cache.internal.handlers.ICacheHandler;
import com.ibm.cognos.pdc.cache.internal.logging.IPFLogger;
import com.ibm.cognos.pdc.core.PDCLogging;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class CacheHandler
implements ICacheHandler {
    private static CAMUtils camUtils = new CAMUtils();
    protected IPFLogger logger;
    protected String[] pathBits;
    protected CacheDelegate cache;
    protected CacheManagerDelegate cmgr;
    private String m_sBoundryValue = "";
    protected MessageContext mc;
    protected BIBusEnvelope bus;
    protected HttpServletRequest request;
    protected int status = 200;
    protected List<InputStream> attachmentList;
    protected IPFLogger.PerfData perfData;
    protected CacheServiceConfiguration config;
    protected CachedItemFactory itemFactory;

    public CacheHandler(CacheManagerDelegate cmgr2, String pathInfo, CacheServiceConfiguration config, IPFLogger logger) {
        if (cmgr2 == null || pathInfo == null || logger == null) {
            throw new IllegalArgumentException("cmgr, pathInfo and logger cannot be null");
        }
        this.cmgr = cmgr2;
        this.pathBits = pathInfo.split("/");
        this.logger = logger;
        this.config = config;
        this.itemFactory = new CachedItemFactory(config);
    }

    protected void initialize(MessageContext messageContext) {
        this.perfData = this.logger.startPerf(50000, "Perf.CACHE", "Entering " + this.getClass().getName() + " execute", "ENTER");
        this.mc = messageContext;
        this.bus = (BIBusEnvelope)this.mc.getProperty("request.envelope");
        this.request = (HttpServletRequest)this.mc.getProperty("http_servlet_request");
        this.mc.setResponseName("response");
        this.mc.setProperty("response.envelope", (Object)this.bus);
        this.attachmentList = new ArrayList<InputStream>();
        this.cache = this.cmgr.getCacheDelegate(this.pathBits[1]);
    }

    @Override
    public void handle(MessageContext mc) throws PogoException {
        this.initialize(mc);
        if (this.pathBits.length == 2) {
            this.attachmentList.add(this.statsReportResponse(this.cache));
        } else if (this.pathBits[2].equals("stats")) {
            this.attachmentList.add(this.statsToggleResponse(this.cache));
        } else if (this.pathBits[2].equals("clear")) {
            this.attachmentList.add(this.clearResponse());
        }
        this.respond();
    }

    protected void respond() {
        if (this.attachmentList != null && this.attachmentList.size() > 0) {
            this.setResponseAttachmentProperties();
        }
        this.mc.setProperty("response.status_code", (Object)Integer.toString(this.status));
        this.logger.stopPerf(this.perfData, "Leaving " + this.getClass().getName() + " execute", "EXIT");
    }

    private void setResponseAttachmentProperties() {
        this.mc.setProperty("response.attachments", this.attachmentList.iterator());
        this.mc.setProperty("response.boundary", (Object)this.getBoundryValue());
    }

    private InputStream clearResponse() {
        this.cmgr.clearAll();
        PDCLogging.PDC_INFO.info("CacheService cache cleared.");
        String message = "Content-Type: text/plain\r\n\r\nall caches cleared";
        return new ByteArrayInputStream("Content-Type: text/plain\r\n\r\nall caches cleared".getBytes());
    }

    private InputStream statsToggleResponse(CacheDelegate cache2) {
        boolean statisticsEnabled = !cache2.isStatisticsEnabled();
        String statisticsStatus = statisticsEnabled ? "on" : "off";
        PDCLogging.PDC_INFO.info("CacheService statistics turned " + statisticsStatus);
        cache2.setStatisticsEnabled(statisticsEnabled);
        StringBuilder response = new StringBuilder();
        response.append("Content-Type: text/plain\r\n\r\n");
        response.append(cache2.getName()).append(" statistics is now " + statisticsStatus);
        return new ByteArrayInputStream(response.toString().getBytes());
    }

    private InputStream statsReportResponse(CacheDelegate cache2) {
        StringBuilder response = new StringBuilder();
        response.append("Content-Type: text/plain\r\n\r\n");
        response.append("statistics for ").append(this.cache.getName()).append("\r\n");
        response.append(this.cache.getStatisticsString()).append("\r\n");
        response.append("in memory size: ").append(this.cache.calculateInMemorySize());
        return new ByteArrayInputStream(response.toString().getBytes());
    }

    protected String getBoundryValue() {
        if ("".equals(this.m_sBoundryValue)) {
            this.m_sBoundryValue = StringUtils.getUniqueValue();
        }
        return this.m_sBoundryValue;
    }

    protected GetMethod createGetMethod(String url) {
        return new GetMethod(url);
    }

    protected void executeRequest(URL url, GetMethod method) throws CAMCryptoException, HttpException, IOException {
        HttpClient client = camUtils.createHttpClient(url);
        client.executeMethod((HttpMethod)method);
    }
}

