/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cache.internal.handlers;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.ibm.cognos.pdc.cache.CacheManagerDelegate;
import com.ibm.cognos.pdc.cache.CachedItem;
import com.ibm.cognos.pdc.cache.internal.CacheServiceConfiguration;
import com.ibm.cognos.pdc.cache.internal.handlers.CacheHandler;
import com.ibm.cognos.pdc.cache.internal.handlers.SynchMap;
import com.ibm.cognos.pdc.cache.internal.logging.IPFLogger;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.sf.ehcache.Element;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.GetMethod;

public class CmCacheHandler
extends CacheHandler {
    protected static ConcurrentHashMap<String, String> passportCurrentStoreID = new ConcurrentHashMap();
    private static SynchMap<String, Object> storeIDLocks = new SynchMap();

    public CmCacheHandler(CacheManagerDelegate cmgr, String pathInfo, CacheServiceConfiguration config, IPFLogger logger) {
        super(cmgr, pathInfo, config, logger);
    }

    @Override
    public void handle(MessageContext mc) throws PogoException {
        this.initialize(mc);
        PDCLogging.PDC_DEBUG.finest(MessageFormat.format((String)"Cacheservice handling request {0}.", (Object[])new Object[]{this.request.getPathInfo()}));
        String passportID = (String)mc.getProperty("auth.passportid");
        if (this.pathBits.length < 4) {
            PDCLogging.PDC_ERROR.warning("Provided pathInfo is missing elements (actual pathInfo: " + this.request.getPathInfo() + " expected: /output/cm/<storeID>/[partName])");
        } else {
            String storeID = this.pathBits[3];
            if (this.pathBits.length == 4 && this.pathBits[3].length() == 33 && !this.request.getPathInfo().endsWith("/")) {
                this.status = 404;
                PDCLogging.PDC_ERROR.severe("The pathInfo did not have a trailing slash (/) which will cause the references to the parts to be invalid.");
            } else if (storeID.length() != 33) {
                this.status = 404;
                PDCLogging.PDC_ERROR.warning(MessageFormat.format((String)"The pathInfo did not contain a valid store ID ({0})", (Object[])new Object[]{storeID}));
            } else {
                Element element = this.cache.get(storeID);
                if (null == element) {
                    element = this.loadFromCM(passportID, storeID);
                }
                if (element != null) {
                    CachedItem item = (CachedItem)element.getValue();
                    if (this.do304(item, storeID)) {
                        this.status = 304;
                        PDCLogging.PDC_DEBUG.fine(MessageFormat.format((String)"CacheService returned the status code 304 for cache item {0}.", (Object[])new Object[]{storeID}));
                    } else if (this.hasAccess(item, storeID, passportID)) {
                        StringBuilder partName = null;
                        if (this.pathBits.length > 4) {
                            partName = new StringBuilder();
                            for (int i = 4; i < this.pathBits.length; ++i) {
                                partName.append(this.pathBits[i]).append(i < this.pathBits.length - 1 ? "/" : "");
                            }
                        }
                        if (item.hasPart(partName != null ? partName.toString() : null)) {
                            String cacheHeaders = this.genEtagHeader(item, storeID);
                            this.attachmentList.add(new SequenceInputStream(new ByteArrayInputStream(cacheHeaders.getBytes()), item.getInputStream(partName != null ? partName.toString() : null, true)));
                        } else {
                            this.status = 404;
                            String message = "The cache item {0} does not have a ";
                            message = null == partName ? message + "default part." : message + "part named {1}.";
                            PDCLogging.PDC_DEBUG.fine(MessageFormat.format((String)message, (Object[])new Object[]{storeID, partName.toString()}));
                        }
                    } else {
                        this.status = 404;
                        PDCLogging.PDC_DEBUG.fine(MessageFormat.format((String)"The current security context {0} does not have access to cache item {1}.", (Object[])new Object[]{passportID, storeID}));
                    }
                } else {
                    this.status = 404;
                    PDCLogging.PDC_DEBUG.warning(MessageFormat.format((String)"CacheService failed to load cache item {0} from Content Manager for security context {1}.", (Object[])new Object[]{storeID, passportID}));
                }
            }
        }
        this.respond();
        PDCLogging.PDC_DEBUG.finest(MessageFormat.format((String)"Cacheservice finished handling request {0} and returning {1}.", (Object[])new Object[]{this.request.getPathInfo(), new Integer(this.status)}));
    }

    private boolean do304(CachedItem item, String storeID) {
        String inm = this.request.getHeader("If-None-Match");
        if (null == inm) {
            return false;
        }
        return inm.equals("\"" + storeID + "\"");
    }

    private String genEtagHeader(CachedItem item, String storeID) {
        return "Etag: \"" + storeID + "\"\r\n";
    }

    private boolean hasAccess(CachedItem item, String storeID, String passportID) {
        String sStoreID = passportCurrentStoreID.get(passportID);
        if (sStoreID != null && sStoreID.compareTo(storeID) == 0) {
            return true;
        }
        String cmRestURL = this.config.getCMRestURL();
        if (cmRestURL != null) {
            try {
                StringBuilder urlPath = new StringBuilder();
                urlPath.append(cmRestURL).append("/").append(storeID).append("/data");
                URL url = new URL(urlPath.toString());
                GetMethod get = this.createGetMethod(urlPath.toString());
                this.transferHeadersTo(get);
                get.setRequestHeader("If-None-Match", item.getEtag());
                this.executeRequest(url, get);
                PDCLogging.PDC_DEBUG.finer(MessageFormat.format((String)"Get request sent to Content Manager for access check returned status {0}.", (Object[])new Object[]{get.getStatusCode()}));
                if (get.getStatusCode() == 304) {
                    passportCurrentStoreID.put(passportID, storeID);
                    return true;
                }
            }
            catch (CAMCryptoException ex) {
                this.status = 404;
                PDCLogging.PDC_DEBUG.log(Level.FINER, MessageFormat.format((String)"CacheService caught a CAMCryptoException when verifying access to cache item {0} for security context {1} with Content Manager.", (Object[])new Object[]{storeID, passportID}), ex);
            }
            catch (HttpException ex) {
                this.status = 404;
                PDCLogging.PDC_DEBUG.log(Level.FINER, MessageFormat.format((String)"CacheService caught an HttpException when verifying access to cache item {0} for security context {1} with Content Manager.", (Object[])new Object[]{storeID, passportID}), ex);
            }
            catch (IOException ex) {
                this.status = 404;
                PDCLogging.PDC_DEBUG.log(Level.FINER, MessageFormat.format((String)"CacheService caught an IOException when verifying access to cache item {0} for security context {1} with Content Manager.", (Object[])new Object[]{storeID, passportID}), ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element loadFromCM(String passportID, String storeID) {
        Object lock;
        Element result = null;
        Object object = lock = storeIDLocks.put(storeID);
        synchronized (object) {
            String cmRestURL;
            result = this.cache.get(storeID);
            if (result == null && (cmRestURL = this.config.getCMRestURL()) != null) {
                try {
                    StringBuilder urlPath = new StringBuilder();
                    urlPath.append(cmRestURL).append("/").append(storeID).append("/data");
                    URL url = new URL(urlPath.toString());
                    GetMethod get = this.createGetMethod(urlPath.toString());
                    this.transferHeadersTo(get);
                    this.executeRequest(url, get);
                    PDCLogging.PDC_DEBUG.finer(MessageFormat.format((String)"Get request sent to Content Manager returned status {0}.", (Object[])new Object[]{get.getStatusCode()}));
                    if (get.getStatusCode() == 200) {
                        StringBuilder sb = new StringBuilder();
                        Header[] headers = get.getResponseHeaders();
                        for (int i = 0; i < headers.length; ++i) {
                            sb.append(headers[i].getName()).append(":").append(headers[i].getValue()).append("\r\n");
                        }
                        sb.append("\r\n");
                        ArrayList<SequenceInputStream> ar = new ArrayList<SequenceInputStream>(1);
                        ar.add(new SequenceInputStream(new ByteArrayInputStream(sb.toString().getBytes()), get.getResponseBodyAsStream()));
                        CachedItem cfi = this.itemFactory.createCachedItem(storeID, ar.iterator());
                        cfi.setExpiry(System.currentTimeMillis() + 31449600000L);
                        result = new Element((Serializable)((Object)cfi.getName()), (Serializable)cfi);
                        this.cache.put(result);
                        passportCurrentStoreID.put(passportID, storeID);
                    } else {
                        this.status = get.getStatusCode();
                        PDCLogging.PDC_DEBUG.finer(MessageFormat.format((String)"Get request to Content Manager to retrieve output returned the code {0}.", (Object[])new Object[]{this.status}));
                    }
                }
                catch (CAMCryptoException ex) {
                    this.status = 404;
                    PDCLogging.PDC_DEBUG.log(Level.FINER, MessageFormat.format((String)"CacheService caught a CAMCryptoException when verifying access to cache item {0} for security context {1} with Content Manager.", (Object[])new Object[]{storeID, passportID}), ex);
                }
                catch (HttpException ex) {
                    this.status = 404;
                    PDCLogging.PDC_DEBUG.log(Level.FINER, MessageFormat.format((String)"CacheService caught an HttpException when verifying access to cache item {0} for security context {1} with Content Manager.", (Object[])new Object[]{storeID, passportID}), ex);
                }
                catch (IOException ex) {
                    this.status = 404;
                    PDCLogging.PDC_DEBUG.log(Level.FINER, MessageFormat.format((String)"CacheService caught an IOException when verifying access to cache item {0} for security context {1} with Content Manager.", (Object[])new Object[]{storeID, passportID}), ex);
                }
            }
        }
        storeIDLocks.remove(storeID);
        return result;
    }

    private void transferHeadersTo(GetMethod get) {
        Enumeration e = this.request.getHeaderNames();
        while (e.hasMoreElements()) {
            String headerName = (String)e.nextElement();
            if (headerName.equalsIgnoreCase("if-none-match")) continue;
            get.setRequestHeader(headerName, this.request.getHeader(headerName));
        }
    }
}

