/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cache.internal.handlers;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.URLEncoderDecoder;
import com.ibm.cognos.pdc.cache.CacheManagerDelegate;
import com.ibm.cognos.pdc.cache.CachedItem;
import com.ibm.cognos.pdc.cache.internal.CacheServiceConfiguration;
import com.ibm.cognos.pdc.cache.internal.handlers.CacheHandler;
import com.ibm.cognos.pdc.cache.internal.logging.IPFLogger;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import net.sf.ehcache.Element;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.GetMethod;

public class DispCacheHandler
extends CacheHandler {
    public DispCacheHandler(CacheManagerDelegate cmgr, String pathInfo, CacheServiceConfiguration config, IPFLogger logger) {
        super(cmgr, pathInfo, config, logger);
    }

    @Override
    public void handle(MessageContext mc) throws PogoException {
        block25: {
            this.initialize(mc);
            String passportID = (String)mc.getProperty("auth.passportid");
            Map<String, DispatcherListElement> dispatchers = this.config.getDispatchers();
            boolean usePassportID = true;
            if (!this.cache.getName().startsWith("p")) {
                usePassportID = false;
            }
            if (this.pathBits[2].equals(this.getDispNodeIdGUID()) || this.pathBits[2].equals("*")) {
                String objName = this.pathBits[3];
                String fullObjName = (usePassportID ? passportID : "") + objName;
                Element element = this.cache.get(fullObjName);
                if (null == element) {
                    this.status = 404;
                    PDCLogging.PDC_DEBUG.fine(MessageFormat.format((String)"CacheService does not have the cache item {0} cached.", (Object[])new Object[]{fullObjName}));
                } else {
                    CachedItem item = (CachedItem)element.getValue();
                    String etag = this.request.getHeader("If-None-Match");
                    long etagl = 0L;
                    if (etag != null && etag.indexOf(34) != -1) {
                        try {
                            etagl = Long.parseLong(etag.substring(1, etag.length() - 1));
                        }
                        catch (NumberFormatException ex) {
                            PDCLogging.PDC_DEBUG.log(Level.FINER, MessageFormat.format((String)"CacheService caught a NumberFormatException while parsing the value of the If-None-Match header {0}.", (Object[])new Object[]{etag}), ex);
                        }
                    }
                    if (etagl == element.getCreationTime()) {
                        this.status = 304;
                        PDCLogging.PDC_DEBUG.fine("The creation time of the cache item matches the value of the If-None-Match header.  Returning HTTP 304.");
                    } else {
                        StringBuilder partName = new StringBuilder();
                        for (int i = 4; i < this.pathBits.length; ++i) {
                            partName.append(this.pathBits[i]).append(i < this.pathBits.length - 1 ? "/" : "");
                        }
                        if (item.hasPart(partName.toString())) {
                            this.attachmentList.add(item.getInputStream(partName.toString(), true));
                        } else {
                            this.status = 404;
                            PDCLogging.PDC_DEBUG.fine(MessageFormat.format((String)"The part named {0} is missing for cache item {1}", (Object[])new Object[]{partName.toString(), fullObjName}));
                        }
                    }
                }
            } else {
                DispatcherListElement disp = dispatchers.get(this.pathBits[2]);
                if (disp != null) {
                    try {
                        NodeID node = disp.getNodeID();
                        StringBuilder urlPath = new StringBuilder();
                        urlPath.append(node.getProtocol()).append("://");
                        urlPath.append(node.getHostPortAndContext()).append("/");
                        urlPath.append("servlet/dispatch");
                        urlPath.append(URLEncoderDecoder.encode((String)this.request.getPathInfo(), (String)"UTF-8", (boolean)false, (boolean)false));
                        GetMethod get = this.createGetMethod(urlPath.toString());
                        Enumeration e = this.request.getHeaderNames();
                        while (e.hasMoreElements()) {
                            String headerName = (String)e.nextElement();
                            get.setRequestHeader(headerName, this.request.getHeader(headerName));
                        }
                        this.executeRequest(new URL(urlPath.toString()), get);
                        if (get.getStatusCode() == 200) {
                            StringBuilder sb = new StringBuilder();
                            Header[] headers = get.getResponseHeaders();
                            for (int i = 0; i < headers.length; ++i) {
                                if (headers[i].getName().indexOf("-encoding") != -1) continue;
                                sb.append(headers[i].getName()).append(":").append(headers[i].getValue()).append("\r\n");
                            }
                            sb.append("\r\n");
                            this.attachmentList.add(new SequenceInputStream(new ByteArrayInputStream(sb.toString().getBytes()), get.getResponseBodyAsStream()));
                            break block25;
                        }
                        this.status = get.getStatusCode();
                    }
                    catch (MalformedURLException e) {
                        this.status = 404;
                    }
                    catch (HttpException e) {
                        this.status = 404;
                    }
                    catch (NullPointerException e) {
                        this.status = 404;
                    }
                    catch (UnsupportedEncodingException e) {
                        this.status = 404;
                    }
                    catch (CAMCryptoException e) {
                        this.status = 404;
                    }
                    catch (IOException e) {
                        this.status = 404;
                    }
                } else {
                    this.status = 404;
                }
            }
        }
        this.respond();
    }

    protected String getDispNodeIdGUID() {
        return NodeID.getSelf().getGuid();
    }
}

