/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cache.internal.handlers;

import com.ibm.cognos.pdc.cache.CacheManagerDelegate;
import com.ibm.cognos.pdc.cache.internal.CacheServiceConfiguration;
import com.ibm.cognos.pdc.cache.internal.handlers.CacheHandler;
import com.ibm.cognos.pdc.cache.internal.handlers.CmCacheHandler;
import com.ibm.cognos.pdc.cache.internal.handlers.DispCacheHandler;
import com.ibm.cognos.pdc.cache.internal.handlers.ICacheHandler;
import com.ibm.cognos.pdc.cache.internal.logging.IPFLogger;

public class HandlerFactory {
    public ICacheHandler createHandler(CacheManagerDelegate cmgr, String pathInfo, CacheServiceConfiguration config, IPFLogger logger) {
        if (cmgr == null || pathInfo == null || config == null || logger == null) {
            throw new IllegalArgumentException("No constructor parameters can be null");
        }
        String[] pathBits = pathInfo.split("/");
        if (pathBits != null) {
            if (pathBits.length == 2 || pathBits.length == 3 && (pathBits[2].equals("stats") || pathBits[2].equals("clear"))) {
                return this.createCacheHandler(cmgr, pathInfo, config, logger);
            }
            if (pathBits.length >= 3 && pathBits[2].equals("cm")) {
                return this.createCmCacheHandler(cmgr, pathInfo, config, logger);
            }
            return this.createDispCacheHandler(cmgr, pathInfo, config, logger);
        }
        return null;
    }

    protected ICacheHandler createDispCacheHandler(CacheManagerDelegate cmgr, String pathInfo, CacheServiceConfiguration config, IPFLogger logger) {
        return new DispCacheHandler(cmgr, pathInfo, config, logger);
    }

    protected ICacheHandler createCacheHandler(CacheManagerDelegate cmgr, String pathInfo, CacheServiceConfiguration config, IPFLogger logger) {
        return new CacheHandler(cmgr, pathInfo, config, logger);
    }

    protected ICacheHandler createCmCacheHandler(CacheManagerDelegate cmgr, String pathInfo, CacheServiceConfiguration config, IPFLogger logger) {
        return new CmCacheHandler(cmgr, pathInfo, config, logger);
    }
}

