/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf;

import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.caf.CAFCookieException;
import com.cognos.caf.CAFProtector;
import com.cognos.caf.CAFValidator;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.logging.CAFLog;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class CAFCookie {
    private static final int m_MAX_PASSPORT_LIST_SIZE = 32;
    private static final int m_LARGE_CAF_COOKIE_SIZE = 3136;
    private static final int m_LARGE_SESSION_SHADOW_SIZE = 256;
    private static final String m_ITEM_SEPARATOR = "|";
    private String m_cookiePassportList = null;
    private String m_cookieTPSessionShadow = null;
    private boolean m_updated = false;
    private boolean m_validated = false;
    private LinkedList m_passportList = null;
    private String m_tpSessionShadow = null;
    private boolean m_valid = true;

    public CAFCookie(String value) throws CAFException {
        if (value != null && value.length() > 0) {
            StringTokenizer st = new StringTokenizer(value, m_ITEM_SEPARATOR);
            this.m_cookiePassportList = st.nextToken();
            if (st.countTokens() == 1) {
                this.m_cookieTPSessionShadow = st.nextToken();
            }
            if (st.countTokens() != 0) {
                CAFLog.error("too many tokens in CAF cookie", "CAF cookie", value);
                this.resetPassportList();
                this.resetTPSession();
                this.m_valid = false;
            }
        }
    }

    public CAFCookie() throws CAFException {
        this(null);
    }

    private void resetPassportList() {
        this.m_passportList = null;
        this.m_cookiePassportList = null;
    }

    public void resetTPSession() {
        this.m_tpSessionShadow = null;
        this.m_cookieTPSessionShadow = null;
    }

    private boolean validateAndExtractPassports(String wrapPassportList, SigningSession signingSession) throws CAFException {
        boolean valid = false;
        StringBuffer buf = new StringBuffer(3136);
        valid = CAFValidator.unwrapAndCheckSignature(wrapPassportList, buf, null, signingSession, null, true, true);
        StringTokenizer st = null;
        if (valid && (st = new StringTokenizer(buf.toString(), m_ITEM_SEPARATOR)).countTokens() < 2) {
            valid = false;
            CAFLog.error("invalid number of tokens ('|' separated) in CAF cookie", "CAF cookie buffer", buf.toString());
        }
        if (valid && !(valid = CAFValidator.checkTimestamp(st.nextToken()))) {
            CAFLog.error("caf cookie timestamp check failed");
        }
        if (valid) {
            String token = null;
            this.m_passportList = new LinkedList();
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                this.m_passportList.add(token);
            }
        }
        if (!valid) {
            CAFLog.error("validate and extract CAF cookie passport list failed", "passport list", wrapPassportList);
        }
        return valid;
    }

    private boolean validateAndExtractTPSessionShadow(String wrapTPSessionShadow, String passport, SigningSession signingSession) throws CAFException {
        boolean valid = false;
        StringBuffer buf = new StringBuffer(256);
        if (CAFValidator.unwrapAndCheckSignature(wrapTPSessionShadow, buf, passport, signingSession, null, false, false)) {
            this.m_tpSessionShadow = buf.toString();
            valid = true;
        } else {
            valid = false;
            CAFLog.error("validate and extract session shadow failed", "session shadow", wrapTPSessionShadow);
        }
        return valid;
    }

    public void validateAndExtract(String passport, SigningSession signingSession) throws CAFException {
        try {
            if (!this.m_valid) {
                CAFLog.error("CAF cookie for validate and extract invalid since construction");
            }
            if (!this.m_validated) {
                if (this.m_cookiePassportList != null || this.m_cookieTPSessionShadow != null) {
                    if (this.m_cookiePassportList != null && !this.validateAndExtractPassports(this.m_cookiePassportList, signingSession)) {
                        CAFLog.error("failed to validate CAF cookie passport list - setting empty list", "CAF cookie", this.toString());
                        this.resetPassportList();
                    }
                    if (this.m_cookieTPSessionShadow != null) {
                        if (passport == null) {
                            CAFLog.error("third party session shadow validation requires non-null passport - setting empty shadow", "CAF cookie", this.toString());
                            this.resetTPSession();
                        } else if (!this.validateAndExtractTPSessionShadow(this.m_cookieTPSessionShadow, passport, signingSession)) {
                            CAFLog.error("failed to validate CAF cookie third party session shadow - setting empty shadow", "CAF cookie", this.toString());
                            this.resetTPSession();
                        }
                    }
                }
                this.m_validated = true;
            }
        }
        catch (Exception e) {
            throw new CAFCookieException(e, 1);
        }
    }

    private void updatePassportList(String passport, SigningSession signingSession) throws CAFException {
        boolean found = false;
        if (this.m_passportList == null) {
            this.m_passportList = new LinkedList();
        } else {
            Iterator i = this.m_passportList.iterator();
            String listPassport = null;
            while (!found && i.hasNext()) {
                listPassport = (String)i.next();
                if (!passport.equals(listPassport)) continue;
                found = true;
            }
        }
        if (CAFLog.isTracingEnabled) {
            CAFLog.trace("CAFCookie.updatePassportList()", "passport list size", String.valueOf(this.m_passportList.size()), "found", String.valueOf(found), 10000);
        }
        if (!found) {
            if (this.m_passportList.size() == 32) {
                this.m_passportList.remove(0);
            }
            this.m_passportList.add(passport);
            StringBuffer buf = new StringBuffer(3136);
            long time = System.currentTimeMillis();
            time = (long)Math.floor(time / 3600000L);
            String strTime = String.valueOf(time);
            buf.append(strTime);
            Iterator i = this.m_passportList.iterator();
            while (i.hasNext()) {
                buf.append(m_ITEM_SEPARATOR);
                passport = (String)i.next();
                buf.append(passport);
            }
            String newUnwrapCAFCookie = buf.toString();
            this.m_cookiePassportList = CAFProtector.saltedHMACWeb64AndWrap(newUnwrapCAFCookie, null, signingSession);
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("updatePassportList() - passport list updated", "passport list", this.m_cookiePassportList, 10000);
                CAFLog.trace("updatePassportList()- passport list updated", "newUnwrapCAFCookie", newUnwrapCAFCookie, 10000);
            }
            this.m_updated = true;
        }
    }

    private void updateTPSessionShadow(String passport, SigningSession signingSession, String tpSession) throws CAFException {
        if (!(tpSession == null || this.m_tpSessionShadow != null && tpSession.equals(this.m_tpSessionShadow))) {
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("third party session shadow needs updating", "third party session shadow", this.m_tpSessionShadow, 10000);
            }
            this.m_tpSessionShadow = tpSession;
            this.m_cookieTPSessionShadow = CAFProtector.web64AndWrap(CAFProtector.signAndWrap(this.m_tpSessionShadow, passport, signingSession));
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("CAF cookie session shadow updated", "third party session shadow", this.m_tpSessionShadow, 10000);
            }
            this.m_updated = true;
        }
    }

    public void update(String passport, SigningSession signingSession, String tpSession) throws CAFException {
        try {
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("CAFCookie.update()", "passport", passport, 10000);
            }
            if (!this.m_validated) {
                this.validateAndExtract(passport, signingSession);
            }
            if (passport != null && passport.length() > 0) {
                this.updatePassportList(passport, signingSession);
                this.updateTPSessionShadow(passport, signingSession, tpSession);
            }
            this.m_valid = true;
        }
        catch (Exception e) {
            throw new CAFCookieException(e, 0);
        }
    }

    public boolean updated() {
        return this.m_updated;
    }

    public List passports() {
        return this.m_passportList;
    }

    public String tpSessionShadow() {
        return this.m_tpSessionShadow;
    }

    public String toString() {
        String res = null;
        if (this.m_cookiePassportList != null) {
            StringBuffer buf = new StringBuffer(3136);
            buf.append(this.m_cookiePassportList);
            if (this.m_cookieTPSessionShadow != null) {
                buf.append(m_ITEM_SEPARATOR);
                buf.append(this.m_cookieTPSessionShadow);
            }
            res = buf.toString();
        }
        return res;
    }
}

