/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.caf.CAFExceptionUtilities;
import com.cognos.caf.CAFFirewallException;
import com.cognos.caf.CAFHandlerImpl;
import com.cognos.caf.CAFHandlerStub;
import com.cognos.caf.CAFLibrary;
import com.cognos.caf.CAFProtector;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.config.CAFConfig;
import com.cognos.caf.logging.CAFLog;
import com.cognos.caf.logging.CAFUnknownParam;
import com.cognos.caf.rule.CAFRules;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.pdk.CAFConfigurationException;
import com.cognos.pogo.pdk.CAFFactory;
import com.cognos.pogo.pdk.CAFHandler;
import java.util.HashMap;

public class CAFFactoryImpl
implements CAFFactory {
    private static boolean m_configured = false;
    private static int m_configuredCount = 0;
    private final String m_CAF_REL_DIR = "../caf";
    private final String m_CONFIG_REL_DIR = "../configuration";
    private HashMap m_properties = new HashMap();
    protected static String m_cafDirPath = null;
    protected static String m_configDirPath = null;
    public static CAMFactory camFactory = null;

    private static void _checkIfConfigured() throws CAFFirewallException {
        if (!m_configured) {
            if (CAFExceptionUtilities.getFirstException() != null) {
                throw new CAFFirewallException(CAFExceptionUtilities.getFirstException(), 42);
            }
            throw new CAFFirewallException(42);
        }
    }

    public CAFHandler createCAFHandler(boolean getMethod, String servletPath) {
        Object res = null;
        try {
            CAFFactoryImpl._checkIfConfigured();
            res = CAFConfig.m_validationEnabled ? new CAFHandlerImpl(getMethod, servletPath) : new CAFHandlerStub();
        }
        catch (Exception e) {
            CAFExceptionUtilities.handleException(e, 4);
        }
        return res;
    }

    public synchronized void configure() throws CAFConfigurationException {
        try {
            if (!m_configured) {
                String CAM_INIT_PARAM = "<initializeDocument><serviceID>CAF</serviceID></initializeDocument>";
                this.initCommon();
                this.initCAMFactory("<initializeDocument><serviceID>CAF</serviceID></initializeDocument>");
                this.initCAFRules();
                this.m_properties.put("cafEnabled", Boolean.TRUE);
                m_configured = true;
                ++m_configuredCount;
                CAFUnknownParam.init();
                CAFLog.logCAFStatus();
            } else {
                ++m_configuredCount;
            }
        }
        catch (Exception e) {
            this.m_properties.put("cafEnabled", Boolean.FALSE);
            CAFExceptionUtilities.handleConfigException(e, 1);
        }
    }

    private synchronized void initCAMFactory(String CAM_INIT_PARAM) throws CAFException, CAFFirewallException {
        camFactory = new CAMFactory();
        try {
            camFactory.initialize(CAM_INIT_PARAM.getBytes("UTF-8"));
        }
        catch (Exception e) {
            CAFLog.trace("CAFFirewall camFactory.initialize() failed", 50000);
            throw new CAFFirewallException(e, 12);
        }
    }

    private synchronized void initCAFRules() throws CAFException {
        if (CAFConfig.m_validationEnabled) {
            CAFRules.initialize(m_cafDirPath);
        }
    }

    private synchronized void initCommon() throws CCLConfigurationException, CAFConfigurationException, CAFException {
        ICCLConfiguration cclConfig = CCLConfigurationFactory.getInstance();
        cclConfig.init();
        m_cafDirPath = cclConfig.resolveEffectivePath("../caf");
        m_configDirPath = cclConfig.resolveEffectivePath("../configuration");
        CAFLog.initialize();
        CAFConfig.initialize(cclConfig, m_configDirPath);
        CAFLog.trace("CAFFirewall configure()", "validation enabled", String.valueOf(CAFConfig.m_validationEnabled), 50000);
        CAFProtector.initialize();
        CAFLibrary.initialize();
    }

    public boolean getBooleanProperty(String property) throws CAFConfigurationException {
        boolean res = false;
        try {
            CAFFactoryImpl._checkIfConfigured();
            Object value = this.m_properties.get(property);
            if (value == null || !(value instanceof Boolean)) {
                throw new CAFFirewallException(25);
            }
            res = (Boolean)value;
        }
        catch (Exception e) {
            CAFExceptionUtilities.handleConfigException(e, 26);
        }
        return res;
    }

    public String getStringProperty(String property) throws CAFConfigurationException {
        String res = null;
        try {
            CAFFactoryImpl._checkIfConfigured();
            Object value = this.m_properties.get(property);
            if (value == null || !(value instanceof String)) {
                throw new CAFFirewallException(25);
            }
            res = (String)value;
        }
        catch (Exception e) {
            CAFExceptionUtilities.handleConfigException(e, 27);
        }
        return res;
    }

    public String protect(String actionValues, String data) {
        String res = null;
        try {
            CAFFactoryImpl._checkIfConfigured();
            res = CAFProtector.getInstance().doActions(data, actionValues, null);
        }
        catch (Exception e) {
            CAFExceptionUtilities.handleException(e, 28);
        }
        return res;
    }

    public synchronized void terminate() {
        try {
            if (m_configured && --m_configuredCount == 0) {
                m_configured = false;
                if (camFactory != null) {
                    camFactory.terminate();
                    camFactory = null;
                }
            }
        }
        catch (Exception e) {
            CAFExceptionUtilities.handleException(e, 15);
        }
    }
}

