/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.SecureStateSession;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.caf.CAFCookie;
import com.cognos.caf.CAFExceptionUtilities;
import com.cognos.caf.CAFFactoryImpl;
import com.cognos.caf.CAFFirewallException;
import com.cognos.caf.CAFHandlerException;
import com.cognos.caf.CAFPatternCache;
import com.cognos.caf.CAFProtector;
import com.cognos.caf.CAFRequestObject;
import com.cognos.caf.CAFValidator;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.common.CAFUtil;
import com.cognos.caf.common.CAFValidationData;
import com.cognos.caf.common.CAFValidationException;
import com.cognos.caf.config.CAFConfig;
import com.cognos.caf.logging.CAFLog;
import com.cognos.caf.rule.CAFRules;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.CAFHandler;
import com.cognos.pogo.pdk.CAFRuntimeException;
import com.cognos.pogo.pdk.common.CookieVars;
import com.cognos.pogo.pdk.common.HdrSession;
import com.cognos.pogo.util.NameValuePair;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.Cookie;

public class CAFHandlerImpl
implements CAFHandler {
    private static final String PATTERN_BYPASS_ACTIONS = "bypassactions";
    private static final String PATTERN_BYPASS_PATH_INFOS = "bypasspathinfos";
    private static final String GLOBAL_PARAMETERS = "generic.anyURI.runOptionEnum#globalParameters";
    private static final String EXTERNAL_SUFFIX = "/ext";
    private CAFRequestObject m_requestObject = null;
    private String m_pathInfo = null;
    private String m_action = null;
    private boolean m_getRequest = false;
    private boolean m_externalRequest = false;
    private String m_reportURLCopy = null;

    public CAFHandlerImpl(boolean isGet, String servletPath) throws CAFException {
        try {
            this.m_getRequest = isGet;
            boolean bl = this.m_externalRequest = servletPath != null && servletPath.endsWith(EXTERNAL_SUFFIX);
            if (CAFLog.isTracingEnabled) {
                String s = "CAFHandlerImpl constructor";
                CAFLog.trace(s, "servlet path", servletPath, "external request", String.valueOf(this.m_externalRequest), 30000, "request");
                CAFLog.trace(s, "GET request", String.valueOf(this.m_getRequest), 30000, "request");
            }
        }
        catch (Exception e) {
            throw new CAFHandlerException(e, 6);
        }
    }

    public String updateQueryString(String queryString) throws CAFRuntimeException {
        String res = queryString;
        try {
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("updateQueryString()", "query string", queryString, 10000, "request");
            }
            if (queryString != null && CAFConfig.m_tpXSSCheckingUsed) {
                StringBuffer modifiedQS = new StringBuffer(queryString.length());
                String urlDecodedQS = queryString;
                urlDecodedQS = this.queryStringURLDecode(queryString, modifiedQS, urlDecodedQS);
                StringBuffer invalidChar = new StringBuffer(1);
                this.queryStringContainsXSSChar(queryString, urlDecodedQS, invalidChar);
                res = this.queryStringParseAndDecodeXSSChars(queryString, res, modifiedQS);
            }
        }
        catch (Exception e) {
            CAFExceptionUtilities.handleException(e, 1);
        }
        return res;
    }

    private String queryStringParseAndDecodeXSSChars(String queryString, String res, StringBuffer modifiedQS) throws CAFException {
        modifiedQS.setLength(0);
        if (CAFProtector.parseAndDecodeXSSChars(queryString, modifiedQS)) {
            res = modifiedQS.toString();
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("third party XSS", "modified query string", queryString, 10000, "request");
            }
        }
        return res;
    }

    private void queryStringContainsXSSChar(String queryString, String urlDecodedQS, StringBuffer invalidChar) throws CAFException, CAFValidationException {
        String noGlobalParameter = this.dropGlobalParameters(urlDecodedQS);
        if (CAFProtector.containsXSSChar(noGlobalParameter, invalidChar)) {
            String title = "third party XSS check failure";
            CAFLog.error("third party XSS check failure", "invalid character", invalidChar.toString());
            CAFLog.error("third party XSS check failure", "query string", queryString, "URL decoded query string", urlDecodedQS);
            CAFLog.error("third party XSS check failure", "query string", queryString, "URL decoded query string without global parameters", noGlobalParameter);
            throw new CAFValidationException();
        }
        if (CAFLog.isTracingEnabled) {
            CAFLog.trace("third party XSS", "URL decoded query string", urlDecodedQS, 10000, "request");
            CAFLog.trace("third party XSS", "URL decoded query string without global parameters", noGlobalParameter, 10000, "request");
        }
    }

    private String queryStringURLDecode(String queryString, StringBuffer modifiedQS, String urlDecodedQS) {
        if (CAFUtil.perfURLDecode(queryString.toCharArray(), modifiedQS)) {
            urlDecodedQS = modifiedQS.toString();
            modifiedQS.setLength(0);
            if (CAFUtil.perfURLDecode(urlDecodedQS.toCharArray(), modifiedQS)) {
                urlDecodedQS = modifiedQS.toString();
            }
        }
        return urlDecodedQS;
    }

    private static String _checkForGDURLs(String pathInfo) throws CAFException {
        try {
            String reportURL = null;
            if (pathInfo != null && pathInfo.startsWith("/gd/")) {
                int startPos = 4;
                int endPos = pathInfo.indexOf("/", startPos);
                if (endPos == -1) {
                    endPos = pathInfo.length();
                }
                reportURL = pathInfo.substring(startPos, endPos);
                if (CAFLog.isTracingEnabled) {
                    CAFLog.trace("found report URL request", "PATH_INFO", pathInfo, "report url", reportURL, 30000, "request");
                }
            }
            return reportURL;
        }
        catch (Exception e) {
            throw new CAFHandlerException(e, 7);
        }
    }

    public String updatePathInfo(String pathInfo) throws CAFRuntimeException {
        this.m_pathInfo = pathInfo;
        try {
            String reportURL;
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("updatePathInfo()", "path info", pathInfo, 30000, "request");
            }
            if (pathInfo != null && this.m_getRequest && CAFConfig.m_signedReportUrls && (reportURL = CAFHandlerImpl._checkForGDURLs(pathInfo)) != null) {
                this.m_reportURLCopy = reportURL;
                this.buildNewGDURL(pathInfo, reportURL);
            }
        }
        catch (Exception e) {
            CAFExceptionUtilities.handleException(e, 2);
        }
        return this.m_pathInfo;
    }

    private void buildNewGDURL(String pathInfo, String reportURL) throws CAFException {
        String unwrapReportURL = CAFValidator.unwrapSignature(reportURL, null);
        StringBuffer newPathInfo = new StringBuffer(1024);
        newPathInfo.append("/gd/");
        newPathInfo.append(unwrapReportURL);
        int endSlash = pathInfo.indexOf("/", 4);
        if (endSlash > -1) {
            String last = pathInfo.substring(endSlash);
            newPathInfo.append(last);
        }
        this.m_pathInfo = newPathInfo.toString();
        if (CAFLog.isTracingEnabled) {
            CAFLog.trace("modified path info", "PATH_INFO", newPathInfo.toString(), 30000, "request");
        }
    }

    public void setAction(String action) throws CAFRuntimeException {
        try {
            this.m_action = action;
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("setAction()", "action", this.m_action, 30000, "request");
            }
        }
        catch (Exception e) {
            CAFExceptionUtilities.handleException(e, 4);
        }
    }

    private static boolean _checkSecureState(String secureStateToken, String passport) throws CAFException {
        try {
            boolean res = false;
            SecureStateSession sss = null;
            try {
                sss = CAFFactoryImpl.camFactory.createSecureStateSession(passport.getBytes("UTF-8"), secureStateToken.getBytes("UTF-8"));
                res = sss.verifySecureStateToken();
            }
            catch (CAMCryptoException e) {
                CAFLog.error("CAM secure state verify failed", "message", e.getMessage());
            }
            if (res) {
                try {
                    res = sss.getRequestValidated();
                }
                catch (CAMCryptoException e) {
                    CAFLog.error("CAM get request validated failed", "message", e.getMessage());
                    res = false;
                }
                if (!res) {
                    CAFLog.error("secure state with false request validated");
                }
            } else {
                CAFLog.error("invalid secure state");
            }
            if (!res) {
                CAFLog.error("check secure state failed", "secure state", secureStateToken, "passport", passport);
            }
            return res;
        }
        catch (Exception e) {
            throw new CAFFirewallException(e, 16);
        }
    }

    private static boolean _validSecureState(String ssToken, String passport) throws CAFValidationException, CAFException {
        boolean res = false;
        if (ssToken != null && passport != null) {
            if (!CAFHandlerImpl._checkSecureState(ssToken, passport)) {
                throw new CAFValidationException();
            }
            res = true;
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("valid secure state found", "secure state token", ssToken, 30000, "request");
            }
        }
        return res;
    }

    private boolean validateCookies(BIBusEnvelope bbEnv) throws CAFException {
        boolean valid = true;
        HdrSession hdrSession = bbEnv.getBiBusHeader().getHdrSession();
        CookieVars cookieVars = hdrSession.getCookieVars();
        Set cookieNames = cookieVars.getNames();
        for (String cookieName : cookieNames) {
            String cookieValue = cookieVars.getValue(cookieName);
            if (cookieName == null || cookieValue == null) continue;
            CAFValidationData valData = new CAFValidationData();
            valData.name = cookieName;
            valData.value = cookieValue;
            if (valData.name == null) continue;
            if (valData.value == null) {
                valData.value = new String();
            }
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("validateCookies()", "name", valData.name, "value", valData.value, 10000, "request");
            }
            if (CAFValidator.validateCookie(valData, this.m_requestObject)) continue;
            valid = false;
            break;
        }
        if (!valid) {
            CAFLog.error("validate cookies failed");
        }
        return valid;
    }

    private static boolean validateFormFieldVars(BIBusEnvelope bbEnv, CAFRequestObject requestObject) throws CAFException {
        boolean valid = true;
        List values = bbEnv.getFormFieldValues();
        if (values != null) {
            Iterator valuesIterator = values.iterator();
            NameValuePair nvp = null;
            CAFValidationData valData = new CAFValidationData();
            while (valuesIterator.hasNext()) {
                nvp = (NameValuePair)valuesIterator.next();
                valData.reset();
                valData.name = nvp.getName();
                valData.value = nvp.getValue();
                if (CAFLog.isTracingEnabled) {
                    CAFLog.trace("validateFormFieldVars()", "name", valData.name, "value", valData.value, 10000, "request");
                }
                if (CAFValidator.validateVariable(valData, requestObject)) continue;
                valid = false;
                break;
            }
        }
        if (!valid) {
            CAFLog.error("validate form field variables failed", "form fields variables", bbEnv.getFormFieldVars().asXML());
        }
        return valid;
    }

    private static boolean _checkReportURL(String reportURL, CAFRequestObject requestObject) throws CAFException {
        boolean valid = true;
        if (reportURL != null) {
            valid = CAFValidator.unwrapAndCheckSignature(reportURL, null, requestObject.getPassport(), requestObject.getSigningSession(), requestObject.getCAFCookie(), false, false);
        }
        if (!valid) {
            CAFLog.error("invalid report URL in path info", "report URL", reportURL);
        }
        return valid;
    }

    private boolean _checkForValidationBypass(BIBusEnvelope bbEnv) throws CAFException {
        boolean res = false;
        if (this.m_action != null && CAFPatternCache.matchByPatternName(this.m_action, PATTERN_BYPASS_ACTIONS)) {
            res = this.m_action.equals("xts.run") ? this._checkBypassXTSRUN(bbEnv, res) : (this.m_action.equals("wsrp") ? this._checkBypassWSRP(res) : true);
            if (CAFLog.isTracingEnabled && res) {
                CAFLog.trace("validation bypassed because of action match", "action", this.m_action, 30000, "request");
            }
        }
        return res;
    }

    private boolean _checkBypassWSRP(boolean res) throws CAFException {
        if (this.m_pathInfo != null && CAFPatternCache.matchByPatternName(this.m_pathInfo, PATTERN_BYPASS_PATH_INFOS)) {
            res = true;
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("path info used in validation bypass", "path info", this.m_pathInfo, 10000, "request");
            }
        }
        return res;
    }

    private boolean _checkBypassXTSRUN(BIBusEnvelope bbEnv, boolean res) throws CAFException {
        String m = bbEnv.getFormValue("m");
        if (m != null) {
            if (m.equals("portal/goto.xts")) {
                res = true;
            }
            if (CAFLog.isTracingEnabled && res) {
                CAFLog.trace("m parameter used in validation bypass", "m", m, 10000, "request");
            }
        }
        return res;
    }

    private static void _checkTPSessionHeaders(BIBusEnvelope bbEnv, CAFRequestObject requestObject) throws CAFRuntimeException {
        try {
            String shadow;
            String passport = requestObject.getPassport();
            CAFCookie cafCookie = requestObject.getCAFCookie();
            if (cafCookie != null) {
                cafCookie.validateAndExtract(passport, requestObject.getSigningSession());
            }
            String tpSession = requestObject.getTPSession();
            if (!(passport == null || tpSession == null || cafCookie == null || (shadow = cafCookie.tpSessionShadow()) != null && tpSession.equals(shadow))) {
                if (CAFLog.isTracingEnabled) {
                    CAFLog.trace("third party session does not match shadowed session", "third party session", tpSession, "shadow", shadow, 50000, "request");
                }
                CookieVars cookieVars = bbEnv.getBiBusHeader().getHdrSession().getCookieVars();
                cookieVars.remove("cam_passport");
                cookieVars.remove("cc_session");
            }
        }
        catch (Exception e) {
            CAFExceptionUtilities.handleException(e, 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateSOAPEnvelope(BIBusEnvelope bbEnv, boolean isXML) throws CAFRuntimeException {
        try {
            if (bbEnv == null) {
                throw new CAFHandlerException(8);
            }
            if (CAFLog.isTracingEnabled) {
                String s = "validateSOAPEnvelope()";
                CAFLog.trace("validateSOAPEnvelope()", "XML request", String.valueOf(isXML), 30000, "request");
                CAFLog.trace("validateSOAPEnvelope()", "BI-Bus envelope", bbEnv.getAsString(), 10000, "request");
            }
            this.m_requestObject = new CAFRequestObject(bbEnv, isXML, this.m_getRequest);
            boolean done = false;
            if (CAFHandlerImpl._validSecureState(this.m_requestObject.getSecureStateToken(), this.m_requestObject.getPassport())) {
                done = true;
                if (CAFLog.isTracingEnabled) {
                    CAFLog.trace("update SOAP envelope bypassed because of valid secure state", 30000);
                }
            }
            if (!done) {
                done = this._checkForValidationBypass(bbEnv);
            }
            if (!done) {
                if (this.m_requestObject.getPassport() != null && !this.m_requestObject.checkContextId(this.m_externalRequest)) {
                    throw new CAFValidationException();
                }
                if (CAFConfig.m_tpSessionHeader != null) {
                    CAFHandlerImpl._checkTPSessionHeaders(bbEnv, this.m_requestObject);
                }
            }
            if (!done) {
                this.applyCAFInputValidation(bbEnv, isXML);
            }
            if (!done) {
                done = Boolean.getBoolean("disableXSRFCheck");
            }
            if (done) return;
            String ppClientCaf = null;
            String htsClientCaf = null;
            String mPNotificationEMail = null;
            String mValue = null;
            String psNavSourceValue = null;
            String prevPsNavSrc = null;
            String iFrmcmd = null;
            String psNavOp = null;
            String mClass = null;
            String mNewClass = null;
            CAFLog.trace("updateSOAPEnvelope() dumping SOAP request: " + bbEnv.getAsString(), 10000);
            List values = bbEnv.getFormFieldValues();
            if (values != null) {
                Iterator valuesIterator = values.iterator();
                NameValuePair nvp = null;
                while (valuesIterator.hasNext()) {
                    nvp = (NameValuePair)valuesIterator.next();
                    String name = nvp.getName();
                    String value = nvp.getValue();
                    if (name.equalsIgnoreCase("pp_client_caf")) {
                        ppClientCaf = value;
                        CAFLog.trace("updateSOAPEnvelope() found pp_client_caf token in FormFields: " + ppClientCaf, 10000);
                        break;
                    }
                    if (name.equalsIgnoreCase("hts_client_caf")) {
                        htsClientCaf = value;
                        CAFLog.trace("updateSOAPEnvelope() found hts_client_caf token in FormFields: " + htsClientCaf, 10000);
                        break;
                    }
                    if (name.equalsIgnoreCase("m_p_notificationEMail")) {
                        mPNotificationEMail = value;
                        CAFLog.trace("updateSOAPEnvelope() found m_p_notificationEMail in FormFields: " + mPNotificationEMail, 10000);
                        continue;
                    }
                    if (name.equalsIgnoreCase("m")) {
                        mValue = value;
                        CAFLog.trace("updateSOAPEnvelope() found m in FormFields: " + mValue, 10000);
                        continue;
                    }
                    if (name.equalsIgnoreCase("ps_nav_source")) {
                        psNavSourceValue = value;
                        CAFLog.trace("updateSOAPEnvelope() found ps_nav_source in FormFields: " + psNavSourceValue, 10000);
                        continue;
                    }
                    if (name.equalsIgnoreCase("prev_ps_nav_src")) {
                        prevPsNavSrc = value;
                        CAFLog.trace("updateSOAPEnvelope() found prev_ps_nav_src in FormFields: " + prevPsNavSrc, 10000);
                        continue;
                    }
                    if (name.equalsIgnoreCase("ifrmcmd")) {
                        iFrmcmd = value;
                        CAFLog.trace("updateSOAPEnvelope() found ifrmcmd in FormFields: " + iFrmcmd, 10000);
                        continue;
                    }
                    if (name.equalsIgnoreCase("ps_nav_op")) {
                        psNavOp = value;
                        CAFLog.trace("updateSOAPEnvelope() found ps_nav_op in FormFields: " + psNavOp, 10000);
                        continue;
                    }
                    if (name.equalsIgnoreCase("m_class")) {
                        mClass = value;
                        CAFLog.trace("updateSOAPEnvelope() found m_class in FormFields: " + mClass, 10000);
                        continue;
                    }
                    if (!name.equalsIgnoreCase("m_new_class")) continue;
                    mNewClass = value;
                    CAFLog.trace("updateSOAPEnvelope() found m_new_class in FormFields: " + mNewClass, 10000);
                }
            }
            boolean bypass = true;
            if (ppClientCaf != null) {
                bypass = false;
            } else if (htsClientCaf != null) {
                bypass = false;
            } else if (mPNotificationEMail != null && mValue != null && mValue.endsWith("submit.xts") && psNavSourceValue != null && psNavSourceValue.endsWith("personal.xts") && prevPsNavSrc != null && prevPsNavSrc.endsWith("general.xts")) {
                bypass = false;
            } else if (iFrmcmd != null && iFrmcmd.equals("create") && psNavOp != null && psNavOp.equals("submit") && mClass != null && mClass.equals("subscriptionFolder") && psNavSourceValue != null && psNavSourceValue.endsWith("new_general.xts") || mNewClass != null && mNewClass.equals("subscriptionFolder") && psNavSourceValue != null && psNavSourceValue.endsWith("new_actions.xts")) {
                bypass = false;
            }
            if (bypass) return;
            String cookieXSRFValue = null;
            HdrSession hdrSession = bbEnv.getBiBusHeader().getHdrSession();
            CookieVars cookieVars = hdrSession.getCookieVars();
            Set cookieNames = cookieVars.getNames();
            for (String cookieName : cookieNames) {
                String cookieValue = cookieVars.getValue(cookieName);
                if (!cookieName.equalsIgnoreCase("XSRF-TOKEN")) continue;
                cookieXSRFValue = cookieValue;
                CAFLog.trace("updateSOAPEnvelope() XSRF token cookie: " + cookieXSRFValue, 10000);
                break;
            }
            if (cookieXSRFValue == null) {
                CAFLog.trace("updateSOAPEnvelope cookieXSRFValue : null", 10000);
                return;
            }
            String headerXSRFValue = null;
            headerXSRFValue = bbEnv.getEnvironmentValue("X-XSRF-TOKEN");
            CAFLog.trace("updateSOAPEnvelope() XSRF token header: " + headerXSRFValue, 10000);
            if (headerXSRFValue == null) {
                CAFLog.error("updateSOAPEnvelope headerXSRFValue : null");
                throw new CAFValidationException();
            }
            if (headerXSRFValue.equals(cookieXSRFValue)) {
                String debugString = "updateSOAPEnvelope() XSRF tokens match - cookie: " + cookieXSRFValue + " header: " + headerXSRFValue;
                CAFLog.trace(debugString, 10000);
                return;
            }
            String errorString = "updateSOAPEnvelope() XSRF tokens do not match - cookie: " + cookieXSRFValue + " header: " + headerXSRFValue;
            CAFLog.error(errorString);
            throw new CAFValidationException();
        }
        catch (Exception e) {
            CAFExceptionUtilities.handleException(e, 9);
        }
    }

    private void applyCAFInputValidation(BIBusEnvelope bbEnv, boolean isXML) throws CAFException, CAFValidationException {
        boolean valid = true;
        if (CAFRules.cookieRules()) {
            valid = this.validateCookies(bbEnv);
        }
        if (valid && this.m_reportURLCopy != null) {
            valid = CAFHandlerImpl._checkReportURL(this.m_reportURLCopy, this.m_requestObject);
        }
        if (valid) {
            if (isXML) {
                if (!CAFRules.validateDocument(bbEnv, this.m_requestObject)) {
                    valid = false;
                }
            } else {
                valid = CAFHandlerImpl.validateFormFieldVars(bbEnv, this.m_requestObject);
            }
        }
        if (!valid) {
            throw new CAFValidationException();
        }
    }

    public Cookie[] getCookiesToSet(String responsePassport) throws CAFRuntimeException {
        Cookie[] res = null;
        try {
            if (this.m_requestObject.isLogoff()) {
                CAFCookie cafCookie = this.m_requestObject.getCAFCookie();
                if (cafCookie == null) {
                    cafCookie = new CAFCookie("");
                    if (CAFLog.isTracingEnabled) {
                        CAFLog.trace("getCookiesToSet()", "Logoff Request - Create New Cookie", "", 10000);
                    }
                }
                cafCookie.update(this.m_requestObject.getPassport(), this.m_requestObject.getSigningSession(), this.m_requestObject.getTPSession());
                String strCookie = cafCookie.toString();
                Cookie c = new Cookie("caf", strCookie);
                c.setMaxAge(0);
                res = new Cookie[]{c};
                if (CAFLog.isTracingEnabled) {
                    CAFLog.trace("getCookiesToSet()", "Logoff Request - Delete Cookie", strCookie, 10000);
                }
            } else {
                String strCAFCookie;
                CAFCookie cafCookie;
                if (CAFLog.isTracingEnabled) {
                    CAFLog.trace("getCookiesToSet()", "response passport", responsePassport, 10000);
                }
                if ((cafCookie = this.m_requestObject.getCAFCookie()) == null) {
                    cafCookie = new CAFCookie();
                }
                cafCookie.update(this.m_requestObject.getPassport(), this.m_requestObject.getSigningSession(), this.m_requestObject.getTPSession());
                Cookie c = null;
                if (responsePassport != null) {
                    cafCookie.resetTPSession();
                    SigningSession signingSession = this.m_requestObject.getSigningSession();
                    if (signingSession == null) {
                        signingSession = CAFFactoryImpl.camFactory.createSigningSession();
                    }
                    cafCookie.update(this.m_requestObject.getPassport(), signingSession, this.m_requestObject.getTPSession());
                }
                if (CAFLog.isTracingEnabled) {
                    CAFLog.trace("getCookiesToSet()", "CAF cookie", cafCookie == null ? null : cafCookie.toString(), "updated", cafCookie == null ? "false" : String.valueOf(cafCookie.updated()), 10000, "request");
                }
                if (cafCookie.updated() && (c = new Cookie("caf", strCAFCookie = cafCookie.toString())) != null) {
                    res = new Cookie[]{c};
                }
            }
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("getCookiesToSet()", "cookie", res == null ? "none" : res[0].getValue(), 10000, "request");
            }
        }
        catch (Exception e) {
            CAFExceptionUtilities.handleException(e, 10);
        }
        return res;
    }

    public String getSecureState() throws CAFRuntimeException {
        String res = null;
        try {
            if (this.m_requestObject == null) {
                throw new CAFHandlerException(3);
            }
            res = this.m_requestObject.getSecureStateToken();
            if (res == null) {
                String passport = this.m_requestObject.getPassport();
                if (CAFLog.isTracingEnabled) {
                    CAFLog.trace("getSecureState()", "passport", passport, 10000, "request");
                }
                if (passport != null) {
                    SecureStateSession sss = CAFFactoryImpl.camFactory.createSecureStateSession(passport.getBytes("UTF-8"));
                    sss.setRequestValidated(true);
                    sss.setRequestExternal(this.m_externalRequest);
                    res = new String(sss.getSecureStateToken(), "UTF-8");
                }
            }
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("getSecureState()", "secure state token", res, 10000, "request");
            }
        }
        catch (Exception e) {
            CAFExceptionUtilities.handleException(e, 11);
        }
        return res;
    }

    public boolean getExternal() {
        return this.m_externalRequest;
    }

    public String dropGlobalParameters(String search) {
        int length;
        StringBuffer returnValue = null;
        returnValue = search == null ? new StringBuffer() : new StringBuffer(search);
        if (search != null && (length = search.length()) > 0) {
            String temp = search.toLowerCase();
            int start = temp.indexOf(GLOBAL_PARAMETERS.toLowerCase());
            if (start == -1) {
                return search;
            }
            int nextParam = search.indexOf(38, start);
            if (start != 0) {
                --start;
            }
            if (nextParam != -1) {
                if (start == 0 && nextParam != length - 1) {
                    ++nextParam;
                }
            } else {
                nextParam = length;
            }
            returnValue.replace(start, nextParam, "");
        }
        return returnValue.toString();
    }
}

