/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf;

import com.cognos.caf.CAFExceptionUtilities;
import com.cognos.caf.CAFLibraryException;
import com.cognos.caf.CAFLibraryPrivateException;
import com.cognos.caf.CAFProtector;
import com.cognos.caf.CAFSecureErrorHandler;
import com.cognos.caf.CAFValidator;
import com.cognos.caf.cache.CAFACLCapabilityCache;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.common.CAFGlobals;
import com.cognos.caf.config.CAFConfig;
import com.cognos.caf.logging.CAFLog;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.HashSet;

public class CAFLibrary {
    private static boolean m_initialized = false;

    protected static void initialize() {
        m_initialized = true;
    }

    public static String secureError(String errorDetails, String passport) throws CAFLibraryException {
        try {
            if (!m_initialized) {
                throw new CAFLibraryPrivateException(0);
            }
            CAFLog.trace("library - secure error", "error details", errorDetails, "passport", passport, 50000, "library");
            String res = null;
            if (CAFConfig.m_secureError && (passport == null || !CAFSecureErrorHandler.canReceiveDetailedErrors(passport))) {
                res = CAFProtector.generateSecureErrorId();
                CAFProtector.logSecureError(res, errorDetails);
            }
            return res;
        }
        catch (CAFException e) {
            CAFExceptionUtilities.handleLibraryException(e, 2, true);
            return null;
        }
    }

    public static String secureError(String errorDetails, BIBusEnvelope env) throws CAFLibraryException {
        try {
            if (!m_initialized) {
                throw new CAFLibraryPrivateException(0);
            }
            CAFLog.trace("library - secure error", "error details", errorDetails, 50000, "library");
            String res = null;
            if (CAFConfig.m_secureError && (env == null || !CAFSecureErrorHandler.canReceiveDetailedErrors(env))) {
                res = CAFProtector.generateSecureErrorId();
                CAFProtector.logSecureError(res, errorDetails);
            }
            return res;
        }
        catch (CAFException e) {
            CAFExceptionUtilities.handleLibraryException(e, 2, true);
            return null;
        }
    }

    public static String tpXSSEncode(String getData) throws CAFLibraryException {
        try {
            if (!m_initialized) {
                throw new CAFLibraryPrivateException(0);
            }
            if (getData == null) {
                throw new CAFLibraryPrivateException(3);
            }
            String res = getData;
            if (CAFConfig.m_tpXSSCheckingUsed && (getData.indexOf(37) != -1 || CAFProtector.containsXSSChar(getData, null))) {
                res = CAFProtector.wrapAndXSSEncode(getData);
            }
            return res;
        }
        catch (CAFException e) {
            CAFExceptionUtilities.handleLibraryException(e, 5, true);
            return null;
        }
    }

    public static String getJavascriptConfig() throws CAFLibraryException {
        try {
            if (!m_initialized) {
                throw new CAFLibraryPrivateException(0);
            }
            return CAFProtector.getJavascriptConfig();
        }
        catch (CAFException e) {
            CAFExceptionUtilities.handleLibraryException(e, 6, true);
            return null;
        }
    }

    public static String signAndWrap(String data, String passport) throws CAFLibraryException {
        try {
            if (!m_initialized) {
                throw new CAFLibraryPrivateException(0);
            }
            if (passport == null || passport.length() == 0) {
                throw new CAFLibraryPrivateException(9);
            }
            String res = data;
            if (CAFConfig.m_validationEnabled) {
                res = CAFProtector.signAndWrap(data, passport, null);
            }
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("library - signAndWrap()", "data", data, "passport", passport, 10000, "library");
                CAFLog.trace("library - signAndWrap()", "returned value", res, 10000, "library");
            }
            return res;
        }
        catch (CAFException e) {
            CAFExceptionUtilities.handleLibraryException(e, 7, true);
            return null;
        }
    }

    public static String unwrapSignature(String data) throws CAFLibraryException {
        try {
            if (!m_initialized) {
                throw new CAFLibraryPrivateException(0);
            }
            String res = data;
            if (CAFConfig.m_validationEnabled) {
                res = "";
                if (data.length() > 0) {
                    res = CAFValidator.unwrapSignature(data, null);
                }
            }
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("library - unwrapSignature()", "data", data, "returned value", res, 10000, "library");
            }
            return res;
        }
        catch (CAFException e) {
            CAFExceptionUtilities.handleLibraryException(e, 8, true);
            return null;
        }
    }

    public static boolean checkURLHostDomain(String url) throws CAFLibraryException {
        try {
            if (CAFConfig.m_validationEnabled) {
                if (!m_initialized) {
                    throw new CAFLibraryPrivateException(0);
                }
                return CAFValidator.checkURLHostDomain(url);
            }
            return true;
        }
        catch (CAFException e) {
            CAFExceptionUtilities.handleLibraryException(e, 4, true);
            return false;
        }
    }

    public static boolean isSafeURL(String url) throws CAFLibraryException {
        try {
            if (CAFConfig.m_validationEnabled) {
                if (!m_initialized) {
                    throw new CAFLibraryPrivateException(0);
                }
                return CAFValidator.isSafeURL(url);
            }
            return true;
        }
        catch (CAFException e) {
            CAFExceptionUtilities.handleLibraryException(e, 4, true);
            return false;
        }
    }

    public static HashSet getCachedCapabilities(String passport) throws CAFLibraryException {
        try {
            if (!m_initialized) {
                throw new CAFLibraryPrivateException(0);
            }
            return CAFACLCapabilityCache.staticGetCapabilities(passport, true);
        }
        catch (CAFException e) {
            boolean log = true;
            Exception cause = e.getRootCause();
            if (cause != null && cause instanceof SoapFaultException) {
                try {
                    CAFLog.trace("library - get cached capabilities - cause is SOAP fault exception", 10000, "library");
                }
                catch (CAFException cAFException) {
                    // empty catch block
                }
                log = false;
            }
            CAFExceptionUtilities.handleLibraryException(e, 11, log);
            return null;
        }
    }

    public static String getContextId(String component, String passport) throws CAFLibraryException {
        try {
            if (!m_initialized) {
                throw new CAFLibraryPrivateException(0);
            }
            if (passport == null || passport.length() == 0) {
                throw new CAFLibraryPrivateException(9);
            }
            if (component == null || !CAFGlobals.checkComponentName(component)) {
                throw new CAFLibraryPrivateException(13);
            }
            return CAFProtector.getContextId(component, passport, null);
        }
        catch (CAFException e) {
            CAFExceptionUtilities.handleLibraryException(e, 12, true);
            return null;
        }
    }
}

