/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf;

import com.cognos.caf.common.CAFException;
import com.cognos.caf.logging.CAFLog;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CAFMessageStrings {
    private static CAFMessageStrings m_instance = new CAFMessageStrings();
    private static final String DISP_MESSAGE_FILE = "DispatcherMessages";
    private static final String CAF_MESSAGE_FILE = "cafjMessages";
    private static HashMap m_bundles = new HashMap();
    private static Object m_mutex = new Object();

    public static CAFMessageStrings get() {
        return m_instance;
    }

    public String getString(String msgId, Locale locale) throws CAFException {
        String msg = this.getMessage(msgId, CAF_MESSAGE_FILE, locale);
        if (msgId.equalsIgnoreCase(msg)) {
            msg = this.getMessage(msgId, DISP_MESSAGE_FILE, locale);
        }
        return msg;
    }

    public String getString(String msgId, String localeStr) throws CAFException {
        return this.getString(msgId, this.parseLocale(localeStr));
    }

    private CAFMessageStrings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getBundle(String msgFile, Locale locale) throws MissingResourceException, CAFException {
        String la = locale.getLanguage();
        String co = locale.getCountry();
        String key = msgFile + "_" + la + "_" + co.toUpperCase();
        Object object = m_mutex;
        synchronized (object) {
            Object rb = m_bundles.get(key);
            if (rb == null) {
                try {
                    rb = ResourceBundle.getBundle(msgFile, locale);
                }
                catch (MissingResourceException e) {
                    CAFLog.error("Missing message file " + msgFile);
                    throw e;
                }
                m_bundles.put(key, rb);
            }
            return (ResourceBundle)rb;
        }
    }

    private String getMessage(String msgId, String msgFile, Locale locale) throws CAFException {
        String msg;
        try {
            ResourceBundle rb = this.getBundle(msgFile, locale);
            msg = MessageFormat.format(rb.getString(msgId), 0);
        }
        catch (MissingResourceException e) {
            CAFLog.error("Missing message id " + msgId);
            msg = msgId;
        }
        return msg;
    }

    private Locale parseLocale(String localeStr) {
        int dash = localeStr.indexOf(45);
        String la = "";
        String co = "";
        if (dash != -1) {
            la = localeStr.substring(0, dash);
            co = localeStr.substring(dash + 1, localeStr.length());
        } else {
            la = localeStr;
        }
        return new Locale(la, co);
    }
}

