/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf;

import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.caf.CAFCookie;
import com.cognos.caf.CAFFactoryImpl;
import com.cognos.caf.CAFFirewallException;
import com.cognos.caf.CAFPatternCache;
import com.cognos.caf.CAFValidator;
import com.cognos.caf.cache.CAFACLCapabilityCache;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.common.CAFGlobals;
import com.cognos.caf.common.CAFValidationException;
import com.cognos.caf.config.CAFConfig;
import com.cognos.caf.logging.CAFLog;
import com.cognos.ccl4j.bibus.CAMCookie;
import com.cognos.ccl4j.bibus.CAMCookieFactory;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.BiBusHeader;
import com.cognos.pogo.pdk.common.Caf;
import com.cognos.pogo.pdk.common.Cam;
import java.util.StringTokenizer;

public class CAFRequestObject {
    private static final String QS_PATTERN = "(\\./|/)?((qs/.{1,500})|(async/conv))\\.xts$";
    private static final String ES_PATTERN = "(\\./|/)?(ags/.{1,500})\\.xts$";
    private static final String PARAM_CONTEXT_ID = "cafcontextid";
    private static final String PARAM_ALTERNATE_CONTEXT_ID = "ui.cafcontextid";
    private static final String PARAM_M = "m";
    private static final int MAX_PASSPORT_LENGTH = 94;
    public static final String m_CONTEXT_ID_SEPARATOR = "|";
    private boolean m_getRequest = false;
    private String m_passport = null;
    private SigningSession m_signingSession;
    private CAFCookie m_cafCookie = null;
    private String m_tpSession = null;
    private String m_unwrapContextId = null;
    private String m_secureStateToken = null;
    private String m_contextId = null;
    private BIBusEnvelope m_bbEnv = null;
    private String m_mParam = null;
    private boolean m_xmlRequest = false;
    private boolean m_isLogoffAction = false;

    private void _extractXMLContext(BiBusHeader biBusHeader) throws CAFException {
        if (biBusHeader != null) {
            Caf caf = biBusHeader.getCaf();
            if (caf != null) {
                String contextId;
                String secureState;
                if (CAFLog.isTracingEnabled) {
                    CAFLog.trace("CAF element found", "CAF element", caf.asXML(), 10000);
                }
                if ((secureState = caf.getSecureState()) != null && !"nil".equalsIgnoreCase(secureState)) {
                    this.m_secureStateToken = secureState;
                    if (this.m_secureStateToken.length() != 0 && CAFLog.isTracingEnabled) {
                        CAFLog.trace("secure state found", "secure state token", this.m_secureStateToken, 10000);
                    }
                }
                if ((contextId = caf.getContextID()) != null && !"nil".equalsIgnoreCase(contextId)) {
                    this.m_contextId = contextId;
                    if (this.m_contextId.length() == 0) {
                        this.m_contextId = null;
                    } else if (CAFLog.isTracingEnabled) {
                        CAFLog.trace("XML context id found", "context id", this.m_contextId, 10000);
                    }
                }
            } else if (CAFLog.isTracingEnabled) {
                CAFLog.trace("CAF element not found", 10000, this.getClass().getName());
            }
        }
    }

    private void _checkCAMAction(BiBusHeader biBusHeader, String passport) throws CAFException {
        String strAction;
        Cam cam;
        if (biBusHeader != null && passport != null && (cam = biBusHeader.getCam()) != null && (strAction = cam.getAction()) != null && (strAction.startsWith("logon") || strAction.equals("logoff"))) {
            this._isLogoff(strAction);
            CAFACLCapabilityCache.staticFlushCapabilities(passport);
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("CAM action triggered capability cache flush", "action", strAction, "passport", passport, 10000);
            }
        }
    }

    private void _isLogoff(String Action) {
        if (Action.equals("logoff")) {
            this.m_isLogoffAction = true;
        }
    }

    public boolean isLogoff() {
        return this.m_isLogoffAction;
    }

    private void _extractFormContext() throws CAFException {
        this.m_contextId = this.m_bbEnv.getFormValue(PARAM_CONTEXT_ID);
        if (this.m_contextId == null) {
            this.m_contextId = this.m_bbEnv.getFormValue(PARAM_ALTERNATE_CONTEXT_ID);
        }
        if (CAFLog.isTracingEnabled && this.m_contextId != null) {
            CAFLog.trace("form context id found", "context id", this.m_contextId, 10000);
        }
        this.m_mParam = this.m_bbEnv.getFormValue(PARAM_M);
        if (CAFLog.isTracingEnabled && this.m_mParam != null) {
            CAFLog.trace("m parameter found", PARAM_M, this.m_mParam, 10000);
        }
    }

    private void _extractCAFCookie(BIBusEnvelope bbEnv) throws CAFException {
        String strCAFCookie = bbEnv.getCookieValue("caf");
        if (strCAFCookie != null) {
            this.m_cafCookie = new CAFCookie(strCAFCookie);
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("CAF cookie found", "CAF cookie", strCAFCookie, 10000);
            }
            if (CAFConfig.m_tpSessionHeader != null) {
                // empty if block
            }
        }
    }

    CAFRequestObject(BIBusEnvelope bbEnv, boolean xmlRequest, boolean getRequest) throws CAFException, CAFValidationException {
        this.m_getRequest = getRequest;
        this.m_bbEnv = bbEnv;
        this.m_passport = this.m_bbEnv.checkAuthenticated();
        this.m_xmlRequest = xmlRequest;
        if (CAFLog.isTracingEnabled) {
            String s = "CAFRequestObject constructor";
            CAFLog.trace(s, "XML request", String.valueOf(this.m_xmlRequest), "GET request", String.valueOf(this.m_getRequest), 10000);
            CAFLog.trace(s, "passport", this.m_passport, 10000);
        }
        if (this.m_passport != null && this.m_passport.length() > 94) {
            CAFLog.error("passport length greater than allowed maximum", "passport length", String.valueOf(this.m_passport.length()), "maximum", String.valueOf(94));
            throw new CAFValidationException();
        }
        try {
            CAMCookie cookie = CAMCookieFactory.createCAMCookie((String)this.m_passport);
            this.m_passport = cookie.getPassportID();
        }
        catch (Exception e) {
            CAFLog.error("CAMCookie constructor error");
            throw new CAFValidationException();
        }
        try {
            this.m_signingSession = CAFFactoryImpl.camFactory.createSigningSession();
        }
        catch (Exception e) {
            throw new CAFFirewallException(e, 61);
        }
        BiBusHeader biBusHeader = bbEnv.getBiBusHeader();
        if (xmlRequest) {
            this._extractXMLContext(biBusHeader);
        } else {
            this._extractFormContext();
        }
        this._extractCAFCookie(bbEnv);
        this._checkCAMAction(biBusHeader, this.m_passport);
        if (CAFConfig.m_tpSessionHeader != null) {
            String tpSession = null;
            tpSession = CAFConfig.m_tpSessionHeader.equalsIgnoreCase("REMOTE_USER") ? bbEnv.getEnvironmentValue(CAFConfig.m_tpSessionHeader) : bbEnv.getEnvironmentValue("HTTP_" + CAFConfig.m_tpSessionHeader);
            this.m_tpSession = tpSession;
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("CAFRequestObject constructor", "third party session header", CAFConfig.m_tpSessionHeader, "third party session", this.m_tpSession, 50000, "request");
            }
        }
    }

    public boolean checkSignatureAndUnwrapContextId(String contextId) throws CAFException {
        try {
            boolean res = true;
            if (contextId != null) {
                if (contextId.length() == 0) {
                    CAFLog.error("invalid length 0 context id");
                    res = false;
                } else {
                    StringBuffer buf = new StringBuffer(64);
                    res = CAFValidator.unwrapAndCheckSignature(contextId, buf, this.m_passport, this.getSigningSession(), this.m_cafCookie, true, false);
                    StringTokenizer st = null;
                    if (res) {
                        st = new StringTokenizer(buf.toString(), m_CONTEXT_ID_SEPARATOR);
                        if (st.countTokens() != 2) {
                            res = false;
                            CAFLog.error("context id must contain two tokens separated by the '|' character", "buffer", buf.toString());
                        }
                    } else {
                        CAFLog.error("context id signature check failed", "unwrap context id", buf.toString());
                    }
                    if (res && !(res = CAFValidator.checkTimestamp(st.nextToken()))) {
                        CAFLog.error("context id timestamp check failed");
                    }
                    if (res) {
                        this.m_unwrapContextId = st.nextToken();
                    }
                }
            }
            if (res && !CAFGlobals.checkComponentName(this.m_unwrapContextId)) {
                res = false;
                CAFLog.error("context id with invalid component", "component", this.m_unwrapContextId);
                this.m_unwrapContextId = null;
            }
            if (!res) {
                CAFLog.error("invalid context id", "context id", contextId);
            }
            return res;
        }
        catch (Exception e) {
            throw new CAFFirewallException(e, 60);
        }
    }

    private String _determineContext() throws CAFException, CAFValidationException {
        String res = null;
        if (this.m_xmlRequest) {
            res = this.m_unwrapContextId;
        } else if (this.m_mParam != null) {
            if (CAFPatternCache.find(this.m_mParam, QS_PATTERN)) {
                res = "qs";
            } else if (CAFPatternCache.find(this.m_mParam, ES_PATTERN)) {
                res = "es";
            }
        } else if ("ps".equals(this.m_unwrapContextId)) {
            res = "ps";
        } else if (!"cmm".equals(this.m_unwrapContextId) && "icd".equals(this.m_unwrapContextId)) {
            res = "icd";
        }
        if (CAFLog.isTracingEnabled) {
            CAFLog.trace("determineContext()", "context", res, 10000);
        }
        return res;
    }

    private boolean _contextIdRequired(String context, boolean externalRequest) throws CAFException {
        try {
            boolean res = false;
            if (this.m_xmlRequest) {
                if (externalRequest) {
                    res = true;
                }
            } else if (context != null) {
                res = true;
            }
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("isContextIdRequired()", "required", String.valueOf(res), 10000);
            }
            return res;
        }
        catch (Exception e) {
            throw new CAFFirewallException(e, 54);
        }
    }

    public boolean checkContextId(boolean requestExternal) throws CAFValidationException, CAFException {
        boolean res = true;
        if (this.m_contextId != null) {
            res = this._isContextIDValid();
        }
        String context = this._determineContext();
        if (res && this._contextIdRequired(context, requestExternal)) {
            if (this.m_unwrapContextId == null) {
                CAFLog.error("null context id");
                res = false;
            } else {
                if (context == null) {
                    CAFLog.error("null context");
                    res = false;
                } else {
                    res = this._isKnownContext(context);
                }
                if (!res) {
                    CAFLog.error("invalid context id for context", "unwrap context id", this.m_unwrapContextId, "context", context);
                }
            }
        }
        if (!res) {
            CAFLog.error("check context id failed");
        }
        return res;
    }

    private boolean _isContextIDValid() throws CAFException {
        boolean res = false;
        if (this.checkSignatureAndUnwrapContextId(this.m_contextId)) {
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("valid context id found", "context id", this.m_contextId, "unwrap context id", this.m_unwrapContextId, 30000);
            }
            res = true;
        } else {
            res = false;
        }
        return res;
    }

    private boolean _isKnownContext(String context) throws CAFException {
        boolean res;
        if (context.equals("es")) {
            res = this.m_unwrapContextId.equals(context);
        } else if (context.equals("ans")) {
            res = this.m_unwrapContextId.equals(context);
        } else if (context.equals("qs")) {
            res = this.m_unwrapContextId.equals(context);
        } else if (context.equals("rs")) {
            res = this.m_unwrapContextId.equals(context);
        } else if (context.equals("ps")) {
            res = this.m_unwrapContextId.equals("ps");
        } else if (context.equals("pc")) {
            res = this.m_unwrapContextId.equals("pc");
        } else if (context.equals("pp")) {
            res = this.m_unwrapContextId.equals("pp");
        } else if (context.equals("aa")) {
            res = this.m_unwrapContextId.equals("aa");
        } else if (context.equals("cmm")) {
            res = this.m_unwrapContextId.equals("cmm");
        } else if (context.equals("icd")) {
            res = this.m_unwrapContextId.equals("icd");
        } else if (context.equals("viz")) {
            res = this.m_unwrapContextId.equals("viz");
        } else if (context.equals("rv")) {
            res = this.m_unwrapContextId.equals("rv");
        } else {
            CAFLog.error("unknown context", "context", context);
            res = false;
        }
        return res;
    }

    public SigningSession getSigningSession() {
        return this.m_signingSession;
    }

    public String getPassport() {
        return this.m_passport;
    }

    public void setCAFCookie(CAFCookie cafCookie) {
        this.m_cafCookie = cafCookie;
    }

    public CAFCookie getCAFCookie() {
        return this.m_cafCookie;
    }

    public String getTPSession() {
        return this.m_tpSession;
    }

    public boolean getRequest() {
        return this.m_getRequest;
    }

    public String getSecureStateToken() {
        return this.m_secureStateToken;
    }

    public String getUnwrapContextId() {
        return this.m_unwrapContextId;
    }
}

