/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf;

import com.cognos.caf.CAFActionHandlerData;
import com.cognos.caf.CAFBlock;
import com.cognos.caf.CAFIActionHandler;
import com.cognos.caf.CAFParseContext;
import com.cognos.caf.CAFProtectorException;
import com.cognos.caf.CAFTextBlock;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.logging.CAFLog;
import java.util.ArrayList;
import java.util.Vector;

class CAFTagBlock
implements CAFBlock {
    protected static final int eUnknown = 0;
    protected static final int eOpenTag = 1;
    protected static final int eText = 2;
    protected static final int eCloseTag = 3;
    protected static final int eEOI = 4;
    private static final String AFPROTECT_COMMON_PART = "__caf";
    private static final String AFPROTECT_START_PART = "start_";
    private static final String AFPROTECT_END_PART = "end__";
    private static final String AFPROTECT_OPEN = "__cafstart_";
    private static final String AFPROTECT_CLOSE = "__cafend__";
    String m_s;
    ArrayList m_childBlocks = new ArrayList();
    Vector m_actions = null;
    Vector m_values = null;

    CAFTagBlock(String s, Vector actions, Vector values) {
        this.m_s = s;
        this.m_actions = actions;
        this.m_values = values;
    }

    public boolean hasProtectionBlock() {
        for (int i = 0; i < this.m_childBlocks.size(); ++i) {
            if (!(this.m_childBlocks.get(i) instanceof CAFTagBlock)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String protect(CAFIActionHandler actionHandler, CAFActionHandlerData ahd) throws CAFException {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.m_childBlocks.size(); ++i) {
            CAFBlock b = (CAFBlock)this.m_childBlocks.get(i);
            s.append(b.protect(actionHandler, ahd));
        }
        if (this.m_actions != null && this.m_actions.size() > 0) {
            return actionHandler.doActions(s.toString(), this.m_actions, this.m_values, ahd);
        }
        return s.toString();
    }

    public static int parseActions(String s, int startIdx, int endIdx, Vector actions, Vector values, CAFParseContext ctx) throws CAFProtectorException {
        block3: {
            int idx;
            do {
                String value;
                if ((idx = s.indexOf(95, startIdx)) == -1) {
                    throw new CAFProtectorException(2);
                }
                String action = s.substring(startIdx, idx);
                actions.add(action);
                startIdx = idx + 1;
                idx = s.indexOf(95, startIdx);
                if (idx == -1) {
                    value = s.substring(startIdx);
                    values.add(value);
                    startIdx = endIdx;
                    break block3;
                }
                value = s.substring(startIdx, idx);
                values.add(value);
            } while (s.charAt(startIdx = idx + 1) != '_');
            ++startIdx;
        }
        return startIdx;
    }

    private int nexttag(String s, int startIdx, int endIdx, CAFParseContext ctx) throws CAFException {
        if (ctx.m_nexttoken != 0) {
            ctx.m_token = ctx.m_nexttoken;
            ctx.m_nexttoken = 0;
            return ctx.m_nextindex;
        }
        ctx.m_token = 0;
        int tagidx = startIdx;
        while (tagidx < endIdx && (tagidx = s.indexOf(AFPROTECT_COMMON_PART, tagidx)) != -1 && tagidx + AFPROTECT_COMMON_PART.length() < s.length()) {
            if (s.charAt(tagidx + AFPROTECT_COMMON_PART.length()) == 's' && s.indexOf(AFPROTECT_START_PART, tagidx + AFPROTECT_COMMON_PART.length()) != -1) {
                ctx.m_token = 1;
                break;
            }
            if (s.charAt(tagidx + AFPROTECT_COMMON_PART.length()) == 'e' && s.indexOf(AFPROTECT_END_PART, tagidx + AFPROTECT_COMMON_PART.length()) != -1) {
                ctx.m_token = 3;
                break;
            }
            tagidx += AFPROTECT_COMMON_PART.length();
        }
        if (ctx.m_token == 0) {
            ctx.m_token = 2;
            return endIdx;
        }
        if (tagidx == startIdx) {
            return tagidx + (ctx.m_token == 1 ? AFPROTECT_OPEN.length() : AFPROTECT_CLOSE.length());
        }
        ctx.m_nexttoken = ctx.m_token;
        ctx.m_nextindex = tagidx + (ctx.m_nexttoken == 1 ? AFPROTECT_OPEN.length() : AFPROTECT_CLOSE.length());
        ctx.m_token = 2;
        return tagidx;
    }

    public int parse(String s, int startIdx, int endIdx, CAFParseContext ctx) throws CAFException {
        block6: while (startIdx < endIdx) {
            int nextIdx = this.nexttag(s, startIdx, endIdx, ctx);
            switch (ctx.m_token) {
                case 1: {
                    CAFLog.trace("parse() - open tag", "start", String.valueOf(startIdx), "end", String.valueOf(endIdx), 10000, "protector");
                    ctx.m_states.push(new Integer(1));
                    Vector actions = new Vector();
                    Vector values = new Vector();
                    startIdx = CAFTagBlock.parseActions(s, nextIdx, endIdx, actions, values, ctx);
                    CAFTagBlock b = new CAFTagBlock(s, actions, values);
                    this.m_childBlocks.add(b);
                    startIdx = b.parse(s, startIdx, endIdx, ctx);
                    continue block6;
                }
                case 3: {
                    if (ctx.m_states.empty()) {
                        throw new CAFProtectorException(6);
                    }
                    Integer sv = (Integer)ctx.m_states.peek();
                    if (sv != 1) {
                        throw new CAFProtectorException(6);
                    }
                    ctx.m_states.pop();
                    return nextIdx;
                }
                case 2: {
                    this.m_childBlocks.add(new CAFTextBlock(s, startIdx, nextIdx));
                    startIdx = nextIdx;
                    continue block6;
                }
                case 4: {
                    startIdx = nextIdx;
                    continue block6;
                }
            }
            throw new CAFProtectorException(7);
        }
        if (!ctx.m_states.empty()) {
            throw new CAFProtectorException(5);
        }
        return startIdx;
    }
}

