/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf.common;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class CAFGlobals {
    public static final String SIGN_PREFIX = "CAFS";
    public static final String SIGN_SALTED_PREFIX = "CAFA";
    public static final String WEB64_PREFIX = "CAFW";
    public static final int MAX_XSS_LENGTH = 256;
    public static final String XSS_START = "XSSSTART";
    public static final String XSS_END = "XSSEND";
    public static final String S7MARKER = "AFDATA";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String AGS_CAPABILITY = "canUseEventStudio";
    public static final String ANS_CAPABILITY = "canUseAnalysisStudio";
    public static final String QS_CAPABILITY = "canUseQueryStudio";
    public static final String RS_CAPABILITY = "canUseReportStudio";
    public static final String PC_CAPABILITY = "canUsePlanningContributor";
    public static final String PA_CAPABILITY = "canUsePlanningAdministration";
    public static final String PP_CAPABILITY = "canUsePowerPlay";
    public static final String DETAILED_ERRORS_CAPABILITY = "canReceiveDetailedErrors";
    public static final String COMPONENT_ANS = "ans";
    public static final String COMPONENT_ES = "es";
    public static final String COMPONENT_PC = "pc";
    public static final String COMPONENT_PS = "ps";
    public static final String COMPONENT_QS = "qs";
    public static final String COMPONENT_RS = "rs";
    public static final String COMPONENT_RV = "rv";
    public static final String COMPONENT_PP = "pp";
    public static final String COMPONENT_AA = "aa";
    public static final String COMPONENT_CMM = "cmm";
    public static final String COMPONENT_ICD = "icd";
    public static final String COMPONENT_VIZ = "viz";
    public static final String COOKIE_CAF = "caf";
    public static final String COOKIE_CC_SESSION = "cc_session";
    public static final String COOKIE_PASSPORT = "cam_passport";
    public static final int EXTENDED_SIGNATURE_HOURS = 72;
    public static final String REMOTE_USER_HEADER = "REMOTE_USER";
    public static final String HEADER_PREFIX = "HTTP_";
    public static final String NIL_ATTRIBUTE = "nil";
    public static byte[] CAF_SIGNATURE_SALT = null;
    private static HashMap<String, String> m_componentNames = new HashMap();

    public static boolean checkComponentName(String name) {
        boolean res = false;
        if (name != null) {
            res = m_componentNames.get(name) != null;
        }
        return res;
    }

    static {
        try {
            CAF_SIGNATURE_SALT = "pepper".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        m_componentNames.put(COMPONENT_ANS, "");
        m_componentNames.put(COMPONENT_ES, "");
        m_componentNames.put(COMPONENT_PC, "");
        m_componentNames.put(COMPONENT_PS, "");
        m_componentNames.put(COMPONENT_QS, "");
        m_componentNames.put(COMPONENT_RS, "");
        m_componentNames.put(COMPONENT_RV, "");
        m_componentNames.put(COMPONENT_PP, "");
        m_componentNames.put(COMPONENT_AA, "");
        m_componentNames.put(COMPONENT_CMM, "");
        m_componentNames.put(COMPONENT_ICD, "");
        m_componentNames.put(COMPONENT_VIZ, "");
    }
}

