/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf.common;

import java.io.ByteArrayOutputStream;

public class CAFWeb64 {
    private static final byte[] encTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 42, 45};
    private static final byte padByte = 95;
    private static final byte[] web64DecodeTable = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 63, 0, 0, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};

    public static byte[] encode(byte[] bytes) {
        int c = 0;
        int rsize = (bytes.length / 3 + 1) * 4;
        ByteArrayOutputStream res = new ByteArrayOutputStream(rsize);
        for (int i = 0; i < bytes.length; ++i) {
            c = bytes[i] >> 2 & 0x3F;
            res.write(encTable[c]);
            c = bytes[i] << 4 & 0x30;
            if (++i < bytes.length) {
                c |= bytes[i] >> 4 & 0xF;
            }
            res.write(encTable[c]);
            if (i < bytes.length) {
                c = bytes[i] << 2 & 0x3C;
                if (++i < bytes.length) {
                    c |= bytes[i] >> 6 & 3;
                }
                res.write(encTable[c]);
            } else {
                ++i;
                res.write(95);
            }
            if (i < bytes.length) {
                c = bytes[i] & 0x3F;
                res.write(encTable[c]);
                continue;
            }
            res.write(95);
        }
        return res.toByteArray();
    }

    public static byte[] decode(byte[] bytes) {
        int inputLength = bytes.length;
        if (inputLength % 4 != 0) {
            return bytes;
        }
        int rsize = (inputLength / 4 + 1) * 3;
        ByteArrayOutputStream res = new ByteArrayOutputStream(rsize);
        try {
            for (int i = 0; i < inputLength; ++i) {
                byte b = web64DecodeTable[bytes[i++]];
                byte b1 = web64DecodeTable[bytes[i++]];
                b = (byte)(b << 2 & 0xFC | b1 >> 4 & 3);
                res.write(b);
                if (i == inputLength - 2 && bytes[i] == 95 && bytes[i + 1] == 95) break;
                b = web64DecodeTable[bytes[i++]];
                b1 = (byte)(b1 << 4 & 0xF0 | b >> 2 & 0xF);
                res.write(b1);
                if (i == inputLength - 1 && bytes[i] == 95) break;
                b1 = web64DecodeTable[bytes[i]];
                b = (byte)(b << 6 & 0xC0 | b1 & 0x3F);
                res.write(b);
            }
            return res.toByteArray();
        }
        catch (Exception e) {
            return bytes;
        }
    }
}

