/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf.common;

import java.util.HashSet;

public class ValidDomainManager {
    private final HashSet<String> m_validExactDomains = new HashSet();
    private final HashSet<String> m_validHighLevelDomains = new HashSet();

    public boolean addDomain(String value) {
        boolean ret = false;
        if (value.startsWith(".")) {
            this.m_validExactDomains.add(value);
            ret = true;
        } else if (value.startsWith("*.")) {
            this.m_validHighLevelDomains.add(value.substring(1));
            ret = true;
        }
        return ret;
    }

    public void clear() {
        this.m_validExactDomains.clear();
        this.m_validHighLevelDomains.clear();
    }

    public HashSet<String> getValidDomains() {
        HashSet<String> combinedSet = new HashSet<String>();
        combinedSet.addAll(this.m_validExactDomains);
        combinedSet.addAll(this.m_validHighLevelDomains);
        return combinedSet;
    }

    public boolean isValid(String domain) {
        boolean ret = false;
        if (this.m_validExactDomains.contains(domain)) {
            ret = true;
        } else {
            for (String validHighLevelDomain : this.m_validHighLevelDomains) {
                if (!domain.endsWith(validHighLevelDomain)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("validExactDomains=");
        sb.append(this.m_validExactDomains.toString());
        sb.append(" validHighLevelDomains=");
        sb.append(this.m_validHighLevelDomains.toString());
        return sb.toString();
    }
}

