/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf.ext;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Set;

public class SoftHashMap
extends HashMap<Object, Object> {
    private static final long serialVersionUID = 2656179208144682184L;
    int hardSize = 4096;
    private int LRUsize = 512;
    private int LRUindex = 0;
    private Object[] simpleLRU = null;
    private Object m_mutex = new Object();

    public SoftHashMap() {
        super(100);
        this.simpleLRU = new Object[this.LRUsize];
    }

    public SoftHashMap(int lruLimit) {
        super(100);
        this.LRUsize = lruLimit;
        this.simpleLRU = new Object[this.LRUsize];
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        Object result = null;
        SoftReference sr = (SoftReference)super.get(key);
        if (sr != null) {
            result = sr.get();
            if (result != null) {
                Object object = this.m_mutex;
                synchronized (object) {
                    this.simpleLRU[this.LRUindex] = result;
                    this.LRUindex = (this.LRUindex + 1) % this.LRUsize;
                }
            }
            Object object = this.m_mutex;
            synchronized (object) {
                super.remove(key);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        Object object = this.m_mutex;
        synchronized (object) {
            if (super.size() > this.hardSize) {
                super.clear();
                this.simpleLRU = new Object[this.LRUsize];
                this.LRUindex = 0;
            }
            this.simpleLRU[this.LRUindex] = value;
            this.LRUindex = (this.LRUindex + 1) % this.LRUsize;
            return super.put(key, new SoftReference<Object>(value));
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.simpleLRU = new Object[this.LRUsize];
        this.LRUindex = 0;
    }
}

