/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf.rule;

import com.cognos.caf.CAFPatternCache;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.rule.CAFRuleException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class CAFPattern {
    private static final String patterndef = "patterndef";
    private static final String pattern = "pattern";
    private static final String patternref = "patternref";
    private static final String nameAttribute = "name";
    private static final String valueAttribute = "value";
    private static final String overrideAttribute = "override";
    private static final String rejectAttribute = "reject";
    private static final String substituteAttribute = "substitute";
    private static final String substitutestrAttribute = "substitutestr";
    public boolean m_override = false;
    public boolean m_reject = false;
    public boolean m_reference = false;
    public String m_name = null;
    public String m_value = null;
    public boolean m_substitute = false;
    public String m_substitutestr = null;

    private CAFPattern() {
    }

    public static CAFPattern parse(XMLStreamReader staxStreamReader) throws CAFException, XMLStreamException {
        int event = staxStreamReader.getEventType();
        CAFPattern cafPattern = null;
        if (event == 1) {
            if (patterndef.equalsIgnoreCase(staxStreamReader.getLocalName()) || pattern.equalsIgnoreCase(staxStreamReader.getLocalName()) || patternref.equalsIgnoreCase(staxStreamReader.getLocalName())) {
                cafPattern = new CAFPattern();
                cafPattern.m_reference = patternref.equalsIgnoreCase(staxStreamReader.getLocalName());
                int attributeCount = staxStreamReader.getAttributeCount();
                for (int k = 0; k < attributeCount; ++k) {
                    String localName = staxStreamReader.getAttributeName(k).getLocalPart();
                    if (nameAttribute.equalsIgnoreCase(localName)) {
                        cafPattern.m_name = staxStreamReader.getAttributeValue(k);
                        continue;
                    }
                    if (valueAttribute.equalsIgnoreCase(localName)) {
                        cafPattern.m_value = staxStreamReader.getAttributeValue(k);
                        CAFPatternCache.precompile(cafPattern.m_value);
                        continue;
                    }
                    if (overrideAttribute.equalsIgnoreCase(localName)) {
                        String override = staxStreamReader.getAttributeValue(k);
                        if (override != null) {
                            cafPattern.m_override = override.equals("true");
                            continue;
                        }
                        cafPattern.m_override = false;
                        continue;
                    }
                    if (rejectAttribute.equalsIgnoreCase(localName)) {
                        String reject = staxStreamReader.getAttributeValue(k);
                        if (reject != null) {
                            cafPattern.m_reject = reject.equals("true");
                            continue;
                        }
                        cafPattern.m_reject = false;
                        continue;
                    }
                    if (substituteAttribute.equalsIgnoreCase(localName)) {
                        String substitute = staxStreamReader.getAttributeValue(k);
                        if (substitute != null) {
                            cafPattern.m_substitute = substitute.equals("true");
                            continue;
                        }
                        cafPattern.m_substitute = false;
                        continue;
                    }
                    if (!substitutestrAttribute.equalsIgnoreCase(localName)) continue;
                    cafPattern.m_substitutestr = staxStreamReader.getAttributeValue(k);
                    System.out.println("substitute = " + cafPattern.m_substitute);
                }
            }
            if (cafPattern != null) {
                if (cafPattern.m_substitute && (cafPattern.m_override || cafPattern.m_reject)) {
                    throw new CAFRuleException(23);
                }
                if (cafPattern.m_value == null && !cafPattern.m_reference) {
                    throw new CAFRuleException(2);
                }
            }
        }
        return cafPattern;
    }

    CAFPattern(String referenceName, boolean reject) throws CAFException {
        try {
            this.m_name = referenceName;
            this.m_reject = reject;
            this.m_reference = true;
        }
        catch (Exception ex) {
            throw new CAFRuleException(ex, 66);
        }
    }
}

