/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf.rule;

import com.cognos.caf.CAFPatternCache;
import com.cognos.caf.CAFRequestObject;
import com.cognos.caf.common.CAFBooleanHolder;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.common.CAFUtil;
import com.cognos.caf.common.CAFValidationData;
import com.cognos.caf.config.CAFConfig;
import com.cognos.caf.logging.CAFLog;
import com.cognos.caf.rule.CAFPattern;
import com.cognos.caf.rule.CAFRuleException;
import com.cognos.caf.rule.CAFValidationRule;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.dom4j.Dom4jEnvelope;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Document;
import org.dom4j.Element;

public class CAFRules {
    private static final String RULES_FILE = "cafrules.bin";
    private static boolean m_cookieRules = false;
    protected static HashMap<String, CAFValidationRule> m_cookies = new HashMap();
    protected static HashMap<String, CAFValidationRule> m_variables = new HashMap();
    protected static HashMap<String, CAFValidationRule> m_dynvariables = new HashMap();
    protected static List<CAFValidationRule> m_xmlRules = new LinkedList<CAFValidationRule>();
    protected static HashMap<String, CAFPattern> allPatterns = new HashMap();

    public static void parse(XMLStreamReader staxStreamReader) throws XMLStreamException, CAFException {
        boolean rulesSection = true;
        String rules = "cafrules";
        String patterndefs = "patterndefs";
        String cookies = "cookies";
        String variables = "variables";
        String dynvariables = "dynvariables";
        String xmlrules = "xmlrules";
        while (staxStreamReader.hasNext()) {
            int event = staxStreamReader.next();
            if (event != 1) continue;
            String localName = staxStreamReader.getLocalName();
            if ("cafrules".equalsIgnoreCase(localName)) {
                rulesSection = true;
                continue;
            }
            if (rulesSection && "patterndefs".equalsIgnoreCase(localName)) {
                CAFRules.parsePatternDefs(staxStreamReader);
                continue;
            }
            if (rulesSection && "cookies".equalsIgnoreCase(localName)) {
                CAFRules.parseCookies(staxStreamReader);
                continue;
            }
            if (rulesSection && "variables".equalsIgnoreCase(localName)) {
                CAFRules.parseVariables(staxStreamReader);
                continue;
            }
            if (rulesSection && "dynvariables".equalsIgnoreCase(localName)) {
                CAFRules.parseDynamicVariables(staxStreamReader);
                continue;
            }
            if (!rulesSection || !"xmlrules".equalsIgnoreCase(localName)) continue;
            CAFRules.parseXMLRules(staxStreamReader);
        }
    }

    private static void parsePatternDefs(XMLStreamReader staxStreamReader) throws CAFException, XMLStreamException {
        String patterndefs = "patterndefs";
        String patterndef = "patterndef";
        int count = 0;
        if ("patterndefs".equalsIgnoreCase(staxStreamReader.getLocalName())) {
            while (staxStreamReader.hasNext()) {
                String localName;
                int event = staxStreamReader.next();
                if (event == 1) {
                    CAFPattern cafPattern;
                    localName = staxStreamReader.getLocalName();
                    if (!"patterndef".equalsIgnoreCase(localName) || (cafPattern = CAFPattern.parse(staxStreamReader)) == null) continue;
                    ++count;
                    CAFPatternCache.addNamedPattern(cafPattern);
                    allPatterns.put(cafPattern.m_name, cafPattern);
                    continue;
                }
                if (event != 2 || !"patterndefs".equalsIgnoreCase(localName = staxStreamReader.getLocalName())) continue;
                break;
            }
            System.out.println(count + " pattern definitions were found!");
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("pattern definitions", "count", String.valueOf(count), 50000, "rule");
            }
        }
    }

    private static void parseCookies(XMLStreamReader staxStreamReader) throws CAFException, XMLStreamException {
        String cookies = "cookies";
        String cookie = "cookie";
        int count = 0;
        if ("cookies".equalsIgnoreCase(staxStreamReader.getLocalName())) {
            while (staxStreamReader.hasNext()) {
                String localName;
                int event = staxStreamReader.next();
                if (event == 1) {
                    localName = staxStreamReader.getLocalName();
                    if (!"cookie".equalsIgnoreCase(localName)) continue;
                    CAFValidationRule validationRule = CAFValidationRule.parse(staxStreamReader);
                    ++count;
                    m_cookies.put(validationRule.getName(), validationRule);
                    continue;
                }
                if (event != 2 || !"cookies".equalsIgnoreCase(localName = staxStreamReader.getLocalName())) continue;
                break;
            }
            if (count > 0) {
                m_cookieRules = true;
            }
            System.out.println(count + " cookies rules were found!");
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("cookie rules", "count", String.valueOf(count), 50000, "rule");
            }
        }
    }

    private static void parseVariables(XMLStreamReader staxStreamReader) throws CAFException, XMLStreamException {
        String variables = "variables";
        String variable = "variable";
        int count = 0;
        if ("variables".equalsIgnoreCase(staxStreamReader.getLocalName())) {
            while (staxStreamReader.hasNext()) {
                String localName;
                int event = staxStreamReader.next();
                if (event == 1) {
                    localName = staxStreamReader.getLocalName();
                    if (!"variable".equalsIgnoreCase(localName)) continue;
                    CAFValidationRule validationRule = CAFValidationRule.parse(staxStreamReader);
                    ++count;
                    m_variables.put(validationRule.getName(), validationRule);
                    continue;
                }
                if (event != 2 || !"variables".equalsIgnoreCase(localName = staxStreamReader.getLocalName())) continue;
                break;
            }
            System.out.println(count + " variables rules were found!");
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("variable rules", "count", String.valueOf(count), 50000, "rule");
            }
        }
    }

    private static void parseDynamicVariables(XMLStreamReader staxStreamReader) throws CAFException, XMLStreamException {
        String dynvariables = "dynvariables";
        String dynvariable = "dynvariable";
        int count = 0;
        if ("dynvariables".equalsIgnoreCase(staxStreamReader.getLocalName())) {
            while (staxStreamReader.hasNext()) {
                String localName;
                int event = staxStreamReader.next();
                if (event == 1) {
                    localName = staxStreamReader.getLocalName();
                    if (!"dynvariable".equalsIgnoreCase(localName)) continue;
                    CAFValidationRule validationRule = CAFValidationRule.parse(staxStreamReader);
                    ++count;
                    m_dynvariables.put(validationRule.getName(), validationRule);
                    continue;
                }
                if (event != 2 || !"dynvariables".equalsIgnoreCase(localName = staxStreamReader.getLocalName())) continue;
                break;
            }
            System.out.println(count + " dynamic variables rules were found!");
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("dynamic variable rules", "count", String.valueOf(count), 50000, "rule");
            }
        }
    }

    private static void parseXMLRules(XMLStreamReader staxStreamReader) throws CAFException, XMLStreamException {
        String xmlrules = "xmlrules";
        String xmlrule = "xmlrule";
        int count = 0;
        if ("xmlrules".equalsIgnoreCase(staxStreamReader.getLocalName())) {
            while (staxStreamReader.hasNext()) {
                String localName;
                int event = staxStreamReader.next();
                if (event == 1) {
                    localName = staxStreamReader.getLocalName();
                    if (!"xmlrule".equalsIgnoreCase(localName)) continue;
                    ++count;
                    CAFValidationRule validationRule = CAFValidationRule.parse(staxStreamReader);
                    m_xmlRules.add(validationRule);
                    continue;
                }
                if (event != 2 || !"xmlrules".equalsIgnoreCase(localName = staxStreamReader.getLocalName())) continue;
                break;
            }
        }
        System.out.println(count + " xml rules were found!");
        if (CAFLog.isTracingEnabled) {
            CAFLog.trace("dynamic variable rules", "count", String.valueOf(count), 50000, "rule");
        }
    }

    private static byte[] processObfuscatedFile(InputStream is) throws CAFException {
        try {
            int i;
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA");
            }
            catch (Exception e) {
                throw new CAFRuleException(e);
            }
            int SHA_DIGEST_LEN = md.getDigestLength();
            byte[] hexSignature = new byte[SHA_DIGEST_LEN * 2];
            int count = -1;
            try {
                count = is.read(hexSignature);
            }
            catch (Exception e) {
                throw new CAFRuleException(e);
            }
            if (count != SHA_DIGEST_LEN * 2) {
                throw new CAFRuleException(4);
            }
            byte[] byteSignature = CAFUtil.hexToByte(hexSignature);
            byte[] byteBuf = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                while ((count = is.read(byteBuf)) > 0) {
                    baos.write(byteBuf, 0, count);
                }
            }
            catch (Exception e) {
                throw new CAFRuleException(e);
            }
            byte[] content = baos.toByteArray();
            md.update(content);
            byte[] digest = md.digest();
            if (digest.length == byteSignature.length) {
                for (i = 0; i < digest.length; ++i) {
                    if (digest[i] == byteSignature[i]) continue;
                    throw new CAFRuleException(3);
                }
            }
            for (i = 0; i < content.length; ++i) {
                content[i] = (byte)(content[i] == 0 ? 0 : 256 - content[i]);
            }
            return content;
        }
        catch (Exception e) {
            throw new CAFRuleException(e, 17);
        }
    }

    public static void initialize(String cafDirPath) throws CAFException {
        try {
            File file = new File(cafDirPath, RULES_FILE);
            if (!file.canRead()) {
                CAFLog.error("cannot read file", "filename", file.getAbsolutePath());
                throw new CAFRuleException(0);
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
            }
            catch (Exception e) {
                throw new CAFRuleException(e, 5);
            }
            byte[] content = CAFRules.processObfuscatedFile(is);
            ByteArrayInputStream bais = new ByteArrayInputStream(content);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLStreamReader staxStreamReader = inputFactory.createXMLStreamReader(bais);
            CAFRules.parse(staxStreamReader);
        }
        catch (Exception e) {
            throw new CAFRuleException(e, 1);
        }
    }

    private static boolean containsInvalidChar(char[] str, String validChars) throws CAFException {
        try {
            boolean res = false;
            long strLen = str.length;
            char c = '\u0000';
            int i = 0;
            while (!res && (long)i < strLen) {
                c = str[i];
                if (c < ' ' && c != '\t' && c != '\n' && c != '\r' && (validChars == null || validChars.indexOf(c) == -1)) {
                    res = true;
                    CAFLog.error("Invalid character found", "character", String.valueOf((int)str[i]));
                }
                ++i;
            }
            return res;
        }
        catch (Exception e) {
            throw new CAFRuleException(e, 9);
        }
    }

    private static boolean isElementValid(CAFValidationData valData, CAFValidationRule rule, CAFRequestObject requestObject) throws CAFException {
        try {
            boolean valid = true;
            CAFBooleanHolder overrideResult = new CAFBooleanHolder(false);
            String validChars = null;
            if (rule != null) {
                validChars = rule.getValidChars();
                if (valData.value.length() > rule.getMaxLength()) {
                    valid = false;
                    CAFLog.error("value length greater than rule maximum", "value length", String.valueOf(valData.value.length()), "maximum length", String.valueOf(rule.getMaxLength()));
                    CAFLog.error("is element valid failed", "name", valData.name, "value", valData.value);
                }
                if (valid) {
                    valData.value = rule.applySubstitutePatterns(valData.value);
                    boolean bl = valid = !CAFRules.containsInvalidChar(valData.value.toCharArray(), validChars);
                }
                if (valid) {
                    valid = rule.isValueValid(valData, overrideResult, requestObject);
                }
            }
            if (valid && !overrideResult.value && CAFConfig.m_globalRejectionPattern != null && CAFPatternCache.match(CAFConfig.m_globalRejectionPattern, valData.value)) {
                CAFLog.error("global rejection pattern match", "rejection pattern", CAFConfig.m_globalRejectionPattern);
                valid = false;
            }
            return valid;
        }
        catch (Exception e) {
            throw new CAFRuleException(e, 13);
        }
    }

    private static boolean isElementValidApi(CAFValidationData valData, CAFValidationRule rule) throws CAFException {
        try {
            boolean valid = true;
            if (CAFConfig.m_validationEnabled) {
                CAFBooleanHolder overrideResult = new CAFBooleanHolder(false);
                String validChars = null;
                if (rule != null) {
                    validChars = rule.getValidChars();
                }
                if (validChars == null) {
                    validChars = new String();
                }
                if (valid) {
                    if (rule != null) {
                        if (valData.value.length() > rule.getMaxLength()) {
                            valid = false;
                            CAFLog.error("value length greater than rule maximum", "value length", String.valueOf(valData.value.length()), "maximum length", String.valueOf(rule.getMaxLength()));
                        }
                        if (!valid) {
                            CAFLog.error("is element valid failed", "name", valData.name, "value", valData.value);
                        }
                    }
                    if (valid && rule != null) {
                        valData.value = rule.applySubstitutePatterns(valData.value);
                    }
                    if (valid) {
                        overrideResult.value = false;
                        boolean bl = valid = !CAFRules.containsInvalidChar(valData.value.toCharArray(), validChars);
                    }
                    if (valid && rule != null) {
                        valid = rule.isValueValidApi(valData, overrideResult);
                    }
                    if (valid && !overrideResult.value && CAFConfig.m_globalRejectionPattern != null && CAFPatternCache.match(CAFConfig.m_globalRejectionPattern, valData.value)) {
                        CAFLog.error("global rejection pattern match", "rejection pattern", CAFConfig.m_globalRejectionPattern);
                        valid = false;
                    }
                }
            }
            return valid;
        }
        catch (Exception e) {
            throw new CAFRuleException(e, 13);
        }
    }

    private static CAFValidationRule lookupDynamicVariable(String name, StringBuffer matchedPatternName) throws CAFException {
        try {
            for (String patternname : m_dynvariables.keySet()) {
                if (!CAFPatternCache.matchByPatternName(name, patternname)) continue;
                if (matchedPatternName != null) {
                    matchedPatternName.append(patternname);
                }
                return m_dynvariables.get(patternname);
            }
            return null;
        }
        catch (Exception e) {
            CAFLog.error("lookup dynamic variable failed", "name", name);
            throw new CAFRuleException(e, 71);
        }
    }

    private static boolean findDynamicVariableRule(CAFValidationRule rule, String decName_lc) throws CAFException {
        boolean dynamicVar = false;
        if (rule == null) {
            String subName = null;
            if (decName_lc.startsWith("o_")) {
                subName = decName_lc.substring(2);
            } else if (decName_lc.startsWith("m_pc_n_")) {
                subName = "m_pc_a_";
                subName = subName + decName_lc.substring(7);
            }
            if (subName != null) {
                rule = m_variables.get(subName);
                if (CAFLog.isTracingEnabled) {
                    CAFLog.trace("rule name substitution", "original name", decName_lc, "substituted name", subName, 30000, "rule");
                }
                if (rule == null && (rule = CAFRules.lookupDynamicVariable(subName, null)) != null) {
                    dynamicVar = true;
                }
            }
            if (rule == null && (rule = CAFRules.lookupDynamicVariable(decName_lc, null)) != null) {
                dynamicVar = true;
            }
        }
        return dynamicVar;
    }

    public static boolean isVariableValid(CAFValidationData valData, CAFRequestObject requestObject) throws CAFException {
        try {
            boolean valid = true;
            boolean dynamicVar = false;
            if (CAFConfig.m_validationEnabled && m_variables != null) {
                String decName_lc = valData.name.toLowerCase();
                boolean checkSignature = false;
                String ruleSignOverride = "";
                boolean signOverrideActive = false;
                CAFValidationRule rule = m_variables.get(decName_lc);
                if (rule == null) {
                    dynamicVar = CAFRules.findDynamicVariableRule(rule, decName_lc);
                }
                if (rule != null) {
                    String unwrapContextId;
                    String contextIdPattern;
                    if (valid && rule.getPostOnly() && requestObject.getRequest()) {
                        valid = false;
                        CAFLog.error("variable only valid in POST requests");
                    }
                    String string = contextIdPattern = rule == null ? null : rule.getContextIdPattern();
                    if (valid && CAFConfig.m_extendedContextId && contextIdPattern != null && CAFPatternCache.match(valData.value, contextIdPattern) && (unwrapContextId = requestObject.getUnwrapContextId()) == null) {
                        valid = false;
                        CAFLog.error("extended context id enabled - context id required for this variable");
                    }
                    if (valid && CAFConfig.m_tpParametersBlocked && rule.getThirdParty()) {
                        valid = false;
                        CAFLog.error("name flagged as third party and third party parameters rejection enabled");
                    }
                    if (valid) {
                        ruleSignOverride = rule.getSignOverride();
                        if (ruleSignOverride != null) {
                            unwrapContextId = requestObject.getUnwrapContextId();
                            boolean bl = signOverrideActive = unwrapContextId != null && ruleSignOverride.equals(unwrapContextId);
                            if (!signOverrideActive) {
                                boolean bl2 = signOverrideActive = unwrapContextId != null && "ans".equals(unwrapContextId);
                            }
                            if (CAFLog.isTracingEnabled) {
                                String msg = "variable flagged for potential signature override";
                                CAFLog.trace(msg, "rule sign override", ruleSignOverride, "context id component", unwrapContextId, 10000, "rule");
                                CAFLog.trace(msg, "override active", String.valueOf(signOverrideActive), 10000, "rule");
                            }
                        }
                        boolean sign = rule.getSign();
                        if (!signOverrideActive && sign && valData.value.length() > 0) {
                            valData.sign = true;
                        }
                    }
                }
                if (valid && !checkSignature && !CAFRules.isElementValid(valData, rule, requestObject)) {
                    valid = false;
                }
                if (!valid && dynamicVar) {
                    StringBuffer matchedPatternName = new StringBuffer(256);
                    rule = CAFRules.lookupDynamicVariable(decName_lc, matchedPatternName);
                    CAFLog.error("Dynamic sub-variable pattern match", "pattern name", matchedPatternName.toString());
                }
            }
            return valid;
        }
        catch (Exception e) {
            CAFLog.error("is variable valid failed", "name", valData.name, "value", valData.value);
            throw new CAFRuleException(e, 14);
        }
    }

    public static boolean isVariableValidApi(CAFValidationData valData) throws CAFException {
        try {
            boolean valid = true;
            if (CAFConfig.m_validationEnabled) {
                boolean dynamicVar = false;
                if (CAFConfig.m_validationEnabled && m_variables != null) {
                    String decName_lc = valData.name.toLowerCase();
                    CAFValidationRule rule = m_variables.get(decName_lc);
                    if (rule == null) {
                        String subName = null;
                        if (decName_lc.startsWith("o_")) {
                            subName = decName_lc.substring(2);
                        } else if (decName_lc.startsWith("m_pc_n_")) {
                            subName = "m_pc_a_";
                            subName = subName + decName_lc.substring(7);
                        }
                        if (subName != null) {
                            rule = m_variables.get(subName);
                            if (CAFLog.isTracingEnabled) {
                                CAFLog.trace("rule name substitution", "original name", decName_lc, "substituted name", subName, 30000, "rule");
                            }
                            if (rule == null && (rule = CAFRules.lookupDynamicVariable(subName, null)) != null) {
                                dynamicVar = true;
                            }
                        }
                    }
                    if (rule == null && (rule = CAFRules.lookupDynamicVariable(decName_lc, null)) != null) {
                        dynamicVar = true;
                    }
                    if (valid && rule != null && CAFConfig.m_tpParametersBlocked && rule.getThirdParty()) {
                        valid = false;
                        CAFLog.error("name flagged as third party and third party parameters rejection enabled");
                    }
                    if (!CAFRules.isElementValidApi(valData, rule)) {
                        valid = false;
                    }
                    if (!valid && dynamicVar) {
                        StringBuffer matchedPatternName = new StringBuffer(256);
                        rule = CAFRules.lookupDynamicVariable(decName_lc, matchedPatternName);
                        CAFLog.error("Dynamic sub-variable pattern match", "pattern name", matchedPatternName.toString());
                    }
                }
                return valid;
            }
            return true;
        }
        catch (Exception e) {
            CAFLog.error("is variable valid failed", "name", valData.name, "value", valData.value);
            throw new CAFRuleException(e, 14);
        }
    }

    public static boolean isCookieValid(CAFValidationData valData, CAFRequestObject requestObject) throws CAFException {
        try {
            boolean valid = true;
            if (CAFConfig.m_validationEnabled && m_cookies != null) {
                CAFValidationRule rule = m_cookies.get(valData.name.toLowerCase());
                if (!CAFRules.isElementValid(valData, rule, null)) {
                    valid = false;
                }
                if (!valid) {
                    CAFLog.error("invalid cookie", "value", valData.value);
                    CAFLog.error("invalid cookie", "name", valData.name, "value", valData.value);
                }
            }
            return valid;
        }
        catch (Exception e) {
            throw new CAFRuleException(e, 15);
        }
    }

    public static boolean validateDocument(BIBusEnvelope envelope, CAFRequestObject requestObject) throws CAFException {
        try {
            boolean valid = true;
            if (envelope instanceof Dom4jEnvelope) {
                Document doc = envelope.getAsDocument();
                if (!m_xmlRules.isEmpty()) {
                    CAFValidationData valData = new CAFValidationData();
                    Iterator<CAFValidationRule> i = m_xmlRules.iterator();
                    while (valid && i.hasNext()) {
                        CAFValidationRule rule = i.next();
                        String xpath = rule.getXpath();
                        List elements = doc.selectNodes(xpath);
                        if (elements == null) continue;
                        Iterator j = elements.iterator();
                        while (valid && j.hasNext()) {
                            Element element = (Element)j.next();
                            valData.reset();
                            valData.name = element.getName();
                            valData.value = element.getText();
                            if (CAFRules.isElementValid(valData, rule, requestObject)) continue;
                            valid = false;
                        }
                    }
                }
            }
            return valid;
        }
        catch (Exception e) {
            throw new CAFRuleException(e, 74);
        }
    }

    public static boolean cookieRules() {
        return m_cookieRules;
    }
}

