/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS;

import com.cognos.pogo.bibus.RequestAffinity;
import com.cognos.pogo.reportservice.ProcessList;
import com.cognos.pogo.reportservice.ReportServerConnection;
import com.cognos.pogo.reportservice.ReportServerQueueCallback;
import com.ibm.cognos.camaaa.internal.LPS.LPServerConnection;
import java.rmi.NoSuchObjectException;
import java.util.Iterator;
import java.util.LinkedList;

public class LPSConnectionQueue
implements ReportServerQueueCallback {
    private static final long ONE_MINUTE_IN_MILISEC = 60000L;
    private final LinkedList<ConnectionQueueItem> connectionQueue = new LinkedList();
    private long defaultTimeout = 60000L;
    private ProcessList processList;

    public LPServerConnection getConnection() throws NoSuchObjectException {
        return this.getConnection(RequestAffinity.NONE, 0);
    }

    public LPServerConnection getConnection(int processID) throws NoSuchObjectException {
        return this.getConnection(RequestAffinity.ABSOLUTE, processID);
    }

    public int getNonAffineQueueSize() {
        return this.getQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        LinkedList<ConnectionQueueItem> linkedList = this.connectionQueue;
        synchronized (linkedList) {
            return this.connectionQueue.size();
        }
    }

    public void setDefaultTimeout(long timeout) {
        this.defaultTimeout = timeout;
    }

    public void setProcessList(ProcessList aProcessList) {
        this.processList = aProcessList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestAffinity wakeNextRequest(ReportServerConnection connection, int processID) {
        LinkedList<ConnectionQueueItem> linkedList = this.connectionQueue;
        synchronized (linkedList) {
            if (this.connectionQueue.size() > 0) {
                ConnectionQueueItem queueItem;
                while ((queueItem = this.getNextQueueItem(processID)) != null) {
                    ConnectionQueueItem connectionQueueItem = queueItem;
                    synchronized (connectionQueueItem) {
                        if (queueItem.connection == null) {
                            queueItem.connection = (LPServerConnection)connection;
                            queueItem.notify();
                            return queueItem.requestAffinity;
                        }
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LPServerConnection getConnection(RequestAffinity requestAffinity, int processID) throws NoSuchObjectException {
        ConnectionQueueItem connectionQueueItem = new ConnectionQueueItem();
        LinkedList<ConnectionQueueItem> linkedList = this.connectionQueue;
        synchronized (linkedList) {
            try {
                LPServerConnection connection = requestAffinity == RequestAffinity.NONE ? (LPServerConnection)this.processList.getNonAffineConnection() : (LPServerConnection)this.processList.getAffineConnection(processID, requestAffinity);
                if (connection != null) {
                    return connection;
                }
            }
            catch (NoSuchObjectException e) {
                this.processList.createAnotherProcess();
                throw e;
            }
            connectionQueueItem.processID = processID;
            connectionQueueItem.requestAffinity = requestAffinity;
            this.connectionQueue.add(connectionQueueItem);
            this.processList.createAnotherProcess();
        }
        linkedList = connectionQueueItem;
        synchronized (linkedList) {
            try {
                if (connectionQueueItem.connection == null) {
                    connectionQueueItem.wait(this.defaultTimeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        linkedList = this.connectionQueue;
        synchronized (linkedList) {
            this.connectionQueue.remove(connectionQueueItem);
        }
        return connectionQueueItem.connection;
    }

    private ConnectionQueueItem getNextQueueItem(int processID) {
        ConnectionQueueItem foundItem = null;
        Iterator it = this.connectionQueue.iterator();
        while (it.hasNext()) {
            ConnectionQueueItem item = (ConnectionQueueItem)it.next();
            if (item.requestAffinity == RequestAffinity.NONE) {
                foundItem = item;
                it.remove();
                break;
            }
            if (processID != item.processID) continue;
            foundItem = item;
            it.remove();
            break;
        }
        return foundItem;
    }

    private final class ConnectionQueueItem {
        private LPServerConnection connection;
        private RequestAffinity requestAffinity;
        private int processID;

        private ConnectionQueueItem() {
        }
    }
}

