/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.ibm.cognos.camaaa.internal.LPS.LPSInstance;
import com.ibm.cognos.camaaa.internal.LPS.LPSProcessManager;
import com.ibm.cognos.camaaa.internal.LPS.LPServerConnection;
import com.ibm.cognos.camaaa.internal.LPS.commands.LPSCommand;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.File;
import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LPSInstanceImpl
implements LPSInstance {
    private static final String LPS_SERVER_FAILED_NOT_200 = "LPS Server failed to receive a request, status not 200";
    private static final int RETRY_COUNT = 3;
    private static final String LPS_DIR = ".";
    private static final String LPS_COMMAND_PREFIX = "CAM_LPSvr";
    private LPSProcessManager processManager;
    private Configuration configuration;

    public LPSInstanceImpl(Configuration theConfiguration) {
        this.configuration = theConfiguration;
    }

    void configureRuntime(Configuration theConfiguration) throws LocalizableException {
        try {
            String runtimeConfig = CCLConfigurationFactory.getInstance().export();
            Element configAsElement = DocumentHelper.parseText((String)runtimeConfig).getRootElement();
            this.processManager.setCclConfiguration(configAsElement);
        }
        catch (CCLConfigurationException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"), (Throwable)e);
        }
        catch (DocumentException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"), (Throwable)e);
        }
        this.configuration = theConfiguration;
        this.processManager.setWorkingDirectory(this.configuration.getAbsolutePath(LPS_DIR));
        this.processManager.useNewConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(LPSCommand command) throws LocalizableException {
        ArrayList<LocalizableException> failures = new ArrayList<LocalizableException>();
        LPServerConnection connection = null;
        for (int retryCount = 0; retryCount < 3; ++retryCount) {
            try {
                connection = this.getConnection(command);
                int rc = connection.sendRequest(command);
                int httpok = 200;
                if (rc != 200) {
                    throw new IOException(LPS_SERVER_FAILED_NOT_200);
                }
                command.parseResponse(connection.getContentLimitedInputStream());
                failures.clear();
                break;
            }
            catch (IllegalStateException e) {
                failures.add(new LocalizableException((LocalizableMessage)new Message("AAA_LPS_BROKEN_CONNECTION"), (Throwable)e));
                continue;
            }
            catch (LocalizableException e) {
                failures.clear();
                failures.add(e);
                break;
            }
            catch (IOException e) {
                failures.add(new LocalizableException((LocalizableMessage)new Message("AAA_LPS_BROKEN_CONNECTION"), (Throwable)e));
                continue;
            }
            finally {
                if (connection != null && !connection.isDisposed()) {
                    connection.release();
                }
            }
        }
        if (!failures.isEmpty()) {
            throw (LocalizableException)((Object)failures.get(0));
        }
    }

    private LPServerConnection getConnection(LPSCommand command) throws NoSuchObjectException {
        LPServerConnection connection = this.processManager.getConnectionQueue().getConnection();
        if (connection == null) {
            throw new NoSuchObjectException("could not get connection to LPS");
        }
        return connection;
    }

    private static boolean isOsWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.indexOf("indows") != -1;
    }

    private String getExecutableName() {
        String executableName = LPSInstanceImpl.isOsWindows() ? "CAM_LPSvr.exe" : LPS_COMMAND_PREFIX;
        return this.configuration.getAbsolutePath(this.getWorkingDirectory() + File.separator + executableName);
    }

    protected int getProcessExecutionMode() {
        return 2;
    }

    protected String getWorkingDirectory() {
        return LPS_DIR;
    }

    @Override
    public void initialize(String instanceName, int connections, int threadStackSize, String host, int port, boolean useSSL) throws LocalizableException {
        String executablePath = this.getExecutableName();
        String cogRoot = this.configuration.getAbsolutePath("..");
        int executionMode = this.getProcessExecutionMode();
        int computedConnectionCount = connections > 0 ? connections : this.getDefaultConnectionsPerProcess(executionMode);
        this.processManager = new LPSProcessManager(executablePath, cogRoot, computedConnectionCount, useSSL, instanceName, threadStackSize, host, port, executionMode);
        this.configureRuntime(this.configuration);
        this.processManager.start();
    }

    int getDefaultConnectionsPerProcess(int executionMode) {
        Boolean osArchContains64 = System.getProperty("os.arch").indexOf("64") == -1;
        if ((!LPSInstanceImpl.isOsWindows() || osArchContains64.booleanValue()) && executionMode == 2) {
            return 64;
        }
        return 32;
    }

    @Override
    public void setConfigForRestart(LPSCommand[] commands) {
        this.processManager.setConfigureRequests(commands);
    }

    @Override
    public void terminate() {
        if (this.processManager != null) {
            this.processManager.shutdown();
        }
        this.processManager = null;
    }
}

