/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS;

import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.StandaloneServerConnection;
import com.cognos.pogo.reportservice.ProcessFacade;
import com.cognos.pogo.reportservice.ProcessManager;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.reportservice.ReportServerQueueCallback;
import com.ibm.cognos.camaaa.internal.LPS.CAMRSComponentFactory;
import com.ibm.cognos.camaaa.internal.LPS.LPServerConnection;
import com.ibm.cognos.camaaa.internal.LPS.commands.LPSCommand;
import java.io.IOException;
import java.io.InputStream;
import org.dom4j.Element;

class LPSProcessFacade
extends ProcessFacade {
    public LPSProcessFacade(CAMRSComponentFactory componentfactory, String[] args, Element config, String host, int port, boolean ssl, int pid, ReportServerQueueCallback callback, int maxAffineConnectionCount, int maxNonAffineConnectionCount, Element cclconfig, ProcessManager theManager) throws Exception {
        super((RSComponentFactory)componentfactory, args, config, host, port, ssl, pid, callback, maxAffineConnectionCount, maxNonAffineConnectionCount, cclconfig, theManager);
        this.resizeCancelPool(0);
    }

    private static String readResponse(StandaloneServerConnection connection) throws IOException {
        InputStream isResponse = connection.getInputStream();
        StringBuffer sb = new StringBuffer();
        if (isResponse != null) {
            int iread;
            int eightK = 8192;
            byte[] buffer = new byte[8192];
            do {
                if ((iread = isResponse.read(buffer)) <= 0) continue;
                sb.append(new String(buffer, 0, iread));
            } while (iread >= 0);
        }
        return sb.toString();
    }

    protected void configureProcess() throws IOException {
        super.configureProcess();
        CAMRSComponentFactory factory = (CAMRSComponentFactory)this.getComponentfactory();
        LPSCommand[] commands = factory.getProcessConfigureRequests();
        if (commands != null) {
            for (int i = 0; i < commands.length; ++i) {
                this.sendCommand(commands[i]);
            }
        }
    }

    protected void sendCommand(LPSCommand command) throws IOException {
        StandaloneServerConnection connection = null;
        try {
            connection = new StandaloneServerConnection(this.getReportServerHost(), this.getReportServerPort(), this.getIsSSL());
            LPServerConnection.sendRequest(command, (ServerConnection)connection);
            LPSProcessFacade.readResponse(connection);
        }
        finally {
            if (connection != null) {
                connection.release();
            }
        }
    }
}

