/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS;

import com.cognos.pogo.monitoring.QueueableRequestReporter;
import com.cognos.pogo.reportservice.ProcessManager;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.reportservice.ReportServerQueueCallback;
import com.ibm.cognos.camaaa.internal.LPS.CAMRSComponentFactory;
import com.ibm.cognos.camaaa.internal.LPS.LPSConnectionQueue;
import com.ibm.cognos.camaaa.internal.LPS.commands.LPSCommand;
import java.util.ArrayList;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

class LPSProcessManager
extends ProcessManager {
    public static final int EXECUTION_MODE_32 = 1;
    public static final int EXECUTION_MODE_NATIVE = 2;
    public static final int DEFAULT_LPS_CONNECTIONS_32BIT = 32;
    public static final int DEFAULT_LPS_CONNECTIONS_64BIT = 64;
    public static final String SERVICE_URL = "/legacy";
    static final int IDLE_TIME_LIMIT_SEC = 300;
    private static final String[][] SPECIAL_CHARS_MAP = new String[][]{{"\\*", "_ASTE_"}, {"\\?", "_QUES_"}};
    private static final int ADMIN_REQUEST_BUFFER = 3;
    private final CAMRSComponentFactory factory;
    private final QueueableRequestReporter reporter;

    LPSProcessManager(CAMRSComponentFactory compFactory, String serviceName, ReportServerQueueCallback callback, String[] args, Element config, String host, int port, boolean ssl, String instanceName) {
        super((RSComponentFactory)compFactory, serviceName, callback, args, config, host, port, ssl);
        this.getConnectionQueue().setProcessList(this.getProcessList());
        String serviceType = "CAM_LPSvr_" + this.encode(instanceName);
        this.reporter = new QueueableRequestReporter(serviceName, serviceType);
        this.setRequestReporter(this.reporter);
        this.setMinProcessCount(1);
        this.setMaxProcessCount(1);
        int shutdownTimeLimit = 300000;
        this.setShutdownTimeLimit(300000);
        this.setIdleProcessTimeout(0L, 0);
        int idleTimeLimitInMs = 300000;
        this.setProcessCleanerInterval(150000);
        this.factory = compFactory;
    }

    LPSProcessManager(String executable, String cogRoot, int connections, boolean ssl, String instanceName, int threadStackSize, String host, int port, int executionmode) {
        this(new CAMRSComponentFactory(), "CAMLPS", new LPSConnectionQueue(), LPSProcessManager.makeArgs(executable, cogRoot, ssl, threadStackSize), LPSProcessManager.makeConfig(), host, port, ssl, instanceName);
        boolean maxAffineConnections = false;
        int maxNonAffineConnections = connections;
        this.updateConnectionsPerProcess(0, maxNonAffineConnections);
        String threadsParam = "threads=";
        String[] commandLineArguments = this.getCommandLineArguments();
        for (int i = 0; i < commandLineArguments.length; ++i) {
            if (!commandLineArguments[i].startsWith("threads=")) continue;
            commandLineArguments[i] = "threads=" + (0 + maxNonAffineConnections + 3);
            this.setConfigurationChanged();
            break;
        }
        this.setExecutionMode(executionmode);
    }

    private static String[] makeArgs(String executable, String cogRoot, boolean useSSL, int threadStackSize) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(executable);
        args.add("camssl=" + useSSL);
        args.add("cam=true");
        args.add("idleTimeLimitSec=300");
        args.add("COG_ROOT=" + cogRoot);
        args.add("threads=1");
        if (threadStackSize > 0) {
            args.add("cclthreadstacksize=" + threadStackSize);
        }
        return args.toArray(new String[args.size()]);
    }

    private static Element makeConfig() {
        Element config = DocumentHelper.createElement((String)"config");
        Element handler = config.addElement("bibsrv_config").addElement("handlers").addElement("handler");
        handler.addAttribute("url_prefix", SERVICE_URL);
        handler.addAttribute("library_name", "CAM_LPS_Engine.cpi");
        handler.addAttribute("plugin_name", "CAM_LPS_Engine");
        handler.addAttribute("mode", "stream");
        return config;
    }

    private String encode(String instanceName) {
        String result = instanceName;
        for (int i = 0; i < SPECIAL_CHARS_MAP.length; ++i) {
            result = result.replaceAll(SPECIAL_CHARS_MAP[i][0], SPECIAL_CHARS_MAP[i][1]);
        }
        return result;
    }

    LPSConnectionQueue getConnectionQueue() {
        return (LPSConnectionQueue)this.getQueueCallback();
    }

    QueueableRequestReporter getQueueableRequestReporter() {
        return this.reporter;
    }

    void setConfigureRequests(LPSCommand[] commands) {
        this.factory.setProcessConfigureRequests(commands);
    }

    private void setExecutionMode(int mode) {
        String replacement;
        if (mode == 1) {
            replacement = "bin64%bin";
        } else if (mode == 2) {
            replacement = "zzzzzzzz%zzzzzzzz";
        } else {
            throw new RuntimeException("invalid execution mode: " + mode);
        }
        this.getRuntimeEnvironment().setEnvironmentReplacement(replacement);
    }
}

